% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redshift_operations.R
\name{redshift_associate_data_share_consumer}
\alias{redshift_associate_data_share_consumer}
\title{From a datashare consumer account, associates a datashare with the
account (AssociateEntireAccount) or the specified namespace
(ConsumerArn)}
\usage{
redshift_associate_data_share_consumer(
  DataShareArn,
  AssociateEntireAccount = NULL,
  ConsumerArn = NULL,
  ConsumerRegion = NULL,
  AllowWrites = NULL
)
}
\arguments{
\item{DataShareArn}{[required] The Amazon Resource Name (ARN) of the datashare that the consumer is to
use with the account or the namespace.}

\item{AssociateEntireAccount}{A value that specifies whether the datashare is associated with the
entire account.}

\item{ConsumerArn}{The Amazon Resource Name (ARN) of the consumer that is associated with
the datashare.}

\item{ConsumerRegion}{From a datashare consumer account, associates a datashare with all
existing and future namespaces in the specified Amazon Web Services
Region.}

\item{AllowWrites}{If set to true, allows write operations for a datashare.}
}
\description{
From a datashare consumer account, associates a datashare with the account (AssociateEntireAccount) or the specified namespace (ConsumerArn). If you make this association, the consumer can consume the datashare.

See \url{https://www.paws-r-sdk.com/docs/redshift_associate_data_share_consumer/} for full documentation.
}
\keyword{internal}
