% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_restore_db_instance_from_s3}
\alias{rds_restore_db_instance_from_s3}
\title{Amazon Relational Database Service (Amazon RDS) supports importing MySQL
databases by using backup files}
\usage{
rds_restore_db_instance_from_s3(
  DBName = NULL,
  DBInstanceIdentifier,
  AllocatedStorage = NULL,
  DBInstanceClass,
  Engine,
  MasterUsername = NULL,
  MasterUserPassword = NULL,
  DBSecurityGroups = NULL,
  VpcSecurityGroupIds = NULL,
  AvailabilityZone = NULL,
  DBSubnetGroupName = NULL,
  PreferredMaintenanceWindow = NULL,
  DBParameterGroupName = NULL,
  BackupRetentionPeriod = NULL,
  PreferredBackupWindow = NULL,
  Port = NULL,
  MultiAZ = NULL,
  EngineVersion = NULL,
  AutoMinorVersionUpgrade = NULL,
  LicenseModel = NULL,
  Iops = NULL,
  OptionGroupName = NULL,
  PubliclyAccessible = NULL,
  Tags = NULL,
  StorageType = NULL,
  StorageEncrypted = NULL,
  KmsKeyId = NULL,
  CopyTagsToSnapshot = NULL,
  MonitoringInterval = NULL,
  MonitoringRoleArn = NULL,
  EnableIAMDatabaseAuthentication = NULL,
  SourceEngine,
  SourceEngineVersion,
  S3BucketName,
  S3Prefix = NULL,
  S3IngestionRoleArn,
  EnablePerformanceInsights = NULL,
  PerformanceInsightsKMSKeyId = NULL,
  PerformanceInsightsRetentionPeriod = NULL,
  EnableCloudwatchLogsExports = NULL,
  ProcessorFeatures = NULL,
  UseDefaultProcessorFeatures = NULL,
  DeletionProtection = NULL,
  MaxAllocatedStorage = NULL,
  NetworkType = NULL,
  StorageThroughput = NULL,
  ManageMasterUserPassword = NULL,
  MasterUserSecretKmsKeyId = NULL,
  DedicatedLogVolume = NULL,
  CACertificateIdentifier = NULL,
  EngineLifecycleSupport = NULL
)
}
\arguments{
\item{DBName}{The name of the database to create when the DB instance is created.
Follow the naming rules specified in
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{DBInstanceIdentifier}{[required] The DB instance identifier. This parameter is stored as a lowercase
string.

Constraints:
\itemize{
\item Must contain from 1 to 63 letters, numbers, or hyphens.
\item First character must be a letter.
\item Can't end with a hyphen or contain two consecutive hyphens.
}

Example: \code{mydbinstance}}

\item{AllocatedStorage}{The amount of storage (in gibibytes) to allocate initially for the DB
instance. Follow the allocation rules specified in
\code{\link[=rds_create_db_instance]{create_db_instance}}.

Be sure to allocate enough storage for your new DB instance so that the
restore operation can succeed. You can also allocate additional storage
for future growth.}

\item{DBInstanceClass}{[required] The compute and memory capacity of the DB instance, for example
db.m4.large. Not all DB instance classes are available in all Amazon Web
Services Regions, or for all database engines. For the full list of DB
instance classes, and availability for your engine, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.DBInstanceClass.html}{DB Instance Class}
in the \emph{Amazon RDS User Guide.}

Importing from Amazon S3 isn't supported on the db.t2.micro DB instance
class.}

\item{Engine}{[required] The name of the database engine to be used for this instance.

Valid Values: \code{mysql}}

\item{MasterUsername}{The name for the master user.

Constraints:
\itemize{
\item Must be 1 to 16 letters or numbers.
\item First character must be a letter.
\item Can't be a reserved word for the chosen database engine.
}}

\item{MasterUserPassword}{The password for the master user.

Constraints:
\itemize{
\item Can't be specified if \code{ManageMasterUserPassword} is turned on.
\item Can include any printable ASCII character except "/", """, or "@".
For RDS for Oracle, can't include the "&" (ampersand) or the "'"
(single quotes) character.
}

Length Constraints:
\itemize{
\item RDS for Db2 - Must contain from 8 to 128 characters.
\item RDS for MariaDB - Must contain from 8 to 41 characters.
\item RDS for Microsoft SQL Server - Must contain from 8 to 128
characters.
\item RDS for MySQL - Must contain from 8 to 41 characters.
\item RDS for Oracle - Must contain from 8 to 30 characters.
\item RDS for PostgreSQL - Must contain from 8 to 128 characters.
}}

\item{DBSecurityGroups}{A list of DB security groups to associate with this DB instance.

Default: The default DB security group for the database engine.}

\item{VpcSecurityGroupIds}{A list of VPC security groups to associate with this DB instance.}

\item{AvailabilityZone}{The Availability Zone that the DB instance is created in. For
information about Amazon Web Services Regions and Availability Zones,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/Concepts.RegionsAndAvailabilityZones.html}{Regions and Availability Zones}
in the \emph{Amazon RDS User Guide.}

Default: A random, system-chosen Availability Zone in the endpoint's
Amazon Web Services Region.

Example: \verb{us-east-1d}

Constraint: The \code{AvailabilityZone} parameter can't be specified if the
DB instance is a Multi-AZ deployment. The specified Availability Zone
must be in the same Amazon Web Services Region as the current endpoint.}

\item{DBSubnetGroupName}{A DB subnet group to associate with this DB instance.

Constraints: If supplied, must match the name of an existing
DBSubnetGroup.

Example: \code{mydbsubnetgroup}}

\item{PreferredMaintenanceWindow}{The time range each week during which system maintenance can occur, in
Universal Coordinated Time (UTC). For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_UpgradeDBInstance.Maintenance.html#Concepts.DBMaintenance}{Amazon RDS Maintenance Window}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{ddd:hh24:mi-ddd:hh24:mi}.
\item Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred backup window.
\item Must be at least 30 minutes.
}}

\item{DBParameterGroupName}{The name of the DB parameter group to associate with this DB instance.

If you do not specify a value for \code{DBParameterGroupName}, then the
default \code{DBParameterGroup} for the specified DB engine is used.}

\item{BackupRetentionPeriod}{The number of days for which automated backups are retained. Setting
this parameter to a positive number enables backups. For more
information, see \code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{PreferredBackupWindow}{The time range each day during which automated backups are created if
automated backups are enabled. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_WorkingWithAutomatedBackups.html#USER_WorkingWithAutomatedBackups.BackupWindow}{Backup window}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Must be in the format \code{hh24:mi-hh24:mi}.
\item Must be in Universal Coordinated Time (UTC).
\item Must not conflict with the preferred maintenance window.
\item Must be at least 30 minutes.
}}

\item{Port}{The port number on which the database accepts connections.

Type: Integer

Valid Values: \code{1150}-\code{65535}

Default: \code{3306}}

\item{MultiAZ}{Specifies whether the DB instance is a Multi-AZ deployment. If the DB
instance is a Multi-AZ deployment, you can't set the \code{AvailabilityZone}
parameter.}

\item{EngineVersion}{The version number of the database engine to use. Choose the latest
minor version of your database engine. For information about engine
versions, see \code{\link[=rds_create_db_instance]{create_db_instance}}, or call
\code{\link[=rds_describe_db_engine_versions]{describe_db_engine_versions}}.}

\item{AutoMinorVersionUpgrade}{Specifies whether to automatically apply minor engine upgrades to the DB
instance during the maintenance window. By default, minor engine
upgrades are not applied automatically.}

\item{LicenseModel}{The license model for this DB instance. Use \code{general-public-license}.}

\item{Iops}{The amount of Provisioned IOPS (input/output operations per second) to
allocate initially for the DB instance. For information about valid IOPS
values, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/CHAP_Storage.html#USER_PIOPS}{Amazon RDS Provisioned IOPS storage}
in the \emph{Amazon RDS User Guide.}}

\item{OptionGroupName}{The name of the option group to associate with this DB instance. If this
argument is omitted, the default option group for the specified engine
is used.}

\item{PubliclyAccessible}{Specifies whether the DB instance is publicly accessible.

When the DB instance is publicly accessible, its Domain Name System
(DNS) endpoint resolves to the private IP address from within the DB
instance's virtual private cloud (VPC). It resolves to the public IP
address from outside of the DB instance's VPC. Access to the DB instance
is ultimately controlled by the security group it uses. That public
access is not permitted if the security group assigned to the DB
instance doesn't permit it.

When the DB instance isn't publicly accessible, it is an internal DB
instance with a DNS name that resolves to a private IP address.

For more information, see
\code{\link[=rds_create_db_instance]{create_db_instance}}.}

\item{Tags}{A list of tags to associate with this DB instance. For more information,
see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html}{Tagging Amazon RDS Resources}
in the \emph{Amazon RDS User Guide.}}

\item{StorageType}{Specifies the storage type to be associated with the DB instance.

Valid Values: \code{gp2 | gp3 | io1 | io2 | standard}

If you specify \code{io1}, \code{io2}, or \code{gp3}, you must also include a value for
the \code{Iops} parameter.

Default: \code{io1} if the \code{Iops} parameter is specified; otherwise \code{gp2}}

\item{StorageEncrypted}{Specifies whether the new DB instance is encrypted or not.}

\item{KmsKeyId}{The Amazon Web Services KMS key identifier for an encrypted DB instance.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

If the \code{StorageEncrypted} parameter is enabled, and you do not specify a
value for the \code{KmsKeyId} parameter, then Amazon RDS will use your
default KMS key. There is a default KMS key for your Amazon Web Services
account. Your Amazon Web Services account has a different default KMS
key for each Amazon Web Services Region.}

\item{CopyTagsToSnapshot}{Specifies whether to copy all tags from the DB instance to snapshots of
the DB instance. By default, tags are not copied.}

\item{MonitoringInterval}{The interval, in seconds, between points when Enhanced Monitoring
metrics are collected for the DB instance. To disable collecting
Enhanced Monitoring metrics, specify 0.

If \code{MonitoringRoleArn} is specified, then you must also set
\code{MonitoringInterval} to a value other than 0.

Valid Values: 0, 1, 5, 10, 15, 30, 60

Default: \code{0}}

\item{MonitoringRoleArn}{The ARN for the IAM role that permits RDS to send enhanced monitoring
metrics to Amazon CloudWatch Logs. For example,
\code{arn:aws:iam:123456789012:role/emaccess}. For information on creating a
monitoring role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Monitoring.OS.html#USER_Monitoring.OS.Enabling}{Setting Up and Enabling Enhanced Monitoring}
in the \emph{Amazon RDS User Guide.}

If \code{MonitoringInterval} is set to a value other than 0, then you must
supply a \code{MonitoringRoleArn} value.}

\item{EnableIAMDatabaseAuthentication}{Specifies whether to enable mapping of Amazon Web Services Identity and
Access Management (IAM) accounts to database accounts. By default,
mapping isn't enabled.

For more information about IAM database authentication, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html}{IAM Database Authentication for MySQL and PostgreSQL}
in the \emph{Amazon RDS User Guide.}}

\item{SourceEngine}{[required] The name of the engine of your source database.

Valid Values: \code{mysql}}

\item{SourceEngineVersion}{[required] The version of the database that the backup files were created from.

MySQL versions 5.6 and 5.7 are supported.

Example: \verb{5.6.40}}

\item{S3BucketName}{[required] The name of your Amazon S3 bucket that contains your database backup
file.}

\item{S3Prefix}{The prefix of your Amazon S3 bucket.}

\item{S3IngestionRoleArn}{[required] An Amazon Web Services Identity and Access Management (IAM) role with a
trust policy and a permissions policy that allows Amazon RDS to access
your Amazon S3 bucket. For information about this role, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html#MySQL.Procedural.Importing.Enabling.IAM}{Creating an IAM role manually}
in the \emph{Amazon RDS User Guide.}}

\item{EnablePerformanceInsights}{Specifies whether to enable Performance Insights for the DB instance.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html}{Using Amazon Performance Insights}
in the \emph{Amazon RDS User Guide}.}

\item{PerformanceInsightsKMSKeyId}{The Amazon Web Services KMS key identifier for encryption of Performance
Insights data.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key.

If you do not specify a value for \code{PerformanceInsightsKMSKeyId}, then
Amazon RDS uses your default KMS key. There is a default KMS key for
your Amazon Web Services account. Your Amazon Web Services account has a
different default KMS key for each Amazon Web Services Region.}

\item{PerformanceInsightsRetentionPeriod}{The number of days to retain Performance Insights data. The default is 7
days. The following values are valid:
\itemize{
\item 7
\item \emph{month} * 31, where \emph{month} is a number of months from 1-23
\item 731
}

For example, the following values are valid:
\itemize{
\item 93 (3 months * 31)
\item 341 (11 months * 31)
\item 589 (19 months * 31)
\item 731
}

If you specify a retention period such as 94, which isn't a valid value,
RDS issues an error.}

\item{EnableCloudwatchLogsExports}{The list of logs that the restored DB instance is to export to
CloudWatch Logs. The values in the list depend on the DB engine being
used. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_LogAccess.html#USER_LogAccess.Procedural.UploadtoCloudWatch}{Publishing Database Logs to Amazon CloudWatch Logs}
in the \emph{Amazon RDS User Guide}.}

\item{ProcessorFeatures}{The number of CPU cores and the number of threads per core for the DB
instance class of the DB instance.}

\item{UseDefaultProcessorFeatures}{Specifies whether the DB instance class of the DB instance uses its
default processor features.}

\item{DeletionProtection}{Specifies whether to enable deletion protection for the DB instance. The
database can't be deleted when deletion protection is enabled. By
default, deletion protection isn't enabled. For more information, see
\href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_DeleteInstance.html}{Deleting a DB Instance}.}

\item{MaxAllocatedStorage}{The upper limit in gibibytes (GiB) to which Amazon RDS can automatically
scale the storage of the DB instance.

For more information about this setting, including limitations that
apply to it, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PIOPS.StorageTypes.html#USER_PIOPS.Autoscaling}{Managing capacity automatically with Amazon RDS storage autoscaling}
in the \emph{Amazon RDS User Guide}.}

\item{NetworkType}{The network type of the DB instance.

Valid Values:
\itemize{
\item \code{IPV4}
\item \code{DUAL}
}

The network type is determined by the \code{DBSubnetGroup} specified for the
DB instance. A \code{DBSubnetGroup} can support only the IPv4 protocol or the
IPv4 and the IPv6 protocols (\code{DUAL}).

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_VPC.WorkingWithRDSInstanceinaVPC.html}{Working with a DB instance in a VPC}
in the \emph{Amazon RDS User Guide.}}

\item{StorageThroughput}{Specifies the storage throughput value for the DB instance.

This setting doesn't apply to RDS Custom or Amazon Aurora.}

\item{ManageMasterUserPassword}{Specifies whether to manage the master user password with Amazon Web
Services Secrets Manager.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/rds-secrets-manager.html}{Password management with Amazon Web Services Secrets Manager}
in the \emph{Amazon RDS User Guide.}

Constraints:
\itemize{
\item Can't manage the master user password with Amazon Web Services
Secrets Manager if \code{MasterUserPassword} is specified.
}}

\item{MasterUserSecretKmsKeyId}{The Amazon Web Services KMS key identifier to encrypt a secret that is
automatically generated and managed in Amazon Web Services Secrets
Manager.

This setting is valid only if the master user password is managed by RDS
in Amazon Web Services Secrets Manager for the DB instance.

The Amazon Web Services KMS key identifier is the key ARN, key ID, alias
ARN, or alias name for the KMS key. To use a KMS key in a different
Amazon Web Services account, specify the key ARN or alias ARN.

If you don't specify \code{MasterUserSecretKmsKeyId}, then the
\code{aws/secretsmanager} KMS key is used to encrypt the secret. If the
secret is in a different Amazon Web Services account, then you can't use
the \code{aws/secretsmanager} KMS key to encrypt the secret, and you must use
a customer managed KMS key.

There is a default KMS key for your Amazon Web Services account. Your
Amazon Web Services account has a different default KMS key for each
Amazon Web Services Region.}

\item{DedicatedLogVolume}{Specifies whether to enable a dedicated log volume (DLV) for the DB
instance.}

\item{CACertificateIdentifier}{The CA certificate identifier to use for the DB instance's server
certificate.

This setting doesn't apply to RDS Custom DB instances.

For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB instance}
in the \emph{Amazon RDS User Guide} and \href{https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/UsingWithRDS.SSL.html}{Using SSL/TLS to encrypt a connection to a DB cluster}
in the \emph{Amazon Aurora User Guide}.}

\item{EngineLifecycleSupport}{The life cycle type for this DB instance.

By default, this value is set to \code{open-source-rds-extended-support},
which enrolls your DB instance into Amazon RDS Extended Support. At the
end of standard support, you can avoid charges for Extended Support by
setting the value to \code{open-source-rds-extended-support-disabled}. In
this case, RDS automatically upgrades your restored DB instance to a
higher engine version, if the major engine version is past its end of
standard support date.

You can use this setting to enroll your DB instance into Amazon RDS
Extended Support. With RDS Extended Support, you can run the selected
major engine version on your DB instance past the end of standard
support for that engine version. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/extended-support.html}{Using Amazon RDS Extended Support}
in the \emph{Amazon RDS User Guide}.

This setting applies only to RDS for MySQL and RDS for PostgreSQL. For
Amazon Aurora DB instances, the life cycle type is managed by the DB
cluster.

Valid Values:
\code{open-source-rds-extended-support | open-source-rds-extended-support-disabled}

Default: \code{open-source-rds-extended-support}}
}
\description{
Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using backup files. You can create a backup of your on-premises database, store it on Amazon Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS DB instance running MySQL. For more information, see \href{https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/MySQL.Procedural.Importing.html}{Importing Data into an Amazon RDS MySQL DB Instance} in the \emph{Amazon RDS User Guide.}

See \url{https://www.paws-r-sdk.com/docs/rds_restore_db_instance_from_s3/} for full documentation.
}
\keyword{internal}
