% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamodb_operations.R
\name{dynamodb_delete_resource_policy}
\alias{dynamodb_delete_resource_policy}
\title{Deletes the resource-based policy attached to the resource, which can be
a table or stream}
\usage{
dynamodb_delete_resource_policy(ResourceArn, ExpectedRevisionId = NULL)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the DynamoDB resource from which the
policy will be removed. The resources you can specify include tables and
streams. If you remove the policy of a table, it will also remove the
permissions for the table's indexes defined in that policy document.
This is because index permissions are defined in the table's policy.}

\item{ExpectedRevisionId}{A string value that you can use to conditionally delete your policy.
When you provide an expected revision ID, if the revision ID of the
existing policy on the resource doesn't match or if there's no policy
attached to the resource, the request will fail and return a
\code{PolicyNotFoundException}.}
}
\description{
Deletes the resource-based policy attached to the resource, which can be a table or stream.

See \url{https://www.paws-r-sdk.com/docs/dynamodb_delete_resource_policy/} for full documentation.
}
\keyword{internal}
