% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_update_repository}
\alias{codeartifact_update_repository}
\title{Update the properties of a repository}
\usage{
codeartifact_update_repository(
  domain,
  domainOwner = NULL,
  repository,
  description = NULL,
  upstreams = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain associated with the repository to update.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository to update.}

\item{description}{An updated repository description.}

\item{upstreams}{A list of upstream repositories to associate with the repository. The
order of the upstream repositories in the list determines their priority
order when CodeArtifact looks for a requested package version. For more
information, see \href{https://docs.aws.amazon.com/codeartifact/latest/ug/repos-upstream.html}{Working with upstream repositories}.}
}
\description{
Update the properties of a repository.

See \url{https://paws-r.github.io/docs/codeartifact/update_repository.html} for full documentation.
}
\keyword{internal}
