% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_put_file}
\alias{codecommit_put_file}
\title{Adds or updates a file in a branch in an AWS CodeCommit repository, and
generates a commit for the addition in the specified branch}
\usage{
codecommit_put_file(
  repositoryName,
  branchName,
  fileContent,
  filePath,
  fileMode = NULL,
  parentCommitId = NULL,
  commitMessage = NULL,
  name = NULL,
  email = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to add or update the file.}

\item{branchName}{[required] The name of the branch where you want to add or update the file. If this
is an empty repository, this branch is created.}

\item{fileContent}{[required] The content of the file, in binary object format.}

\item{filePath}{[required] The name of the file you want to add or update, including the relative
path to the file in the repository.

If the path does not currently exist in the repository, the path is
created as part of adding the file.}

\item{fileMode}{The file mode permissions of the blob. Valid file mode permissions are
listed here.}

\item{parentCommitId}{The full commit ID of the head commit in the branch where you want to
add or update the file. If this is an empty repository, no commit ID is
required. If this is not an empty repository, a commit ID is required.

The commit ID must match the ID of the head commit at the time of the
operation. Otherwise, an error occurs, and the file is not added or
updated.}

\item{commitMessage}{A message about why this file was added or updated. Although it is
optional, a message makes the commit history for your repository more
useful.}

\item{name}{The name of the person adding or updating the file. Although it is
optional, a name makes the commit history for your repository more
useful.}

\item{email}{An email address for the person adding or updating the file.}
}
\description{
Adds or updates a file in a branch in an AWS CodeCommit repository, and generates a commit for the addition in the specified branch.

See \url{https://www.paws-r-sdk.com/docs/codecommit_put_file/} for full documentation.
}
\keyword{internal}
