% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeguruprofiler_service.R
\name{codeguruprofiler}
\alias{codeguruprofiler}
\title{Amazon CodeGuru Profiler}
\usage{
codeguruprofiler(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This section provides documentation for the Amazon CodeGuru Profiler API
operations.

Amazon CodeGuru Profiler collects runtime performance data from your
live applications, and provides recommendations that can help you
fine-tune your application performance. Using machine learning
algorithms, CodeGuru Profiler can help you find your most expensive
lines of code and suggest ways you can improve efficiency and remove CPU
bottlenecks.

Amazon CodeGuru Profiler provides different visualizations of profiling
data to help you identify what code is running on the CPU, see how much
time is consumed, and suggest ways to reduce CPU utilization.

Amazon CodeGuru Profiler currently supports applications written in all
Java virtual machine (JVM) languages and Python. While CodeGuru Profiler
supports both visualizations and recommendations for applications
written in Java, it can also generate visualizations and a subset of
recommendations for applications written in other JVM languages and
Python.

For more information, see \href{https://docs.aws.amazon.com/codeguru/latest/profiler-ug/what-is-codeguru-profiler.html}{What is Amazon CodeGuru Profiler}
in the \emph{Amazon CodeGuru Profiler User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- codeguruprofiler(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=codeguruprofiler_add_notification_channels]{add_notification_channels} \tab Add up to 2 anomaly notifications channels for a profiling group\cr
\link[=codeguruprofiler_batch_get_frame_metric_data]{batch_get_frame_metric_data} \tab Returns the time series of values for a requested list of frame metrics from a time period\cr
\link[=codeguruprofiler_configure_agent]{configure_agent} \tab Used by profiler agents to report their current state and to receive remote configuration updates\cr
\link[=codeguruprofiler_create_profiling_group]{create_profiling_group} \tab Creates a profiling group\cr
\link[=codeguruprofiler_delete_profiling_group]{delete_profiling_group} \tab Deletes a profiling group\cr
\link[=codeguruprofiler_describe_profiling_group]{describe_profiling_group} \tab Returns a ProfilingGroupDescription object that contains information about the requested profiling group\cr
\link[=codeguruprofiler_get_findings_report_account_summary]{get_findings_report_account_summary} \tab Returns a list of FindingsReportSummary objects that contain analysis results for all profiling groups in your AWS account\cr
\link[=codeguruprofiler_get_notification_configuration]{get_notification_configuration} \tab Get the current configuration for anomaly notifications for a profiling group\cr
\link[=codeguruprofiler_get_policy]{get_policy} \tab Returns the JSON-formatted resource-based policy on a profiling group\cr
\link[=codeguruprofiler_get_profile]{get_profile} \tab Gets the aggregated profile of a profiling group for a specified time range\cr
\link[=codeguruprofiler_get_recommendations]{get_recommendations} \tab Returns a list of Recommendation objects that contain recommendations for a profiling group for a given time period\cr
\link[=codeguruprofiler_list_findings_reports]{list_findings_reports} \tab List the available reports for a given profiling group and time range\cr
\link[=codeguruprofiler_list_profile_times]{list_profile_times} \tab Lists the start times of the available aggregated profiles of a profiling group for an aggregation period within the specified time range\cr
\link[=codeguruprofiler_list_profiling_groups]{list_profiling_groups} \tab Returns a list of profiling groups\cr
\link[=codeguruprofiler_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags that are assigned to a specified resource\cr
\link[=codeguruprofiler_post_agent_profile]{post_agent_profile} \tab Submits profiling data to an aggregated profile of a profiling group\cr
\link[=codeguruprofiler_put_permission]{put_permission} \tab Adds permissions to a profiling group's resource-based policy that are provided using an action group\cr
\link[=codeguruprofiler_remove_notification_channel]{remove_notification_channel} \tab Remove one anomaly notifications channel for a profiling group\cr
\link[=codeguruprofiler_remove_permission]{remove_permission} \tab Removes permissions from a profiling group's resource-based policy that are provided using an action group\cr
\link[=codeguruprofiler_submit_feedback]{submit_feedback} \tab Sends feedback to CodeGuru Profiler about whether the anomaly detected by the analysis is useful or not\cr
\link[=codeguruprofiler_tag_resource]{tag_resource} \tab Use to assign one or more tags to a resource\cr
\link[=codeguruprofiler_untag_resource]{untag_resource} \tab Use to remove one or more tags from a resource\cr
\link[=codeguruprofiler_update_profiling_group]{update_profiling_group} \tab Updates a profiling group
}
}

\examples{
\dontrun{
svc <- codeguruprofiler()
svc$add_notification_channels(
  Foo = 123
)
}

}
