% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_directory_config}
\alias{appstream_create_directory_config}
\title{Creates a Directory Config object in AppStream 2}
\usage{
appstream_create_directory_config(DirectoryName,
  OrganizationalUnitDistinguishedNames, ServiceAccountCredentials)
}
\arguments{
\item{DirectoryName}{[required] The fully qualified name of the directory (for example,
corp.example.com).}

\item{OrganizationalUnitDistinguishedNames}{[required] The distinguished names of the organizational units for computer
accounts.}

\item{ServiceAccountCredentials}{The credentials for the service account used by the fleet or image
builder to connect to the directory.}
}
\value{
A list with the following syntax:\preformatted{list(
  DirectoryConfig = list(
    DirectoryName = "string",
    OrganizationalUnitDistinguishedNames = list(
      "string"
    ),
    ServiceAccountCredentials = list(
      AccountName = "string",
      AccountPassword = "string"
    ),
    CreatedTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Creates a Directory Config object in AppStream 2.0. This object includes
the configuration information required to join fleets and image builders
to Microsoft Active Directory domains.
}
\section{Request syntax}{
\preformatted{svc$create_directory_config(
  DirectoryName = "string",
  OrganizationalUnitDistinguishedNames = list(
    "string"
  ),
  ServiceAccountCredentials = list(
    AccountName = "string",
    AccountPassword = "string"
  )
)
}
}

\keyword{internal}
