% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_update_identity_provider}
\alias{workspacesweb_update_identity_provider}
\title{Updates the identity provider}
\usage{
workspacesweb_update_identity_provider(
  clientToken = NULL,
  identityProviderArn,
  identityProviderDetails = NULL,
  identityProviderName = NULL,
  identityProviderType = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
return the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{identityProviderArn}{[required] The ARN of the identity provider.}

\item{identityProviderDetails}{The details of the identity provider. The following list describes the
provider detail keys for each identity provider type.
\itemize{
\item For Google and Login with Amazon:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{authorize_scopes}
}
\item For Facebook:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{authorize_scopes}
\item \code{api_version}
}
\item For Sign in with Apple:
\itemize{
\item \code{client_id}
\item \code{team_id}
\item \code{key_id}
\item \code{private_key}
\item \code{authorize_scopes}
}
\item For OIDC providers:
\itemize{
\item \code{client_id}
\item \code{client_secret}
\item \code{attributes_request_method}
\item \code{oidc_issuer}
\item \code{authorize_scopes}
\item \code{authorize_url} \emph{if not available from discovery URL specified
by oidc_issuer key}
\item \code{token_url} \emph{if not available from discovery URL specified by
oidc_issuer key}
\item \code{attributes_url} \emph{if not available from discovery URL specified
by oidc_issuer key}
\item \code{jwks_uri} \emph{if not available from discovery URL specified by
oidc_issuer key}
}
\item For SAML providers:
\itemize{
\item \code{MetadataFile} OR \code{MetadataURL}
\item \code{IDPSignout} (boolean) \emph{optional}
}
}}

\item{identityProviderName}{The name of the identity provider.}

\item{identityProviderType}{The type of the identity provider.}
}
\description{
Updates the identity provider.

See \url{https://paws-r.github.io/docs/workspacesweb/update_identity_provider.html} for full documentation.
}
\keyword{internal}
