% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_create_document_classifier}
\alias{comprehend_create_document_classifier}
\title{Creates a new document classifier that you can use to categorize
documents}
\usage{
comprehend_create_document_classifier(DocumentClassifierName,
  DataAccessRoleArn, InputDataConfig, ClientRequestToken, LanguageCode,
  VolumeKmsKeyId)
}
\arguments{
\item{DocumentClassifierName}{[required] The name of the document classifier.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM)
role that grants Amazon Comprehend read access to your input data.}

\item{InputDataConfig}{[required] Specifies the format and location of the input data for the job.}

\item{ClientRequestToken}{A unique identifier for the request. If you don't set the client
request token, Amazon Comprehend generates one.}

\item{LanguageCode}{[required] The language of the input documents. You can specify English ("en") or
Spanish ("es"). All documents must be in the same language.}

\item{VolumeKmsKeyId}{ID for the AWS Key Management Service (KMS) key that Amazon Comprehend
uses to encrypt data on the storage volume attached to the ML compute
instance(s) that process the analysis job. The VolumeKmsKeyId can be
either of the following formats:
\itemize{
\item KMS Key ID: \code{"1234abcd-12ab-34cd-56ef-1234567890ab"}
\item Amazon Resource Name (ARN) of a KMS Key:
\code{"arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"}
}}
}
\description{
Creates a new document classifier that you can use to categorize
documents. To create a classifier you provide a set of training
documents that labeled with the categories that you want to use. After
the classifier is trained you can use it to categorize a set of labeled
documents into the categories. For more information, see
how-document-classification.
}
\section{Request syntax}{
\preformatted{svc$create_document_classifier(
  DocumentClassifierName = "string",
  DataAccessRoleArn = "string",
  InputDataConfig = list(
    S3Uri = "string"
  ),
  ClientRequestToken = "string",
  LanguageCode = "en"|"es"|"fr"|"de"|"it"|"pt",
  VolumeKmsKeyId = "string"
)
}
}

\keyword{internal}
