# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include personalize_service.R
NULL

#' Creates a batch inference job
#'
#' @description
#' Creates a batch inference job. The operation can handle up to 50 million
#' records and the input file must be in JSON format. For more information,
#' see recommendations-batch.
#'
#' @usage
#' personalize_create_batch_inference_job(jobName, solutionVersionArn,
#'   filterArn, numResults, jobInput, jobOutput, roleArn,
#'   batchInferenceJobConfig)
#'
#' @param jobName &#91;required&#93; The name of the batch inference job to create.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version that will be used
#' to generate the batch inference recommendations.
#' @param filterArn The ARN of the filter to apply to the batch inference job. For more
#' information on using filters, see Using Filters with Amazon Personalize.
#' @param numResults The number of recommendations to retreive.
#' @param jobInput &#91;required&#93; The Amazon S3 path that leads to the input file to base your
#' recommendations on. The input material must be in JSON format.
#' @param jobOutput &#91;required&#93; The path to the Amazon S3 bucket where the job's output will be stored.
#' @param roleArn &#91;required&#93; The ARN of the Amazon Identity and Access Management role that has
#' permissions to read and write to your input and out Amazon S3 buckets
#' respectively.
#' @param batchInferenceJobConfig The configuration details of a batch inference job.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   batchInferenceJobArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_batch_inference_job(
#'   jobName = "string",
#'   solutionVersionArn = "string",
#'   filterArn = "string",
#'   numResults = 123,
#'   jobInput = list(
#'     s3DataSource = list(
#'       path = "string",
#'       kmsKeyArn = "string"
#'     )
#'   ),
#'   jobOutput = list(
#'     s3DataDestination = list(
#'       path = "string",
#'       kmsKeyArn = "string"
#'     )
#'   ),
#'   roleArn = "string",
#'   batchInferenceJobConfig = list(
#'     itemExplorationConfig = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_batch_inference_job
personalize_create_batch_inference_job <- function(jobName, solutionVersionArn, filterArn = NULL, numResults = NULL, jobInput, jobOutput, roleArn, batchInferenceJobConfig = NULL) {
  op <- new_operation(
    name = "CreateBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_batch_inference_job_input(jobName = jobName, solutionVersionArn = solutionVersionArn, filterArn = filterArn, numResults = numResults, jobInput = jobInput, jobOutput = jobOutput, roleArn = roleArn, batchInferenceJobConfig = batchInferenceJobConfig)
  output <- .personalize$create_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_batch_inference_job <- personalize_create_batch_inference_job

#' Creates a campaign by deploying a solution version
#'
#' @description
#' Creates a campaign by deploying a solution version. When a client calls
#' the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' and
#' [GetPersonalizedRanking](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetPersonalizedRanking.html)
#' APIs, a campaign is specified in the request.
#' 
#' **Minimum Provisioned TPS and Auto-Scaling**
#' 
#' A transaction is a single `GetRecommendations` or
#' `GetPersonalizedRanking` call. Transactions per second (TPS) is the
#' throughput and unit of billing for Amazon Personalize. The minimum
#' provisioned TPS (`minProvisionedTPS`) specifies the baseline throughput
#' provisioned by Amazon Personalize, and thus, the minimum billing charge.
#' If your TPS increases beyond `minProvisionedTPS`, Amazon Personalize
#' auto-scales the provisioned capacity up and down, but never below
#' `minProvisionedTPS`, to maintain a 70% utilization. There's a short time
#' delay while the capacity is increased that might cause loss of
#' transactions. It's recommended to start with a low `minProvisionedTPS`,
#' track your usage using Amazon CloudWatch metrics, and then increase the
#' `minProvisionedTPS` as necessary.
#' 
#' **Status**
#' 
#' A campaign can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING &gt; DELETE IN_PROGRESS
#' 
#' To get the campaign status, call
#' [`describe_campaign`][personalize_describe_campaign].
#' 
#' Wait until the `status` of the campaign is `ACTIVE` before asking the
#' campaign for recommendations.
#' 
#' **Related APIs**
#' 
#' -   [`list_campaigns`][personalize_list_campaigns]
#' 
#' -   [`describe_campaign`][personalize_describe_campaign]
#' 
#' -   [`update_campaign`][personalize_update_campaign]
#' 
#' -   [`delete_campaign`][personalize_delete_campaign]
#'
#' @usage
#' personalize_create_campaign(name, solutionVersionArn, minProvisionedTPS,
#'   campaignConfig)
#'
#' @param name &#91;required&#93; A name for the new campaign. The campaign name must be unique within
#' your account.
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version to deploy.
#' @param minProvisionedTPS &#91;required&#93; Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support.
#' @param campaignConfig The configuration details of a campaign.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_campaign(
#'   name = "string",
#'   solutionVersionArn = "string",
#'   minProvisionedTPS = 123,
#'   campaignConfig = list(
#'     itemExplorationConfig = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_campaign
personalize_create_campaign <- function(name, solutionVersionArn, minProvisionedTPS, campaignConfig = NULL) {
  op <- new_operation(
    name = "CreateCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_campaign_input(name = name, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS, campaignConfig = campaignConfig)
  output <- .personalize$create_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_campaign <- personalize_create_campaign

#' Creates an empty dataset and adds it to the specified dataset group
#'
#' @description
#' Creates an empty dataset and adds it to the specified dataset group. Use
#' [`create_dataset_import_job`][personalize_create_dataset_import_job] to
#' import your training data to a dataset.
#' 
#' There are three types of datasets:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#' 
#' Each dataset type has an associated schema with required field types.
#' Only the `Interactions` dataset is required in order to train a model
#' (also referred to as creating a solution).
#' 
#' A dataset can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING &gt; DELETE IN_PROGRESS
#' 
#' To get the status of the dataset, call
#' [`describe_dataset`][personalize_describe_dataset].
#' 
#' **Related APIs**
#' 
#' -   [`create_dataset_group`][personalize_create_dataset_group]
#' 
#' -   [`list_datasets`][personalize_list_datasets]
#' 
#' -   [`describe_dataset`][personalize_describe_dataset]
#' 
#' -   [`delete_dataset`][personalize_delete_dataset]
#'
#' @usage
#' personalize_create_dataset(name, schemaArn, datasetGroupArn,
#'   datasetType)
#'
#' @param name &#91;required&#93; The name for the dataset.
#' @param schemaArn &#91;required&#93; The ARN of the schema to associate with the dataset. The schema defines
#' the dataset fields.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to add the dataset
#' to.
#' @param datasetType &#91;required&#93; The type of dataset.
#' 
#' One of the following (case insensitive) values:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset(
#'   name = "string",
#'   schemaArn = "string",
#'   datasetGroupArn = "string",
#'   datasetType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset
personalize_create_dataset <- function(name, schemaArn, datasetGroupArn, datasetType) {
  op <- new_operation(
    name = "CreateDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_input(name = name, schemaArn = schemaArn, datasetGroupArn = datasetGroupArn, datasetType = datasetType)
  output <- .personalize$create_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset <- personalize_create_dataset

#' Creates an empty dataset group
#'
#' @description
#' Creates an empty dataset group. A dataset group contains related
#' datasets that supply data for training a model. A dataset group can
#' contain at most three datasets, one for each type of dataset:
#' 
#' -   Interactions
#' 
#' -   Items
#' 
#' -   Users
#' 
#' To train a model (create a solution), a dataset group that contains an
#' `Interactions` dataset is required. Call
#' [`create_dataset`][personalize_create_dataset] to add a dataset to the
#' group.
#' 
#' A dataset group can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING
#' 
#' To get the status of the dataset group, call
#' [`describe_dataset_group`][personalize_describe_dataset_group]. If the
#' status shows as CREATE FAILED, the response includes a `failureReason`
#' key, which describes why the creation failed.
#' 
#' You must wait until the `status` of the dataset group is `ACTIVE` before
#' adding a dataset to the group.
#' 
#' You can specify an AWS Key Management Service (KMS) key to encrypt the
#' datasets in the group. If you specify a KMS key, you must also include
#' an AWS Identity and Access Management (IAM) role that has permission to
#' access the key.
#' 
#' **APIs that require a dataset group ARN in the request**
#' 
#' -   [`create_dataset`][personalize_create_dataset]
#' 
#' -   [`create_event_tracker`][personalize_create_event_tracker]
#' 
#' -   [`create_solution`][personalize_create_solution]
#' 
#' **Related APIs**
#' 
#' -   [`list_dataset_groups`][personalize_list_dataset_groups]
#' 
#' -   [`describe_dataset_group`][personalize_describe_dataset_group]
#' 
#' -   [`delete_dataset_group`][personalize_delete_dataset_group]
#'
#' @usage
#' personalize_create_dataset_group(name, roleArn, kmsKeyArn)
#'
#' @param name &#91;required&#93; The name for the new dataset group.
#' @param roleArn The ARN of the IAM role that has permissions to access the KMS key.
#' Supplying an IAM role is only valid when also specifying a KMS key.
#' @param kmsKeyArn The Amazon Resource Name (ARN) of a KMS key used to encrypt the
#' datasets.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset_group(
#'   name = "string",
#'   roleArn = "string",
#'   kmsKeyArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_group
personalize_create_dataset_group <- function(name, roleArn = NULL, kmsKeyArn = NULL) {
  op <- new_operation(
    name = "CreateDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_group_input(name = name, roleArn = roleArn, kmsKeyArn = kmsKeyArn)
  output <- .personalize$create_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_group <- personalize_create_dataset_group

#' Creates a job that imports training data from your data source (an
#' Amazon S3 bucket) to an Amazon Personalize dataset
#'
#' @description
#' Creates a job that imports training data from your data source (an
#' Amazon S3 bucket) to an Amazon Personalize dataset. To allow Amazon
#' Personalize to import the training data, you must specify an AWS
#' Identity and Access Management (IAM) role that has permission to read
#' from the data source, as Amazon Personalize makes a copy of your data
#' and processes it in an internal AWS system.
#' 
#' The dataset import job replaces any previous data in the dataset.
#' 
#' **Status**
#' 
#' A dataset import job can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' To get the status of the import job, call
#' [`describe_dataset_import_job`][personalize_describe_dataset_import_job],
#' providing the Amazon Resource Name (ARN) of the dataset import job. The
#' dataset import is complete when the status shows as ACTIVE. If the
#' status shows as CREATE FAILED, the response includes a `failureReason`
#' key, which describes why the job failed.
#' 
#' Importing takes time. You must wait until the status shows as ACTIVE
#' before training a model using the dataset.
#' 
#' **Related APIs**
#' 
#' -   [`list_dataset_import_jobs`][personalize_list_dataset_import_jobs]
#' 
#' -   [`describe_dataset_import_job`][personalize_describe_dataset_import_job]
#'
#' @usage
#' personalize_create_dataset_import_job(jobName, datasetArn, dataSource,
#'   roleArn)
#'
#' @param jobName &#91;required&#93; The name for the dataset import job.
#' @param datasetArn &#91;required&#93; The ARN of the dataset that receives the imported data.
#' @param dataSource &#91;required&#93; The Amazon S3 bucket that contains the training data to import.
#' @param roleArn &#91;required&#93; The ARN of the IAM role that has permissions to read from the Amazon S3
#' data source.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetImportJobArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_dataset_import_job(
#'   jobName = "string",
#'   datasetArn = "string",
#'   dataSource = list(
#'     dataLocation = "string"
#'   ),
#'   roleArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_dataset_import_job
personalize_create_dataset_import_job <- function(jobName, datasetArn, dataSource, roleArn) {
  op <- new_operation(
    name = "CreateDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_dataset_import_job_input(jobName = jobName, datasetArn = datasetArn, dataSource = dataSource, roleArn = roleArn)
  output <- .personalize$create_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_dataset_import_job <- personalize_create_dataset_import_job

#' Creates an event tracker that you use when sending event data to the
#' specified dataset group using the PutEvents API
#'
#' @description
#' Creates an event tracker that you use when sending event data to the
#' specified dataset group using the
#' [PutEvents](https://docs.aws.amazon.com/personalize/latest/dg/API_UBS_PutEvents.html)
#' API.
#' 
#' When Amazon Personalize creates an event tracker, it also creates an
#' *event-interactions* dataset in the dataset group associated with the
#' event tracker. The event-interactions dataset stores the event data from
#' the `PutEvents` call. The contents of this dataset are not available to
#' the user.
#' 
#' Only one event tracker can be associated with a dataset group. You will
#' get an error if you call
#' [`create_event_tracker`][personalize_create_event_tracker] using the
#' same dataset group as an existing event tracker.
#' 
#' When you send event data you include your tracking ID. The tracking ID
#' identifies the customer and authorizes the customer to send the data.
#' 
#' The event tracker can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING &gt; DELETE IN_PROGRESS
#' 
#' To get the status of the event tracker, call
#' [`describe_event_tracker`][personalize_describe_event_tracker].
#' 
#' The event tracker must be in the ACTIVE state before using the tracking
#' ID.
#' 
#' **Related APIs**
#' 
#' -   [`list_event_trackers`][personalize_list_event_trackers]
#' 
#' -   [`describe_event_tracker`][personalize_describe_event_tracker]
#' 
#' -   [`delete_event_tracker`][personalize_delete_event_tracker]
#'
#' @usage
#' personalize_create_event_tracker(name, datasetGroupArn)
#'
#' @param name &#91;required&#93; The name for the event tracker.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that receives the
#' event data.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   eventTrackerArn = "string",
#'   trackingId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_event_tracker(
#'   name = "string",
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_event_tracker
personalize_create_event_tracker <- function(name, datasetGroupArn) {
  op <- new_operation(
    name = "CreateEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_event_tracker_input(name = name, datasetGroupArn = datasetGroupArn)
  output <- .personalize$create_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_event_tracker <- personalize_create_event_tracker

#' Creates a recommendation filter
#'
#' @description
#' Creates a recommendation filter. For more information, see [Using
#' Filters with Amazon
#' Personalize](https://docs.aws.amazon.com/personalize/latest/dg/).
#'
#' @usage
#' personalize_create_filter(name, datasetGroupArn, filterExpression)
#'
#' @param name &#91;required&#93; The name of the filter to create.
#' @param datasetGroupArn &#91;required&#93; The ARN of the dataset group that the filter will belong to.
#' @param filterExpression &#91;required&#93; The filter expression that designates the interaction types that the
#' filter will filter out. A filter expression must follow the following
#' format:
#' 
#' `EXCLUDE itemId WHERE INTERACTIONS.event_type in ("EVENT_TYPE")`
#' 
#' Where "EVENT_TYPE" is the type of event to filter out. To filter out
#' all items with any interactions history, set `"*"` as the EVENT_TYPE.
#' For more information, see [Using Filters with Amazon
#' Personalize](https://docs.aws.amazon.com/personalize/latest/dg/).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   filterArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_filter(
#'   name = "string",
#'   datasetGroupArn = "string",
#'   filterExpression = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_filter
personalize_create_filter <- function(name, datasetGroupArn, filterExpression) {
  op <- new_operation(
    name = "CreateFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_filter_input(name = name, datasetGroupArn = datasetGroupArn, filterExpression = filterExpression)
  output <- .personalize$create_filter_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_filter <- personalize_create_filter

#' Creates an Amazon Personalize schema from the specified schema string
#'
#' @description
#' Creates an Amazon Personalize schema from the specified schema string.
#' The schema you create must be in Avro JSON format.
#' 
#' Amazon Personalize recognizes three schema variants. Each schema is
#' associated with a dataset type and has a set of required field and
#' keywords. You specify a schema when you call
#' [`create_dataset`][personalize_create_dataset].
#' 
#' **Related APIs**
#' 
#' -   [`list_schemas`][personalize_list_schemas]
#' 
#' -   [`describe_schema`][personalize_describe_schema]
#' 
#' -   [`delete_schema`][personalize_delete_schema]
#'
#' @usage
#' personalize_create_schema(name, schema)
#'
#' @param name &#91;required&#93; The name for the schema.
#' @param schema &#91;required&#93; A schema in Avro JSON format.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   schemaArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_schema(
#'   name = "string",
#'   schema = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_schema
personalize_create_schema <- function(name, schema) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_schema_input(name = name, schema = schema)
  output <- .personalize$create_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_schema <- personalize_create_schema

#' Creates the configuration for training a model
#'
#' @description
#' Creates the configuration for training a model. A trained model is known
#' as a solution. After the configuration is created, you train the model
#' (create a solution) by calling the
#' [`create_solution_version`][personalize_create_solution_version]
#' operation. Every time you call
#' [`create_solution_version`][personalize_create_solution_version], a new
#' version of the solution is created.
#' 
#' After creating a solution version, you check its accuracy by calling
#' [`get_solution_metrics`][personalize_get_solution_metrics]. When you are
#' satisfied with the version, you deploy it using
#' [`create_campaign`][personalize_create_campaign]. The campaign provides
#' recommendations to a client through the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' API.
#' 
#' To train a model, Amazon Personalize requires training data and a
#' recipe. The training data comes from the dataset group that you provide
#' in the request. A recipe specifies the training algorithm and a feature
#' transformation. You can specify one of the predefined recipes provided
#' by Amazon Personalize. Alternatively, you can specify `performAutoML`
#' and Amazon Personalize will analyze your data and select the optimum
#' USER_PERSONALIZATION recipe for you.
#' 
#' **Status**
#' 
#' A solution can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING &gt; DELETE IN_PROGRESS
#' 
#' To get the status of the solution, call
#' [`describe_solution`][personalize_describe_solution]. Wait until the
#' status shows as ACTIVE before calling
#' [`create_solution_version`][personalize_create_solution_version].
#' 
#' **Related APIs**
#' 
#' -   [`list_solutions`][personalize_list_solutions]
#' 
#' -   [`create_solution_version`][personalize_create_solution_version]
#' 
#' -   [`describe_solution`][personalize_describe_solution]
#' 
#' -   [`delete_solution`][personalize_delete_solution]
#' 
#' 
#' -   [`list_solution_versions`][personalize_list_solution_versions]
#' 
#' -   [`describe_solution_version`][personalize_describe_solution_version]
#'
#' @usage
#' personalize_create_solution(name, performHPO, performAutoML, recipeArn,
#'   datasetGroupArn, eventType, solutionConfig)
#'
#' @param name &#91;required&#93; The name for the solution.
#' @param performHPO Whether to perform hyperparameter optimization (HPO) on the specified or
#' selected recipe. The default is `false`.
#' 
#' When performing AutoML, this parameter is always `true` and you should
#' not set it to `false`.
#' @param performAutoML Whether to perform automated machine learning (AutoML). The default is
#' `false`. For this case, you must specify `recipeArn`.
#' 
#' When set to `true`, Amazon Personalize analyzes your training data and
#' selects the optimal USER_PERSONALIZATION recipe and hyperparameters. In
#' this case, you must omit `recipeArn`. Amazon Personalize determines the
#' optimal recipe by running tests with different values for the
#' hyperparameters. AutoML lengthens the training process as compared to
#' selecting a specific recipe.
#' @param recipeArn The ARN of the recipe to use for model training. Only specified when
#' `performAutoML` is false.
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group that provides the
#' training data.
#' @param eventType When your have multiple event types (using an `EVENT_TYPE` schema
#' field), this parameter specifies which event type (for example, 'click'
#' or 'like') is used for training the model.
#' @param solutionConfig The configuration to use with the solution. When `performAutoML` is set
#' to true, Amazon Personalize only evaluates the `autoMLConfig` section of
#' the solution configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutionArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_solution(
#'   name = "string",
#'   performHPO = TRUE|FALSE,
#'   performAutoML = TRUE|FALSE,
#'   recipeArn = "string",
#'   datasetGroupArn = "string",
#'   eventType = "string",
#'   solutionConfig = list(
#'     eventValueThreshold = "string",
#'     hpoConfig = list(
#'       hpoObjective = list(
#'         type = "string",
#'         metricName = "string",
#'         metricRegex = "string"
#'       ),
#'       hpoResourceConfig = list(
#'         maxNumberOfTrainingJobs = "string",
#'         maxParallelTrainingJobs = "string"
#'       ),
#'       algorithmHyperParameterRanges = list(
#'         integerHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             minValue = 123,
#'             maxValue = 123
#'           )
#'         ),
#'         continuousHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             minValue = 123.0,
#'             maxValue = 123.0
#'           )
#'         ),
#'         categoricalHyperParameterRanges = list(
#'           list(
#'             name = "string",
#'             values = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     algorithmHyperParameters = list(
#'       "string"
#'     ),
#'     featureTransformationParameters = list(
#'       "string"
#'     ),
#'     autoMLConfig = list(
#'       metricName = "string",
#'       recipeList = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution
personalize_create_solution <- function(name, performHPO = NULL, performAutoML = NULL, recipeArn = NULL, datasetGroupArn, eventType = NULL, solutionConfig = NULL) {
  op <- new_operation(
    name = "CreateSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_solution_input(name = name, performHPO = performHPO, performAutoML = performAutoML, recipeArn = recipeArn, datasetGroupArn = datasetGroupArn, eventType = eventType, solutionConfig = solutionConfig)
  output <- .personalize$create_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution <- personalize_create_solution

#' Trains or retrains an active solution
#'
#' @description
#' Trains or retrains an active solution. A solution is created using the
#' [`create_solution`][personalize_create_solution] operation and must be
#' in the ACTIVE state before calling
#' [`create_solution_version`][personalize_create_solution_version]. A new
#' version of the solution is created every time you call this operation.
#' 
#' **Status**
#' 
#' A solution version can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' To get the status of the version, call
#' [`describe_solution_version`][personalize_describe_solution_version].
#' Wait until the status shows as ACTIVE before calling
#' [`create_campaign`][personalize_create_campaign].
#' 
#' If the status shows as CREATE FAILED, the response includes a
#' `failureReason` key, which describes why the job failed.
#' 
#' **Related APIs**
#' 
#' -   [`list_solution_versions`][personalize_list_solution_versions]
#' 
#' -   [`describe_solution_version`][personalize_describe_solution_version]
#' 
#' 
#' -   [`list_solutions`][personalize_list_solutions]
#' 
#' -   [`create_solution`][personalize_create_solution]
#' 
#' -   [`describe_solution`][personalize_describe_solution]
#' 
#' -   [`delete_solution`][personalize_delete_solution]
#'
#' @usage
#' personalize_create_solution_version(solutionArn, trainingMode)
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution containing the training
#' configuration information.
#' @param trainingMode The scope of training to be performed when creating the solution
#' version. The `FULL` option trains the solution version based on the
#' entirety of the input solution's training data, while the `UPDATE`
#' option processes only the data that has changed in comparison to the
#' input solution. Choose `UPDATE` when you want to incrementally update
#' your solution version instead of creating an entirely new one.
#' 
#' The `UPDATE` option can only be used when you already have an active
#' solution version created from the input solution using the `FULL` option
#' and the input solution was trained with the native-recipe-hrnn-coldstart
#' recipe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutionVersionArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_solution_version(
#'   solutionArn = "string",
#'   trainingMode = "FULL"|"UPDATE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_create_solution_version
personalize_create_solution_version <- function(solutionArn, trainingMode = NULL) {
  op <- new_operation(
    name = "CreateSolutionVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$create_solution_version_input(solutionArn = solutionArn, trainingMode = trainingMode)
  output <- .personalize$create_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$create_solution_version <- personalize_create_solution_version

#' Removes a campaign by deleting the solution deployment
#'
#' @description
#' Removes a campaign by deleting the solution deployment. The solution
#' that the campaign is based on is not deleted and can be redeployed when
#' needed. A deleted campaign can no longer be specified in a
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' request. For more information on campaigns, see
#' [`create_campaign`][personalize_create_campaign].
#'
#' @usage
#' personalize_delete_campaign(campaignArn)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_campaign(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_campaign
personalize_delete_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DeleteCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_campaign_input(campaignArn = campaignArn)
  output <- .personalize$delete_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_campaign <- personalize_delete_campaign

#' Deletes a dataset
#'
#' @description
#' Deletes a dataset. You can't delete a dataset if an associated
#' `DatasetImportJob` or `SolutionVersion` is in the CREATE PENDING or IN
#' PROGRESS state. For more information on datasets, see
#' [`create_dataset`][personalize_create_dataset].
#'
#' @usage
#' personalize_delete_dataset(datasetArn)
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dataset(
#'   datasetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset
personalize_delete_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DeleteDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_dataset_input(datasetArn = datasetArn)
  output <- .personalize$delete_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset <- personalize_delete_dataset

#' Deletes a dataset group
#'
#' @description
#' Deletes a dataset group. Before you delete a dataset group, you must
#' delete the following:
#' 
#' -   All associated event trackers.
#' 
#' -   All associated solutions.
#' 
#' -   All datasets in the dataset group.
#'
#' @usage
#' personalize_delete_dataset_group(datasetGroupArn)
#'
#' @param datasetGroupArn &#91;required&#93; The ARN of the dataset group to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dataset_group(
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_dataset_group
personalize_delete_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DeleteDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$delete_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_dataset_group <- personalize_delete_dataset_group

#' Deletes the event tracker
#'
#' @description
#' Deletes the event tracker. Does not delete the event-interactions
#' dataset from the associated dataset group. For more information on event
#' trackers, see
#' [`create_event_tracker`][personalize_create_event_tracker].
#'
#' @usage
#' personalize_delete_event_tracker(eventTrackerArn)
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_event_tracker(
#'   eventTrackerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_event_tracker
personalize_delete_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DeleteEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$delete_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_event_tracker <- personalize_delete_event_tracker

#' Deletes a filter
#'
#' @description
#' Deletes a filter.
#'
#' @usage
#' personalize_delete_filter(filterArn)
#'
#' @param filterArn &#91;required&#93; The ARN of the filter to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_filter(
#'   filterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_filter
personalize_delete_filter <- function(filterArn) {
  op <- new_operation(
    name = "DeleteFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_filter_input(filterArn = filterArn)
  output <- .personalize$delete_filter_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_filter <- personalize_delete_filter

#' Deletes a schema
#'
#' @description
#' Deletes a schema. Before deleting a schema, you must delete all datasets
#' referencing the schema. For more information on schemas, see
#' [`create_schema`][personalize_create_schema].
#'
#' @usage
#' personalize_delete_schema(schemaArn)
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_schema(
#'   schemaArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_schema
personalize_delete_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_schema_input(schemaArn = schemaArn)
  output <- .personalize$delete_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_schema <- personalize_delete_schema

#' Deletes all versions of a solution and the Solution object itself
#'
#' @description
#' Deletes all versions of a solution and the `Solution` object itself.
#' Before deleting a solution, you must delete all campaigns based on the
#' solution. To determine what campaigns are using the solution, call
#' [`list_campaigns`][personalize_list_campaigns] and supply the Amazon
#' Resource Name (ARN) of the solution. You can't delete a solution if an
#' associated `SolutionVersion` is in the CREATE PENDING or IN PROGRESS
#' state. For more information on solutions, see
#' [`create_solution`][personalize_create_solution].
#'
#' @usage
#' personalize_delete_solution(solutionArn)
#'
#' @param solutionArn &#91;required&#93; The ARN of the solution to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_solution(
#'   solutionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_delete_solution
personalize_delete_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DeleteSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$delete_solution_input(solutionArn = solutionArn)
  output <- .personalize$delete_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$delete_solution <- personalize_delete_solution

#' Describes the given algorithm
#'
#' @description
#' Describes the given algorithm.
#'
#' @usage
#' personalize_describe_algorithm(algorithmArn)
#'
#' @param algorithmArn &#91;required&#93; The Amazon Resource Name (ARN) of the algorithm to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   algorithm = list(
#'     name = "string",
#'     algorithmArn = "string",
#'     algorithmImage = list(
#'       name = "string",
#'       dockerURI = "string"
#'     ),
#'     defaultHyperParameters = list(
#'       "string"
#'     ),
#'     defaultHyperParameterRanges = list(
#'       integerHyperParameterRanges = list(
#'         list(
#'           name = "string",
#'           minValue = 123,
#'           maxValue = 123,
#'           isTunable = TRUE|FALSE
#'         )
#'       ),
#'       continuousHyperParameterRanges = list(
#'         list(
#'           name = "string",
#'           minValue = 123.0,
#'           maxValue = 123.0,
#'           isTunable = TRUE|FALSE
#'         )
#'       ),
#'       categoricalHyperParameterRanges = list(
#'         list(
#'           name = "string",
#'           values = list(
#'             "string"
#'           ),
#'           isTunable = TRUE|FALSE
#'         )
#'       )
#'     ),
#'     defaultResourceConfig = list(
#'       "string"
#'     ),
#'     trainingInputMode = "string",
#'     roleArn = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_algorithm(
#'   algorithmArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_algorithm
personalize_describe_algorithm <- function(algorithmArn) {
  op <- new_operation(
    name = "DescribeAlgorithm",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_algorithm_input(algorithmArn = algorithmArn)
  output <- .personalize$describe_algorithm_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_algorithm <- personalize_describe_algorithm

#' Gets the properties of a batch inference job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate the recommendations
#'
#' @description
#' Gets the properties of a batch inference job including name, Amazon
#' Resource Name (ARN), status, input and output configurations, and the
#' ARN of the solution version used to generate the recommendations.
#'
#' @usage
#' personalize_describe_batch_inference_job(batchInferenceJobArn)
#'
#' @param batchInferenceJobArn &#91;required&#93; The ARN of the batch inference job to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   batchInferenceJob = list(
#'     jobName = "string",
#'     batchInferenceJobArn = "string",
#'     filterArn = "string",
#'     failureReason = "string",
#'     solutionVersionArn = "string",
#'     numResults = 123,
#'     jobInput = list(
#'       s3DataSource = list(
#'         path = "string",
#'         kmsKeyArn = "string"
#'       )
#'     ),
#'     jobOutput = list(
#'       s3DataDestination = list(
#'         path = "string",
#'         kmsKeyArn = "string"
#'       )
#'     ),
#'     batchInferenceJobConfig = list(
#'       itemExplorationConfig = list(
#'         "string"
#'       )
#'     ),
#'     roleArn = "string",
#'     status = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_batch_inference_job(
#'   batchInferenceJobArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_batch_inference_job
personalize_describe_batch_inference_job <- function(batchInferenceJobArn) {
  op <- new_operation(
    name = "DescribeBatchInferenceJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_batch_inference_job_input(batchInferenceJobArn = batchInferenceJobArn)
  output <- .personalize$describe_batch_inference_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_batch_inference_job <- personalize_describe_batch_inference_job

#' Describes the given campaign, including its status
#'
#' @description
#' Describes the given campaign, including its status.
#' 
#' A campaign can be in one of the following states:
#' 
#' -   CREATE PENDING &gt; CREATE IN_PROGRESS &gt; ACTIVE -or- CREATE
#'     FAILED
#' 
#' -   DELETE PENDING &gt; DELETE IN_PROGRESS
#' 
#' When the `status` is `CREATE FAILED`, the response includes the
#' `failureReason` key, which describes why.
#' 
#' For more information on campaigns, see
#' [`create_campaign`][personalize_create_campaign].
#'
#' @usage
#' personalize_describe_campaign(campaignArn)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   campaign = list(
#'     name = "string",
#'     campaignArn = "string",
#'     solutionVersionArn = "string",
#'     minProvisionedTPS = 123,
#'     campaignConfig = list(
#'       itemExplorationConfig = list(
#'         "string"
#'       )
#'     ),
#'     status = "string",
#'     failureReason = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestCampaignUpdate = list(
#'       solutionVersionArn = "string",
#'       minProvisionedTPS = 123,
#'       campaignConfig = list(
#'         itemExplorationConfig = list(
#'           "string"
#'         )
#'       ),
#'       status = "string",
#'       failureReason = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_campaign(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_campaign
personalize_describe_campaign <- function(campaignArn) {
  op <- new_operation(
    name = "DescribeCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_campaign_input(campaignArn = campaignArn)
  output <- .personalize$describe_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_campaign <- personalize_describe_campaign

#' Describes the given dataset
#'
#' @description
#' Describes the given dataset. For more information on datasets, see
#' [`create_dataset`][personalize_create_dataset].
#'
#' @usage
#' personalize_describe_dataset(datasetArn)
#'
#' @param datasetArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   dataset = list(
#'     name = "string",
#'     datasetArn = "string",
#'     datasetGroupArn = "string",
#'     datasetType = "string",
#'     schemaArn = "string",
#'     status = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset(
#'   datasetArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset
personalize_describe_dataset <- function(datasetArn) {
  op <- new_operation(
    name = "DescribeDataset",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_input(datasetArn = datasetArn)
  output <- .personalize$describe_dataset_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset <- personalize_describe_dataset

#' Describes the given dataset group
#'
#' @description
#' Describes the given dataset group. For more information on dataset
#' groups, see [`create_dataset_group`][personalize_create_dataset_group].
#'
#' @usage
#' personalize_describe_dataset_group(datasetGroupArn)
#'
#' @param datasetGroupArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset group to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetGroup = list(
#'     name = "string",
#'     datasetGroupArn = "string",
#'     status = "string",
#'     roleArn = "string",
#'     kmsKeyArn = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     failureReason = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset_group(
#'   datasetGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_group
personalize_describe_dataset_group <- function(datasetGroupArn) {
  op <- new_operation(
    name = "DescribeDatasetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_group_input(datasetGroupArn = datasetGroupArn)
  output <- .personalize$describe_dataset_group_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_group <- personalize_describe_dataset_group

#' Describes the dataset import job created by CreateDatasetImportJob,
#' including the import job status
#'
#' @description
#' Describes the dataset import job created by
#' [`create_dataset_import_job`][personalize_create_dataset_import_job],
#' including the import job status.
#'
#' @usage
#' personalize_describe_dataset_import_job(datasetImportJobArn)
#'
#' @param datasetImportJobArn &#91;required&#93; The Amazon Resource Name (ARN) of the dataset import job to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetImportJob = list(
#'     jobName = "string",
#'     datasetImportJobArn = "string",
#'     datasetArn = "string",
#'     dataSource = list(
#'       dataLocation = "string"
#'     ),
#'     roleArn = "string",
#'     status = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     failureReason = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_dataset_import_job(
#'   datasetImportJobArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_dataset_import_job
personalize_describe_dataset_import_job <- function(datasetImportJobArn) {
  op <- new_operation(
    name = "DescribeDatasetImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_dataset_import_job_input(datasetImportJobArn = datasetImportJobArn)
  output <- .personalize$describe_dataset_import_job_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_dataset_import_job <- personalize_describe_dataset_import_job

#' Describes an event tracker
#'
#' @description
#' Describes an event tracker. The response includes the `trackingId` and
#' `status` of the event tracker. For more information on event trackers,
#' see [`create_event_tracker`][personalize_create_event_tracker].
#'
#' @usage
#' personalize_describe_event_tracker(eventTrackerArn)
#'
#' @param eventTrackerArn &#91;required&#93; The Amazon Resource Name (ARN) of the event tracker to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   eventTracker = list(
#'     name = "string",
#'     eventTrackerArn = "string",
#'     accountId = "string",
#'     trackingId = "string",
#'     datasetGroupArn = "string",
#'     status = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_event_tracker(
#'   eventTrackerArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_event_tracker
personalize_describe_event_tracker <- function(eventTrackerArn) {
  op <- new_operation(
    name = "DescribeEventTracker",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_event_tracker_input(eventTrackerArn = eventTrackerArn)
  output <- .personalize$describe_event_tracker_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_event_tracker <- personalize_describe_event_tracker

#' Describes the given feature transformation
#'
#' @description
#' Describes the given feature transformation.
#'
#' @usage
#' personalize_describe_feature_transformation(featureTransformationArn)
#'
#' @param featureTransformationArn &#91;required&#93; The Amazon Resource Name (ARN) of the feature transformation to
#' describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   featureTransformation = list(
#'     name = "string",
#'     featureTransformationArn = "string",
#'     defaultParameters = list(
#'       "string"
#'     ),
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     status = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_feature_transformation(
#'   featureTransformationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_feature_transformation
personalize_describe_feature_transformation <- function(featureTransformationArn) {
  op <- new_operation(
    name = "DescribeFeatureTransformation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_feature_transformation_input(featureTransformationArn = featureTransformationArn)
  output <- .personalize$describe_feature_transformation_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_feature_transformation <- personalize_describe_feature_transformation

#' Describes a filter's properties
#'
#' @description
#' Describes a filter's properties.
#'
#' @usage
#' personalize_describe_filter(filterArn)
#'
#' @param filterArn &#91;required&#93; The ARN of the filter to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   filter = list(
#'     name = "string",
#'     filterArn = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     datasetGroupArn = "string",
#'     failureReason = "string",
#'     filterExpression = "string",
#'     status = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_filter(
#'   filterArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_filter
personalize_describe_filter <- function(filterArn) {
  op <- new_operation(
    name = "DescribeFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_filter_input(filterArn = filterArn)
  output <- .personalize$describe_filter_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_filter <- personalize_describe_filter

#' Describes a recipe
#'
#' @description
#' Describes a recipe.
#' 
#' A recipe contains three items:
#' 
#' -   An algorithm that trains a model.
#' 
#' -   Hyperparameters that govern the training.
#' 
#' -   Feature transformation information for modifying the input data
#'     before training.
#' 
#' Amazon Personalize provides a set of predefined recipes. You specify a
#' recipe when you create a solution with the
#' [`create_solution`][personalize_create_solution] API.
#' [`create_solution`][personalize_create_solution] trains a model by using
#' the algorithm in the specified recipe and a training dataset. The
#' solution, when deployed as a campaign, can provide recommendations using
#' the
#' [GetRecommendations](https://docs.aws.amazon.com/personalize/latest/dg/API_RS_GetRecommendations.html)
#' API.
#'
#' @usage
#' personalize_describe_recipe(recipeArn)
#'
#' @param recipeArn &#91;required&#93; The Amazon Resource Name (ARN) of the recipe to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   recipe = list(
#'     name = "string",
#'     recipeArn = "string",
#'     algorithmArn = "string",
#'     featureTransformationArn = "string",
#'     status = "string",
#'     description = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     recipeType = "string",
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_recipe(
#'   recipeArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_recipe
personalize_describe_recipe <- function(recipeArn) {
  op <- new_operation(
    name = "DescribeRecipe",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_recipe_input(recipeArn = recipeArn)
  output <- .personalize$describe_recipe_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_recipe <- personalize_describe_recipe

#' Describes a schema
#'
#' @description
#' Describes a schema. For more information on schemas, see
#' [`create_schema`][personalize_create_schema].
#'
#' @usage
#' personalize_describe_schema(schemaArn)
#'
#' @param schemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the schema to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   schema = list(
#'     name = "string",
#'     schemaArn = "string",
#'     schema = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_schema(
#'   schemaArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_schema
personalize_describe_schema <- function(schemaArn) {
  op <- new_operation(
    name = "DescribeSchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_schema_input(schemaArn = schemaArn)
  output <- .personalize$describe_schema_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_schema <- personalize_describe_schema

#' Describes a solution
#'
#' @description
#' Describes a solution. For more information on solutions, see
#' [`create_solution`][personalize_create_solution].
#'
#' @usage
#' personalize_describe_solution(solutionArn)
#'
#' @param solutionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution to describe.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solution = list(
#'     name = "string",
#'     solutionArn = "string",
#'     performHPO = TRUE|FALSE,
#'     performAutoML = TRUE|FALSE,
#'     recipeArn = "string",
#'     datasetGroupArn = "string",
#'     eventType = "string",
#'     solutionConfig = list(
#'       eventValueThreshold = "string",
#'       hpoConfig = list(
#'         hpoObjective = list(
#'           type = "string",
#'           metricName = "string",
#'           metricRegex = "string"
#'         ),
#'         hpoResourceConfig = list(
#'           maxNumberOfTrainingJobs = "string",
#'           maxParallelTrainingJobs = "string"
#'         ),
#'         algorithmHyperParameterRanges = list(
#'           integerHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               minValue = 123,
#'               maxValue = 123
#'             )
#'           ),
#'           continuousHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               minValue = 123.0,
#'               maxValue = 123.0
#'             )
#'           ),
#'           categoricalHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               values = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       algorithmHyperParameters = list(
#'         "string"
#'       ),
#'       featureTransformationParameters = list(
#'         "string"
#'       ),
#'       autoMLConfig = list(
#'         metricName = "string",
#'         recipeList = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     autoMLResult = list(
#'       bestRecipeArn = "string"
#'     ),
#'     status = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     latestSolutionVersion = list(
#'       solutionVersionArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_solution(
#'   solutionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution
personalize_describe_solution <- function(solutionArn) {
  op <- new_operation(
    name = "DescribeSolution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_solution_input(solutionArn = solutionArn)
  output <- .personalize$describe_solution_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution <- personalize_describe_solution

#' Describes a specific version of a solution
#'
#' @description
#' Describes a specific version of a solution. For more information on
#' solutions, see [`create_solution`][personalize_create_solution].
#'
#' @usage
#' personalize_describe_solution_version(solutionVersionArn)
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutionVersion = list(
#'     solutionVersionArn = "string",
#'     solutionArn = "string",
#'     performHPO = TRUE|FALSE,
#'     performAutoML = TRUE|FALSE,
#'     recipeArn = "string",
#'     eventType = "string",
#'     datasetGroupArn = "string",
#'     solutionConfig = list(
#'       eventValueThreshold = "string",
#'       hpoConfig = list(
#'         hpoObjective = list(
#'           type = "string",
#'           metricName = "string",
#'           metricRegex = "string"
#'         ),
#'         hpoResourceConfig = list(
#'           maxNumberOfTrainingJobs = "string",
#'           maxParallelTrainingJobs = "string"
#'         ),
#'         algorithmHyperParameterRanges = list(
#'           integerHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               minValue = 123,
#'               maxValue = 123
#'             )
#'           ),
#'           continuousHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               minValue = 123.0,
#'               maxValue = 123.0
#'             )
#'           ),
#'           categoricalHyperParameterRanges = list(
#'             list(
#'               name = "string",
#'               values = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       algorithmHyperParameters = list(
#'         "string"
#'       ),
#'       featureTransformationParameters = list(
#'         "string"
#'       ),
#'       autoMLConfig = list(
#'         metricName = "string",
#'         recipeList = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     trainingHours = 123.0,
#'     trainingMode = "FULL"|"UPDATE",
#'     tunedHPOParams = list(
#'       algorithmHyperParameters = list(
#'         "string"
#'       )
#'     ),
#'     status = "string",
#'     failureReason = "string",
#'     creationDateTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUpdatedDateTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_solution_version(
#'   solutionVersionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_describe_solution_version
personalize_describe_solution_version <- function(solutionVersionArn) {
  op <- new_operation(
    name = "DescribeSolutionVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$describe_solution_version_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$describe_solution_version_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$describe_solution_version <- personalize_describe_solution_version

#' Gets the metrics for the specified solution version
#'
#' @description
#' Gets the metrics for the specified solution version.
#'
#' @usage
#' personalize_get_solution_metrics(solutionVersionArn)
#'
#' @param solutionVersionArn &#91;required&#93; The Amazon Resource Name (ARN) of the solution version for which to get
#' metrics.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutionVersionArn = "string",
#'   metrics = list(
#'     123.0
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_solution_metrics(
#'   solutionVersionArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_get_solution_metrics
personalize_get_solution_metrics <- function(solutionVersionArn) {
  op <- new_operation(
    name = "GetSolutionMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$get_solution_metrics_input(solutionVersionArn = solutionVersionArn)
  output <- .personalize$get_solution_metrics_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$get_solution_metrics <- personalize_get_solution_metrics

#' Gets a list of the batch inference jobs that have been performed off of
#' a solution version
#'
#' @description
#' Gets a list of the batch inference jobs that have been performed off of
#' a solution version.
#'
#' @usage
#' personalize_list_batch_inference_jobs(solutionVersionArn, nextToken,
#'   maxResults)
#'
#' @param solutionVersionArn The Amazon Resource Name (ARN) of the solution version from which the
#' batch inference jobs were created.
#' @param nextToken The token to request the next page of results.
#' @param maxResults The maximum number of batch inference job results to return in each
#' page. The default value is 100.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   batchInferenceJobs = list(
#'     list(
#'       batchInferenceJobArn = "string",
#'       jobName = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string",
#'       solutionVersionArn = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_batch_inference_jobs(
#'   solutionVersionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_batch_inference_jobs
personalize_list_batch_inference_jobs <- function(solutionVersionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListBatchInferenceJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_batch_inference_jobs_input(solutionVersionArn = solutionVersionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_batch_inference_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_batch_inference_jobs <- personalize_list_batch_inference_jobs

#' Returns a list of campaigns that use the given solution
#'
#' @description
#' Returns a list of campaigns that use the given solution. When a solution
#' is not specified, all the campaigns associated with the account are
#' listed. The response provides the properties for each campaign,
#' including the Amazon Resource Name (ARN). For more information on
#' campaigns, see [`create_campaign`][personalize_create_campaign].
#'
#' @usage
#' personalize_list_campaigns(solutionArn, nextToken, maxResults)
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution to list the campaigns
#' for. When a solution is not specified, all the campaigns associated with
#' the account are listed.
#' @param nextToken A token returned from the previous call to
#' [`list_campaigns`][personalize_list_campaigns] for getting the next set
#' of campaigns (if they exist).
#' @param maxResults The maximum number of campaigns to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   campaigns = list(
#'     list(
#'       name = "string",
#'       campaignArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_campaigns(
#'   solutionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_campaigns
personalize_list_campaigns <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListCampaigns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_campaigns_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_campaigns_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_campaigns <- personalize_list_campaigns

#' Returns a list of dataset groups
#'
#' @description
#' Returns a list of dataset groups. The response provides the properties
#' for each dataset group, including the Amazon Resource Name (ARN). For
#' more information on dataset groups, see
#' [`create_dataset_group`][personalize_create_dataset_group].
#'
#' @usage
#' personalize_list_dataset_groups(nextToken, maxResults)
#'
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_groups`][personalize_list_dataset_groups] for getting the
#' next set of dataset groups (if they exist).
#' @param maxResults The maximum number of dataset groups to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetGroups = list(
#'     list(
#'       name = "string",
#'       datasetGroupArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_dataset_groups(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_groups
personalize_list_dataset_groups <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_dataset_groups_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_groups_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_groups <- personalize_list_dataset_groups

#' Returns a list of dataset import jobs that use the given dataset
#'
#' @description
#' Returns a list of dataset import jobs that use the given dataset. When a
#' dataset is not specified, all the dataset import jobs associated with
#' the account are listed. The response provides the properties for each
#' dataset import job, including the Amazon Resource Name (ARN). For more
#' information on dataset import jobs, see
#' [`create_dataset_import_job`][personalize_create_dataset_import_job].
#' For more information on datasets, see
#' [`create_dataset`][personalize_create_dataset].
#'
#' @usage
#' personalize_list_dataset_import_jobs(datasetArn, nextToken, maxResults)
#'
#' @param datasetArn The Amazon Resource Name (ARN) of the dataset to list the dataset import
#' jobs for.
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_import_jobs`][personalize_list_dataset_import_jobs] for
#' getting the next set of dataset import jobs (if they exist).
#' @param maxResults The maximum number of dataset import jobs to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasetImportJobs = list(
#'     list(
#'       datasetImportJobArn = "string",
#'       jobName = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_dataset_import_jobs(
#'   datasetArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_dataset_import_jobs
personalize_list_dataset_import_jobs <- function(datasetArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasetImportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_dataset_import_jobs_input(datasetArn = datasetArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_dataset_import_jobs_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_dataset_import_jobs <- personalize_list_dataset_import_jobs

#' Returns the list of datasets contained in the given dataset group
#'
#' @description
#' Returns the list of datasets contained in the given dataset group. The
#' response provides the properties for each dataset, including the Amazon
#' Resource Name (ARN). For more information on datasets, see
#' [`create_dataset`][personalize_create_dataset].
#'
#' @usage
#' personalize_list_datasets(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group that contains the
#' datasets to list.
#' @param nextToken A token returned from the previous call to
#' [`list_dataset_import_jobs`][personalize_list_dataset_import_jobs] for
#' getting the next set of dataset import jobs (if they exist).
#' @param maxResults The maximum number of datasets to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   datasets = list(
#'     list(
#'       name = "string",
#'       datasetArn = "string",
#'       datasetType = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_datasets(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_datasets
personalize_list_datasets <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListDatasets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_datasets_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_datasets_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_datasets <- personalize_list_datasets

#' Returns the list of event trackers associated with the account
#'
#' @description
#' Returns the list of event trackers associated with the account. The
#' response provides the properties for each event tracker, including the
#' Amazon Resource Name (ARN) and tracking ID. For more information on
#' event trackers, see
#' [`create_event_tracker`][personalize_create_event_tracker].
#'
#' @usage
#' personalize_list_event_trackers(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The ARN of a dataset group used to filter the response.
#' @param nextToken A token returned from the previous call to
#' [`list_event_trackers`][personalize_list_event_trackers] for getting the
#' next set of event trackers (if they exist).
#' @param maxResults The maximum number of event trackers to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   eventTrackers = list(
#'     list(
#'       name = "string",
#'       eventTrackerArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_event_trackers(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_event_trackers
personalize_list_event_trackers <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventTrackers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_event_trackers_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_event_trackers_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_event_trackers <- personalize_list_event_trackers

#' Lists all filters that belong to a given dataset group
#'
#' @description
#' Lists all filters that belong to a given dataset group.
#'
#' @usage
#' personalize_list_filters(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The ARN of the dataset group that contains the filters.
#' @param nextToken A token returned from the previous call to
#' [`list_filters`][personalize_list_filters] for getting the next set of
#' filters (if they exist).
#' @param maxResults The maximum number of filters to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Filters = list(
#'     list(
#'       name = "string",
#'       filterArn = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       datasetGroupArn = "string",
#'       failureReason = "string",
#'       status = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_filters(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_filters
personalize_list_filters <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_filters_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_filters_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_filters <- personalize_list_filters

#' Returns a list of available recipes
#'
#' @description
#' Returns a list of available recipes. The response provides the
#' properties for each recipe, including the recipe's Amazon Resource Name
#' (ARN).
#'
#' @usage
#' personalize_list_recipes(recipeProvider, nextToken, maxResults)
#'
#' @param recipeProvider The default is `SERVICE`.
#' @param nextToken A token returned from the previous call to
#' [`list_recipes`][personalize_list_recipes] for getting the next set of
#' recipes (if they exist).
#' @param maxResults The maximum number of recipes to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   recipes = list(
#'     list(
#'       name = "string",
#'       recipeArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_recipes(
#'   recipeProvider = "SERVICE",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_recipes
personalize_list_recipes <- function(recipeProvider = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRecipes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_recipes_input(recipeProvider = recipeProvider, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_recipes_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_recipes <- personalize_list_recipes

#' Returns the list of schemas associated with the account
#'
#' @description
#' Returns the list of schemas associated with the account. The response
#' provides the properties for each schema, including the Amazon Resource
#' Name (ARN). For more information on schemas, see
#' [`create_schema`][personalize_create_schema].
#'
#' @usage
#' personalize_list_schemas(nextToken, maxResults)
#'
#' @param nextToken A token returned from the previous call to
#' [`list_schemas`][personalize_list_schemas] for getting the next set of
#' schemas (if they exist).
#' @param maxResults The maximum number of schemas to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   schemas = list(
#'     list(
#'       name = "string",
#'       schemaArn = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_schemas(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_schemas
personalize_list_schemas <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSchemas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_schemas_input(nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_schemas_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_schemas <- personalize_list_schemas

#' Returns a list of solution versions for the given solution
#'
#' @description
#' Returns a list of solution versions for the given solution. When a
#' solution is not specified, all the solution versions associated with the
#' account are listed. The response provides the properties for each
#' solution version, including the Amazon Resource Name (ARN). For more
#' information on solutions, see
#' [`create_solution`][personalize_create_solution].
#'
#' @usage
#' personalize_list_solution_versions(solutionArn, nextToken, maxResults)
#'
#' @param solutionArn The Amazon Resource Name (ARN) of the solution.
#' @param nextToken A token returned from the previous call to
#' [`list_solution_versions`][personalize_list_solution_versions] for
#' getting the next set of solution versions (if they exist).
#' @param maxResults The maximum number of solution versions to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutionVersions = list(
#'     list(
#'       solutionVersionArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       failureReason = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_solution_versions(
#'   solutionArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_solution_versions
personalize_list_solution_versions <- function(solutionArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutionVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_solution_versions_input(solutionArn = solutionArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solution_versions_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solution_versions <- personalize_list_solution_versions

#' Returns a list of solutions that use the given dataset group
#'
#' @description
#' Returns a list of solutions that use the given dataset group. When a
#' dataset group is not specified, all the solutions associated with the
#' account are listed. The response provides the properties for each
#' solution, including the Amazon Resource Name (ARN). For more information
#' on solutions, see [`create_solution`][personalize_create_solution].
#'
#' @usage
#' personalize_list_solutions(datasetGroupArn, nextToken, maxResults)
#'
#' @param datasetGroupArn The Amazon Resource Name (ARN) of the dataset group.
#' @param nextToken A token returned from the previous call to
#' [`list_solutions`][personalize_list_solutions] for getting the next set
#' of solutions (if they exist).
#' @param maxResults The maximum number of solutions to return.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   solutions = list(
#'     list(
#'       name = "string",
#'       solutionArn = "string",
#'       status = "string",
#'       creationDateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdatedDateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_solutions(
#'   datasetGroupArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_list_solutions
personalize_list_solutions <- function(datasetGroupArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListSolutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$list_solutions_input(datasetGroupArn = datasetGroupArn, nextToken = nextToken, maxResults = maxResults)
  output <- .personalize$list_solutions_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$list_solutions <- personalize_list_solutions

#' Updates a campaign by either deploying a new solution or changing the
#' value of the campaign's minProvisionedTPS parameter
#'
#' @description
#' Updates a campaign by either deploying a new solution or changing the
#' value of the campaign's `minProvisionedTPS` parameter.
#' 
#' To update a campaign, the campaign status must be ACTIVE or CREATE
#' FAILED. Check the campaign status using the
#' [`describe_campaign`][personalize_describe_campaign] API.
#' 
#' You must wait until the `status` of the updated campaign is `ACTIVE`
#' before asking the campaign for recommendations.
#' 
#' For more information on campaigns, see
#' [`create_campaign`][personalize_create_campaign].
#'
#' @usage
#' personalize_update_campaign(campaignArn, solutionVersionArn,
#'   minProvisionedTPS, campaignConfig)
#'
#' @param campaignArn &#91;required&#93; The Amazon Resource Name (ARN) of the campaign.
#' @param solutionVersionArn The ARN of a new solution version to deploy.
#' @param minProvisionedTPS Specifies the requested minimum provisioned transactions
#' (recommendations) per second that Amazon Personalize will support.
#' @param campaignConfig The configuration details of a campaign.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   campaignArn = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_campaign(
#'   campaignArn = "string",
#'   solutionVersionArn = "string",
#'   minProvisionedTPS = 123,
#'   campaignConfig = list(
#'     itemExplorationConfig = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname personalize_update_campaign
personalize_update_campaign <- function(campaignArn, solutionVersionArn = NULL, minProvisionedTPS = NULL, campaignConfig = NULL) {
  op <- new_operation(
    name = "UpdateCampaign",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .personalize$update_campaign_input(campaignArn = campaignArn, solutionVersionArn = solutionVersionArn, minProvisionedTPS = minProvisionedTPS, campaignConfig = campaignConfig)
  output <- .personalize$update_campaign_output()
  config <- get_config()
  svc <- .personalize$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.personalize$operations$update_campaign <- personalize_update_campaign
