% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_start_medical_transcription_job}
\alias{transcribeservice_start_medical_transcription_job}
\title{Starts a batch job to transcribe medical speech to text}
\usage{
transcribeservice_start_medical_transcription_job(
  MedicalTranscriptionJobName, LanguageCode, MediaSampleRateHertz,
  MediaFormat, Media, OutputBucketName, OutputKey,
  OutputEncryptionKMSKeyId, Settings, Specialty, Type)
}
\arguments{
\item{MedicalTranscriptionJobName}{[required] The name of the medical transcription job. You can't use the strings
"\code{.}" or "\code{..}" by themselves as the job name. The name must also be
unique within an AWS account. If you try to create a medical
transcription job with the same name as a previous medical transcription
job, you get a \code{ConflictException} error.}

\item{LanguageCode}{[required] The language code for the language spoken in the input media file. US
English (en-US) is the valid value for medical transcription jobs. Any
other value you enter for language code results in a
\code{BadRequestException} error.}

\item{MediaSampleRateHertz}{The sample rate, in Hertz, of the audio track in the input media file.

If you do not specify the media sample rate, Amazon Transcribe Medical
determines the sample rate. If you specify the sample rate, it must
match the rate detected by Amazon Transcribe Medical. In most cases, you
should leave the \code{MediaSampleRateHertz} field blank and let Amazon
Transcribe Medical determine the sample rate.}

\item{MediaFormat}{The audio format of the input media file.}

\item{Media}{[required]}

\item{OutputBucketName}{[required] The Amazon S3 location where the transcription is stored.

You must set \code{OutputBucketName} for Amazon Transcribe Medical to store
the transcription results. Your transcript appears in the S3 location
you specify. When you call the
\code{\link[=transcribeservice_get_medical_transcription_job]{get_medical_transcription_job}},
the operation returns this location in the \code{TranscriptFileUri} field.
The S3 bucket must have permissions that allow Amazon Transcribe Medical
to put files in the bucket. For more information, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/security_iam_id-based-policy-examples.html#auth-role-iam-user}{Permissions Required for IAM User Roles}.

You can specify an AWS Key Management Service (KMS) key to encrypt the
output of your transcription using the \code{OutputEncryptionKMSKeyId}
parameter. If you don't specify a KMS key, Amazon Transcribe Medical
uses the default Amazon S3 key for server-side encryption of transcripts
that are placed in your S3 bucket.}

\item{OutputKey}{You can specify a location in an Amazon S3 bucket to store the output of
your medical transcription job.

If you don't specify an output key, Amazon Transcribe Medical stores the
output of your transcription job in the Amazon S3 bucket you specified.
By default, the object key is "your-transcription-job-name.json".

You can use output keys to specify the Amazon S3 prefix and file name of
the transcription output. For example, specifying the Amazon S3 prefix,
"folder1/folder2/", as an output key would lead to the output being
stored as "folder1/folder2/your-transcription-job-name.json". If you
specify "my-other-job-name.json" as the output key, the object key is
changed to "my-other-job-name.json". You can use an output key to change
both the prefix and the file name, for example
"folder/my-other-job-name.json".

If you specify an output key, you must also specify an S3 bucket in the
\code{OutputBucketName} parameter.}

\item{OutputEncryptionKMSKeyId}{The Amazon Resource Name (ARN) of the AWS Key Management Service (KMS)
key used to encrypt the output of the transcription job. The user
calling the
\code{\link[=transcribeservice_start_medical_transcription_job]{start_medical_transcription_job}}
operation must have permission to use the specified KMS key.

You use either of the following to identify a KMS key in the current
account:
\itemize{
\item KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
\item KMS Key Alias: "alias/ExampleAlias"
}

You can use either of the following to identify a KMS key in the current
account or another account:
\itemize{
\item Amazon Resource Name (ARN) of a KMS key in the current account or
another account: "arn:aws:kms:region:account
ID:key/1234abcd-12ab-34cd-56ef-1234567890ab"
\item ARN of a KMS Key Alias: "arn:aws:kms:region:account
ID:alias/ExampleAlias"
}

If you don't specify an encryption key, the output of the medical
transcription job is encrypted with the default Amazon S3 key (SSE-S3).

If you specify a KMS key to encrypt your output, you must also specify
an output location in the \code{OutputBucketName} parameter.}

\item{Settings}{Optional settings for the medical transcription job.}

\item{Specialty}{[required] The medical specialty of any clinician speaking in the input media.}

\item{Type}{[required] The type of speech in the input audio. \code{CONVERSATION} refers to
conversations between two or more speakers, e.g., a conversations
between doctors and patients. \code{DICTATION} refers to single-speaker
dictated speech, e.g., for clinical notes.}
}
\value{
A list with the following syntax:\preformatted{list(
  MedicalTranscriptionJob = list(
    MedicalTranscriptionJobName = "string",
    TranscriptionJobStatus = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
    LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
    MediaSampleRateHertz = 123,
    MediaFormat = "mp3"|"mp4"|"wav"|"flac"|"ogg"|"amr"|"webm",
    Media = list(
      MediaFileUri = "string"
    ),
    Transcript = list(
      TranscriptFileUri = "string"
    ),
    StartTime = as.POSIXct(
      "2015-01-01"
    ),
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    CompletionTime = as.POSIXct(
      "2015-01-01"
    ),
    FailureReason = "string",
    Settings = list(
      ShowSpeakerLabels = TRUE|FALSE,
      MaxSpeakerLabels = 123,
      ChannelIdentification = TRUE|FALSE,
      ShowAlternatives = TRUE|FALSE,
      MaxAlternatives = 123,
      VocabularyName = "string"
    ),
    Specialty = "PRIMARYCARE",
    Type = "CONVERSATION"|"DICTATION"
  )
)
}
}
\description{
Starts a batch job to transcribe medical speech to text.
}
\section{Request syntax}{
\preformatted{svc$start_medical_transcription_job(
  MedicalTranscriptionJobName = "string",
  LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
  MediaSampleRateHertz = 123,
  MediaFormat = "mp3"|"mp4"|"wav"|"flac"|"ogg"|"amr"|"webm",
  Media = list(
    MediaFileUri = "string"
  ),
  OutputBucketName = "string",
  OutputKey = "string",
  OutputEncryptionKMSKeyId = "string",
  Settings = list(
    ShowSpeakerLabels = TRUE|FALSE,
    MaxSpeakerLabels = 123,
    ChannelIdentification = TRUE|FALSE,
    ShowAlternatives = TRUE|FALSE,
    MaxAlternatives = 123,
    VocabularyName = "string"
  ),
  Specialty = "PRIMARYCARE",
  Type = "CONVERSATION"|"DICTATION"
)
}
}

\keyword{internal}
