% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_operations.R
\name{lexruntimeservice_post_content}
\alias{lexruntimeservice_post_content}
\title{Sends user input (text or speech) to Amazon Lex}
\usage{
lexruntimeservice_post_content(botName, botAlias, userId,
  sessionAttributes, requestAttributes, contentType, accept, inputStream)
}
\arguments{
\item{botName}{[required] Name of the Amazon Lex bot.}

\item{botAlias}{[required] Alias of the Amazon Lex bot.}

\item{userId}{[required] The ID of the client application user. Amazon Lex uses this to identify
a user's conversation with your bot. At runtime, each request must
contain the \code{userID} field.

To decide the user ID to use for your application, consider the
following factors.
\itemize{
\item The \code{userID} field must not contain any personally identifiable
information of the user, for example, name, personal identification
numbers, or other end user personal information.
\item If you want a user to start a conversation on one device and
continue on another device, use a user-specific identifier.
\item If you want the same user to be able to have two independent
conversations on two different devices, choose a device-specific
identifier.
\item A user can't have two independent conversations with two different
versions of the same bot. For example, a user can't have a
conversation with the PROD and BETA versions of the same bot. If you
anticipate that a user will need to have conversation with two
different versions, for example, while testing, include the bot
alias in the user ID to separate the two conversations.
}}

\item{sessionAttributes}{You pass this value as the \code{x-amz-lex-session-attributes} HTTP header.

Application-specific information passed between Amazon Lex and a client
application. The value must be a JSON serialized and base64 encoded map
with string keys and values. The total size of the \code{sessionAttributes}
and \code{requestAttributes} headers is limited to 12 KB.

For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs}{Setting Session Attributes}.}

\item{requestAttributes}{You pass this value as the \code{x-amz-lex-request-attributes} HTTP header.

Request-specific information passed between Amazon Lex and a client
application. The value must be a JSON serialized and base64 encoded map
with string keys and values. The total size of the \code{requestAttributes}
and \code{sessionAttributes} headers is limited to 12 KB.

The namespace \code{x-amz-lex:} is reserved for special attributes. Don't
create any request attributes with the prefix \code{x-amz-lex:}.

For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs}{Setting Request Attributes}.}

\item{contentType}{[required] You pass this value as the \code{Content-Type} HTTP header.

Indicates the audio format or text. The header value must start with one
of the following prefixes:
\itemize{
\item PCM format, audio data must be in little-endian byte order.
\itemize{
\item audio/l16; rate=16000; channels=1
\item audio/x-l16; sample-rate=16000; channel-count=1
\item audio/lpcm; sample-rate=8000; sample-size-bits=16;
channel-count=1; is-big-endian=false
}
\item Opus format
\itemize{
\item audio/x-cbr-opus-with-preamble; preamble-size=0;
bit-rate=256000; frame-size-milliseconds=4
}
\item Text format
\itemize{
\item text/plain; charset=utf-8
}
}}

\item{accept}{You pass this value as the \code{Accept} HTTP header.

The message Amazon Lex returns in the response can be either text or
speech based on the \code{Accept} HTTP header value in the request.
\itemize{
\item If the value is \code{text/plain; charset=utf-8}, Amazon Lex returns text
in the response.
\item If the value begins with \code{audio/}, Amazon Lex returns speech in the
response. Amazon Lex uses Amazon Polly to generate the speech (using
the configuration you specified in the \code{Accept} header). For
example, if you specify \code{audio/mpeg} as the value, Amazon Lex
returns speech in the MPEG format.

The following are the accepted values:
\itemize{
\item audio/mpeg
\item audio/ogg
\item audio/pcm
\item text/plain; charset=utf-8
\item audio/* (defaults to mpeg)
}
}}

\item{inputStream}{[required] User input in PCM or Opus audio format or text format as described in
the \code{Content-Type} HTTP header.

You can stream audio data to Amazon Lex or you can create a local buffer
that captures all of the audio data before sending. In general, you get
better performance if you stream audio data rather than buffering the
data locally.}
}
\description{
Sends user input (text or speech) to Amazon Lex. Clients use this API to
send text and audio requests to Amazon Lex at runtime. Amazon Lex
interprets the user input using the machine learning model that it built
for the bot.
}
\details{
The \code{PostContent} operation supports audio input at 8kHz and 16kHz. You
can use 8kHz audio to achieve higher speech recognition accuracy in
telephone audio applications.

In response, Amazon Lex returns the next message to convey to the user.
Consider the following example messages:
\itemize{
\item For a user input "I would like a pizza," Amazon Lex might return a
response with a message eliciting slot data (for example,
\code{PizzaSize}): "What size pizza would you like?".
\item After the user provides all of the pizza order information, Amazon
Lex might return a response with a message to get user confirmation:
"Order the pizza?".
\item After the user replies "Yes" to the confirmation prompt, Amazon
Lex might return a conclusion statement: "Thank you, your cheese
pizza has been ordered.".
}

Not all Amazon Lex messages require a response from the user. For
example, conclusion statements do not require a response. Some messages
require only a yes or no response. In addition to the \code{message}, Amazon
Lex provides additional context about the message in the response that
you can use to enhance client behavior, such as displaying the
appropriate client user interface. Consider the following examples:
\itemize{
\item If the message is to elicit slot data, Amazon Lex returns the
following context information:
\item \code{x-amz-lex-dialog-state} header set to \code{ElicitSlot}
\item \code{x-amz-lex-intent-name} header set to the intent name in the
current context
\item \code{x-amz-lex-slot-to-elicit} header set to the slot name for which
the \code{message} is eliciting information
\item \code{x-amz-lex-slots} header set to a map of slots configured for
the intent with their current values
\item If the message is a confirmation prompt, the
\code{x-amz-lex-dialog-state} header is set to \code{Confirmation} and the
\code{x-amz-lex-slot-to-elicit} header is omitted.
\item If the message is a clarification prompt configured for the intent,
indicating that the user intent is not understood, the
\code{x-amz-dialog-state} header is set to \code{ElicitIntent} and the
\code{x-amz-slot-to-elicit} header is omitted.
}

In addition, Amazon Lex also returns your application-specific
\code{sessionAttributes}. For more information, see \href{http://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html}{Managing Conversation Context}.
}
\section{Request syntax}{
\preformatted{svc$post_content(
  botName = "string",
  botAlias = "string",
  userId = "string",
  sessionAttributes = "string",
  requestAttributes = "string",
  contentType = "string",
  accept = "string",
  inputStream = raw
)
}
}

\keyword{internal}
