% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_add_tags}
\alias{machinelearning_add_tags}
\title{Adds one or more tags to an object, up to a limit of 10}
\usage{
machinelearning_add_tags(Tags, ResourceId, ResourceType)
}
\arguments{
\item{Tags}{[required] The key-value pairs to use to create tags. If you specify a key without
specifying a value, Amazon ML creates a tag with the specified key and a
value of null.}

\item{ResourceId}{[required] The ID of the ML object to tag. For example, \code{exampleModelId}.}

\item{ResourceType}{[required] The type of the ML object to tag.}
}
\description{
Adds one or more tags to an object, up to a limit of 10. Each tag
consists of a key and an optional value. If you add a tag using a key
that is already associated with the ML object, \code{AddTags} updates the
tag's value.
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  ResourceId = "string",
  ResourceType = "BatchPrediction"|"DataSource"|"Evaluation"|"MLModel"
)
}
}

\keyword{internal}
