% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_list_endpoints}
\alias{comprehend_list_endpoints}
\title{Gets a list of all existing endpoints that you've created}
\usage{
comprehend_list_endpoints(Filter, NextToken, MaxResults)
}
\arguments{
\item{Filter}{Filters the endpoints that are returned. You can filter endpoints on
their name, model, status, or the date and time that they were created.
You can only set one filter at a time.}

\item{NextToken}{Identifies the next page of results to return.}

\item{MaxResults}{The maximum number of results to return in each page. The default is
100.}
}
\description{
Gets a list of all existing endpoints that you\'ve created.
}
\section{Request syntax}{
\preformatted{svc$list_endpoints(
  Filter = list(
    ModelArn = "string",
    Status = "CREATING"|"DELETING"|"FAILED"|"IN_SERVICE"|"UPDATING",
    CreationTimeBefore = as.POSIXct(
      "2015-01-01"
    ),
    CreationTimeAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
