% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_predictor}
\alias{forecastservice_create_predictor}
\title{This operation creates a legacy predictor that does not include all the
predictor functionalities provided by Amazon Forecast}
\usage{
forecastservice_create_predictor(
  PredictorName,
  AlgorithmArn = NULL,
  ForecastHorizon,
  ForecastTypes = NULL,
  PerformAutoML = NULL,
  AutoMLOverrideStrategy = NULL,
  PerformHPO = NULL,
  TrainingParameters = NULL,
  EvaluationParameters = NULL,
  HPOConfig = NULL,
  InputDataConfig,
  FeaturizationConfig,
  EncryptionConfig = NULL,
  Tags = NULL,
  OptimizationMetric = NULL
)
}
\arguments{
\item{PredictorName}{[required] A name for the predictor.}

\item{AlgorithmArn}{The Amazon Resource Name (ARN) of the algorithm to use for model
training. Required if \code{PerformAutoML} is not set to \code{true}.

\strong{Supported algorithms:}
\itemize{
\item \code{arn:aws:forecast:::algorithm/ARIMA}
\item \code{arn:aws:forecast:::algorithm/CNN-QR}
\item \code{arn:aws:forecast:::algorithm/Deep_AR_Plus}
\item \code{arn:aws:forecast:::algorithm/ETS}
\item \code{arn:aws:forecast:::algorithm/NPTS}
\item \code{arn:aws:forecast:::algorithm/Prophet}
}}

\item{ForecastHorizon}{[required] Specifies the number of time-steps that the model is trained to predict.
The forecast horizon is also called the prediction length.

For example, if you configure a dataset for daily data collection (using
the \code{DataFrequency} parameter of the
\code{\link[=forecastservice_create_dataset]{create_dataset}} operation) and set
the forecast horizon to 10, the model returns predictions for 10 days.

The maximum forecast horizon is the lesser of 500 time-steps or 1/3 of
the TARGET_TIME_SERIES dataset length.}

\item{ForecastTypes}{Specifies the forecast types used to train a predictor. You can specify
up to five forecast types. Forecast types can be quantiles from 0.01 to
0.99, by increments of 0.01 or higher. You can also specify the mean
forecast with \code{mean}.

The default value is \verb{["0.10", "0.50", "0.9"]}.}

\item{PerformAutoML}{Whether to perform AutoML. When Amazon Forecast performs AutoML, it
evaluates the algorithms it provides and chooses the best algorithm and
configuration for your training dataset.

The default value is \code{false}. In this case, you are required to specify
an algorithm.

Set \code{PerformAutoML} to \code{true} to have Amazon Forecast perform AutoML.
This is a good option if you aren't sure which algorithm is suitable for
your training data. In this case, \code{PerformHPO} must be false.}

\item{AutoMLOverrideStrategy}{The \code{LatencyOptimized} AutoML override strategy is only available in
private beta. Contact AWS Support or your account manager to learn more
about access privileges.

Used to overide the default AutoML strategy, which is to optimize
predictor accuracy. To apply an AutoML strategy that minimizes training
time, use \code{LatencyOptimized}.

This parameter is only valid for predictors trained using AutoML.}

\item{PerformHPO}{Whether to perform hyperparameter optimization (HPO). HPO finds optimal
hyperparameter values for your training data. The process of performing
HPO is known as running a hyperparameter tuning job.

The default value is \code{false}. In this case, Amazon Forecast uses default
hyperparameter values from the chosen algorithm.

To override the default values, set \code{PerformHPO} to \code{true} and,
optionally, supply the HyperParameterTuningJobConfig object. The tuning
job specifies a metric to optimize, which hyperparameters participate in
tuning, and the valid range for each tunable hyperparameter. In this
case, you are required to specify an algorithm and \code{PerformAutoML} must
be false.

The following algorithms support HPO:
\itemize{
\item DeepAR+
\item CNN-QR
}}

\item{TrainingParameters}{The hyperparameters to override for model training. The hyperparameters
that you can override are listed in the individual algorithms. For the
list of supported algorithms, see aws-forecast-choosing-recipes.}

\item{EvaluationParameters}{Used to override the default evaluation parameters of the specified
algorithm. Amazon Forecast evaluates a predictor by splitting a dataset
into training data and testing data. The evaluation parameters define
how to perform the split and the number of iterations.}

\item{HPOConfig}{Provides hyperparameter override values for the algorithm. If you don't
provide this parameter, Amazon Forecast uses default values. The
individual algorithms specify which hyperparameters support
hyperparameter optimization (HPO). For more information, see
aws-forecast-choosing-recipes.

If you included the \code{HPOConfig} object, you must set \code{PerformHPO} to
true.}

\item{InputDataConfig}{[required] Describes the dataset group that contains the data to use to train the
predictor.}

\item{FeaturizationConfig}{[required] The featurization configuration.}

\item{EncryptionConfig}{An AWS Key Management Service (KMS) key and the AWS Identity and Access
Management (IAM) role that Amazon Forecast can assume to access the key.}

\item{Tags}{The optional metadata that you apply to the predictor to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for keys as it is reserved for AWS use. You cannot
edit or delete tag keys with this prefix. Values can have this
prefix. If a tag value has \code{aws} as its prefix but the key does not,
then Forecast considers it to be a user tag and will count against
the limit of 50 tags. Tags with only the key prefix of \code{aws} do not
count against your tags per resource limit.
}}

\item{OptimizationMetric}{The accuracy metric used to optimize the predictor.}
}
\description{
This operation creates a legacy predictor that does not include all the predictor functionalities provided by Amazon Forecast. To create a predictor that is compatible with all aspects of Forecast, use \code{\link[=forecastservice_create_auto_predictor]{create_auto_predictor}}.

See \url{https://paws-r.github.io/docs/forecastservice/create_predictor.html} for full documentation.
}
\keyword{internal}
