% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_update_resource_policy}
\alias{lexmodelsv2_update_resource_policy}
\title{Replaces the existing resource policy for a bot or bot alias with a new
one}
\usage{
lexmodelsv2_update_resource_policy(
  resourceArn,
  policy,
  expectedRevisionId = NULL
)
}
\arguments{
\item{resourceArn}{[required] The Amazon Resource Name (ARN) of the bot or bot alias that the resource
policy is attached to.}

\item{policy}{[required] A resource policy to add to the resource. The policy is a JSON structure
that contains one or more statements that define the policy. The policy
must follow the IAM syntax. For more information about the contents of a
JSON policy document, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON policy reference}
.

If the policy isn't valid, Amazon Lex returns a validation exception.}

\item{expectedRevisionId}{The identifier of the revision of the policy to update. If this revision
ID doesn't match the current revision ID, Amazon Lex throws an
exception.

If you don't specify a revision, Amazon Lex overwrites the contents of
the policy with the new values.}
}
\description{
Replaces the existing resource policy for a bot or bot alias with a new one. If the policy doesn't exist, Amazon Lex returns an exception.

See \url{https://paws-r.github.io/docs/lexmodelsv2/update_resource_policy.html} for full documentation.
}
\keyword{internal}
