% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_create_medical_vocabulary}
\alias{transcribeservice_create_medical_vocabulary}
\title{Creates a new custom medical vocabulary}
\usage{
transcribeservice_create_medical_vocabulary(
  VocabularyName,
  LanguageCode,
  VocabularyFileUri,
  Tags = NULL
)
}
\arguments{
\item{VocabularyName}{[required] A unique name, chosen by you, for your new custom medical vocabulary.

This name is case sensitive, cannot contain spaces, and must be unique
within an Amazon Web Services account. If you try to create a new
medical vocabulary with the same name as an existing medical vocabulary,
you get a \code{ConflictException} error.}

\item{LanguageCode}{[required] The language code that represents the language of the entries in your
custom vocabulary. US English (\code{en-US}) is the only language supported
with Amazon Transcribe Medical.}

\item{VocabularyFileUri}{[required] The Amazon S3 location (URI) of the text file that contains your custom
medical vocabulary. The URI must be in the same Amazon Web Services
Region as the resource you're calling.

Here's an example URI path: \verb{s3://DOC-EXAMPLE-BUCKET/my-vocab-file.txt}}

\item{Tags}{Adds one or more custom tags, each in the form of a key:value pair, to a
new medical vocabulary at the time you create this new vocabulary.

To learn more about using tags with Amazon Transcribe, refer to \href{https://docs.aws.amazon.com/transcribe/latest/dg/tagging.html}{Tagging resources}.}
}
\description{
Creates a new custom medical vocabulary.

See \url{https://paws-r.github.io/docs/transcribeservice/create_medical_vocabulary.html} for full documentation.
}
\keyword{internal}
