% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frauddetector_operations.R
\name{frauddetector_create_detector_version}
\alias{frauddetector_create_detector_version}
\title{Creates a detector version}
\usage{
frauddetector_create_detector_version(
  detectorId,
  description = NULL,
  externalModelEndpoints = NULL,
  rules,
  modelVersions = NULL,
  ruleExecutionMode = NULL,
  tags = NULL
)
}
\arguments{
\item{detectorId}{[required] The ID of the detector under which you want to create a new version.}

\item{description}{The description of the detector version.}

\item{externalModelEndpoints}{The Amazon Sagemaker model endpoints to include in the detector version.}

\item{rules}{[required] The rules to include in the detector version.}

\item{modelVersions}{The model versions to include in the detector version.}

\item{ruleExecutionMode}{The rule execution mode for the rules included in the detector version.

You can define and edit the rule mode at the detector version level,
when it is in draft status.

If you specify \code{FIRST_MATCHED}, Amazon Fraud Detector evaluates rules
sequentially, first to last, stopping at the first matched rule. Amazon
Fraud dectector then provides the outcomes for that single rule.

If you specifiy \code{ALL_MATCHED}, Amazon Fraud Detector evaluates all rules
and returns the outcomes for all matched rules.

The default behavior is \code{FIRST_MATCHED}.}

\item{tags}{A collection of key and value pairs.}
}
\description{
Creates a detector version. The detector version starts in a \code{DRAFT} status.

See \url{https://www.paws-r-sdk.com/docs/frauddetector_create_detector_version/} for full documentation.
}
\keyword{internal}
