% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelsv2_operations.R
\name{lexmodelsv2_update_intent}
\alias{lexmodelsv2_update_intent}
\title{Updates the settings for an intent}
\usage{
lexmodelsv2_update_intent(
  intentId,
  intentName,
  description = NULL,
  parentIntentSignature = NULL,
  sampleUtterances = NULL,
  dialogCodeHook = NULL,
  fulfillmentCodeHook = NULL,
  slotPriorities = NULL,
  intentConfirmationSetting = NULL,
  intentClosingSetting = NULL,
  inputContexts = NULL,
  outputContexts = NULL,
  kendraConfiguration = NULL,
  botId,
  botVersion,
  localeId,
  initialResponseSetting = NULL
)
}
\arguments{
\item{intentId}{[required] The unique identifier of the intent to update.}

\item{intentName}{[required] The new name for the intent.}

\item{description}{The new description of the intent.}

\item{parentIntentSignature}{The signature of the new built-in intent to use as the parent of this
intent.}

\item{sampleUtterances}{New utterances used to invoke the intent.}

\item{dialogCodeHook}{The new Lambda function to use between each turn of the conversation
with the bot.}

\item{fulfillmentCodeHook}{The new Lambda function to call when all of the intents required slots
are provided and the intent is ready for fulfillment.}

\item{slotPriorities}{A new list of slots and their priorities that are contained by the
intent.}

\item{intentConfirmationSetting}{New prompts that Amazon Lex sends to the user to confirm the completion
of an intent.}

\item{intentClosingSetting}{The new response that Amazon Lex sends the user when the intent is
closed.}

\item{inputContexts}{A new list of contexts that must be active in order for Amazon Lex to
consider the intent.}

\item{outputContexts}{A new list of contexts that Amazon Lex activates when the intent is
fulfilled.}

\item{kendraConfiguration}{New configuration settings for connecting to an Amazon Kendra index.}

\item{botId}{[required] The identifier of the bot that contains the intent.}

\item{botVersion}{[required] The version of the bot that contains the intent. Must be \code{DRAFT}.}

\item{localeId}{[required] The identifier of the language and locale where this intent is used. The
string must match one of the supported locales. For more information,
see \href{https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html}{Supported languages}.}

\item{initialResponseSetting}{Configuration settings for a response sent to the user before Amazon Lex
starts eliciting slots.}
}
\description{
Updates the settings for an intent.

See \url{https://www.paws-r-sdk.com/docs/lexmodelsv2_update_intent/} for full documentation.
}
\keyword{internal}
