% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_put_rule}
\alias{cloudwatchevents_put_rule}
\title{Creates or updates the specified rule}
\usage{
cloudwatchevents_put_rule(Name, ScheduleExpression, EventPattern, State,
  Description, RoleArn, Tags)
}
\arguments{
\item{Name}{[required] The name of the rule that you are creating or updating.}

\item{ScheduleExpression}{The scheduling expression. For example, "cron(0 20 * * ? *)" or
"rate(5 minutes)".}

\item{EventPattern}{The event pattern. For more information, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEventsandEventPatterns.html}{Events and Event Patterns}
in the \emph{Amazon CloudWatch Events User Guide}.}

\item{State}{Indicates whether the rule is enabled or disabled.}

\item{Description}{A description of the rule.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role associated with the rule.}

\item{Tags}{The list of key-value pairs to associate with the rule.}
}
\description{
Creates or updates the specified rule. Rules are enabled by default, or
based on value of the state. You can disable a rule using DisableRule.
}
\details{
If you are updating an existing rule, the rule is replaced with what you
specify in this \code{PutRule} command. If you omit arguments in \code{PutRule},
the old values for those arguments are not kept. Instead, they are
replaced with null values.

When you create or update a rule, incoming events might not immediately
start matching to new or updated rules. Allow a short period of time for
changes to take effect.

A rule must contain at least an EventPattern or ScheduleExpression.
Rules with EventPatterns are triggered when a matching event is
observed. Rules with ScheduleExpressions self-trigger based on the given
schedule. A rule can have both an EventPattern and a ScheduleExpression,
in which case the rule triggers on matching events as well as on a
schedule.

When you initially create a rule, you can optionally assign one or more
tags to the rule. Tags can help you organize and categorize your
resources. You can also use them to scope user permissions, by granting
a user permission to access or change only rules with certain tag
values. To use the \code{PutRule} operation and assign tags, you must have
both the \code{events:PutRule} and \code{events:TagResource} permissions.

If you are updating an existing rule, any tags you specify in the
\code{PutRule} operation are ignored. To update the tags of an existing rule,
use TagResource and UntagResource.

Most services in AWS treat : or / as the same character in Amazon
Resource Names (ARNs). However, CloudWatch Events uses an exact match in
event patterns and rules. Be sure to use the correct ARN characters when
creating event patterns so that they match the ARN syntax in the event
you want to match.

In CloudWatch Events, it is possible to create rules that lead to
infinite loops, where a rule is fired repeatedly. For example, a rule
might detect that ACLs have changed on an S3 bucket, and trigger
software to change them to the desired state. If the rule is not written
carefully, the subsequent change to the ACLs fires the rule again,
creating an infinite loop.

To prevent this, write the rules so that the triggered actions do not
re-fire the same rule. For example, your rule could fire only if ACLs
are found to be in a bad state, instead of after any change.

An infinite loop can quickly cause higher than expected charges. We
recommend that you use budgeting, which alerts you when charges exceed
your specified limit. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/budgets-managing-costs.html}{Managing Your Costs with Budgets}.
}
\section{Request syntax}{
\preformatted{svc$put_rule(
  Name = "string",
  ScheduleExpression = "string",
  EventPattern = "string",
  State = "ENABLED"|"DISABLED",
  Description = "string",
  RoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
