% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevents_operations.R
\name{cloudwatchevents_put_targets}
\alias{cloudwatchevents_put_targets}
\title{Adds the specified targets to the specified rule, or updates the targets
if they are already associated with the rule}
\usage{
cloudwatchevents_put_targets(Rule, Targets)
}
\arguments{
\item{Rule}{[required] The name of the rule.}

\item{Targets}{[required] The targets to update or add to the rule.}
}
\description{
Adds the specified targets to the specified rule, or updates the targets
if they are already associated with the rule.
}
\details{
Targets are the resources that are invoked when a rule is triggered.

You can configure the following as targets for CloudWatch Events:
\itemize{
\item EC2 instances
\item SSM Run Command
\item SSM Automation
\item AWS Lambda functions
\item Data streams in Amazon Kinesis Data Streams
\item Data delivery streams in Amazon Kinesis Data Firehose
\item Amazon ECS tasks
\item AWS Step Functions state machines
\item AWS Batch jobs
\item AWS CodeBuild projects
\item Pipelines in AWS CodePipeline
\item Amazon Inspector assessment templates
\item Amazon SNS topics
\item Amazon SQS queues, including FIFO queues
\item The default event bus of another AWS account
}

Creating rules with built-in targets is supported only in the AWS
Management Console. The built-in targets are
\code{EC2 CreateSnapshot API call}, \code{EC2 RebootInstances API call},
\code{EC2 StopInstances API call}, and \code{EC2 TerminateInstances API call}.

For some target types, \code{PutTargets} provides target-specific parameters.
If the target is a Kinesis data stream, you can optionally specify which
shard the event goes to by using the \code{KinesisParameters} argument. To
invoke a command on multiple EC2 instances with one rule, you can use
the \code{RunCommandParameters} field.

To be able to make API calls against the resources that you own, Amazon
CloudWatch Events needs the appropriate permissions. For AWS Lambda and
Amazon SNS resources, CloudWatch Events relies on resource-based
policies. For EC2 instances, Kinesis data streams, and AWS Step
Functions state machines, CloudWatch Events relies on IAM roles that you
specify in the \code{RoleARN} argument in \code{PutTargets}. For more information,
see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/auth-and-access-control-cwe.html}{Authentication and Access Control}
in the \emph{Amazon CloudWatch Events User Guide}.

If another AWS account is in the same region and has granted you
permission (using \code{PutPermission}), you can send events to that account.
Set that account's event bus as a target of the rules in your account.
To send the matched events to the other account, specify that account's
event bus as the \code{Arn} value when you run \code{PutTargets}. If your account
sends events to another account, your account is charged for each sent
event. Each event sent to another account is charged as a custom event.
The account receiving the event is not charged. For more information,
see \href{https://aws.amazon.com/cloudwatch/pricing/}{Amazon CloudWatch Pricing}.

If you are setting the event bus of another account as the target, and
that account granted permission to your account through an organization
instead of directly by the account ID, then you must specify a \code{RoleArn}
with proper permissions in the \code{Target} structure. For more information,
see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/CloudWatchEvents-CrossAccountEventDelivery.html}{Sending and Receiving Events Between AWS Accounts}
in the \emph{Amazon CloudWatch Events User Guide}.

For more information about enabling cross-account events, see
PutPermission.

\strong{Input}, \strong{InputPath}, and \strong{InputTransformer} are mutually
exclusive and optional parameters of a target. When a rule is triggered
due to a matched event:
\itemize{
\item If none of the following arguments are specified for a target, then
the entire event is passed to the target in JSON format (unless the
target is Amazon EC2 Run Command or Amazon ECS task, in which case
nothing from the event is passed to the target).
\item If \strong{Input} is specified in the form of valid JSON, then the
matched event is overridden with this constant.
\item If \strong{InputPath} is specified in the form of JSONPath (for example,
\code{$.detail}), then only the part of the event specified in the path
is passed to the target (for example, only the detail part of the
event is passed).
\item If \strong{InputTransformer} is specified, then one or more specified
JSONPaths are extracted from the event and used as values in a
template that you specify as the input to the target.
}

When you specify \code{InputPath} or \code{InputTransformer}, you must use JSON
dot notation, not bracket notation.

When you add targets to a rule and the associated rule triggers soon
after, new or updated targets might not be immediately invoked. Allow a
short period of time for changes to take effect.

This action can partially fail if too many requests are made at the same
time. If that happens, \code{FailedEntryCount} is non-zero in the response
and each entry in \code{FailedEntries} provides the ID of the failed target
and the error code.
}
\section{Request syntax}{
\preformatted{svc$put_targets(
  Rule = "string",
  Targets = list(
    list(
      Id = "string",
      Arn = "string",
      RoleArn = "string",
      Input = "string",
      InputPath = "string",
      InputTransformer = list(
        InputPathsMap = list(
          "string"
        ),
        InputTemplate = "string"
      ),
      KinesisParameters = list(
        PartitionKeyPath = "string"
      ),
      RunCommandParameters = list(
        RunCommandTargets = list(
          list(
            Key = "string",
            Values = list(
              "string"
            )
          )
        )
      ),
      EcsParameters = list(
        TaskDefinitionArn = "string",
        TaskCount = 123,
        LaunchType = "EC2"|"FARGATE",
        NetworkConfiguration = list(
          awsvpcConfiguration = list(
            Subnets = list(
              "string"
            ),
            SecurityGroups = list(
              "string"
            ),
            AssignPublicIp = "ENABLED"|"DISABLED"
          )
        ),
        PlatformVersion = "string",
        Group = "string"
      ),
      BatchParameters = list(
        JobDefinition = "string",
        JobName = "string",
        ArrayProperties = list(
          Size = 123
        ),
        RetryStrategy = list(
          Attempts = 123
        )
      ),
      SqsParameters = list(
        MessageGroupId = "string"
      )
    )
  )
)
}
}

\keyword{internal}
