% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resourcegroups_operations.R
\name{resourcegroups_put_group_configuration}
\alias{resourcegroups_put_group_configuration}
\title{Attaches a service configuration to the specified group}
\usage{
resourcegroups_put_group_configuration(Group, Configuration)
}
\arguments{
\item{Group}{The name or ARN of the resource group with the configuration that you
want to update.}

\item{Configuration}{The new configuration to associate with the specified group. A
configuration associates the resource group with an AWS service and
specifies how the service can interact with the resources in the group.
A configuration is an array of GroupConfigurationItem elements.

For information about the syntax of a service configuration, see
\href{https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html}{Service configurations for resource groups}.

A resource group can contain either a \code{Configuration} or a
\code{ResourceQuery}, but not both.}
}
\value{
An empty list.
}
\description{
Attaches a service configuration to the specified group. This occurs
asynchronously, and can take time to complete. You can use
\code{\link[=resourcegroups_get_group_configuration]{get_group_configuration}} to
check the status of the update.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item \code{resource-groups:PutGroupConfiguration}
}
}
\section{Request syntax}{
\preformatted{svc$put_group_configuration(
  Group = "string",
  Configuration = list(
    list(
      Type = "string",
      Parameters = list(
        list(
          Name = "string",
          Values = list(
            "string"
          )
        )
      )
    )
  )
)
}
}

\keyword{internal}
