% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_start_change_request_execution}
\alias{ssm_start_change_request_execution}
\title{Creates a change request for Change Manager}
\usage{
ssm_start_change_request_execution(ScheduledTime, DocumentName,
  DocumentVersion, Parameters, ChangeRequestName, ClientToken, Runbooks,
  Tags)
}
\arguments{
\item{ScheduledTime}{The date and time specified in the change request to run the Automation
runbooks.

The Automation runbooks specified for the runbook workflow can't run
until all required approvals for the change request have been received.}

\item{DocumentName}{[required] The name of the change template document to run during the runbook
workflow.}

\item{DocumentVersion}{The version of the change template document to run during the runbook
workflow.}

\item{Parameters}{A key-value map of parameters that match the declared parameters in the
change template document.}

\item{ChangeRequestName}{The name of the change request associated with the runbook workflow to
be run.}

\item{ClientToken}{The user-provided idempotency token. The token must be unique, is case
insensitive, enforces the UUID format, and can't be reused.}

\item{Runbooks}{[required] Information about the Automation runbooks (Automation documents) that
are run during the runbook workflow.

The Automation runbooks specified for the runbook workflow can't run
until all required approvals for the change request have been received.}

\item{Tags}{Optional metadata that you assign to a resource. You can specify a
maximum of five tags for a change request. Tags enable you to categorize
a resource in different ways, such as by purpose, owner, or environment.
For example, you might want to tag a change request to identify an
environment or target AWS Region. In this case, you could specify the
following key-value pairs:
\itemize{
\item \verb{Key=Environment,Value=Production}
\item \verb{Key=Region,Value=us-east-2}
}}
}
\value{
A list with the following syntax:\preformatted{list(
  AutomationExecutionId = "string"
)
}
}
\description{
Creates a change request for Change Manager. The runbooks (Automation
documents) specified in the change request run only after all required
approvals for the change request have been received.
}
\section{Request syntax}{
\preformatted{svc$start_change_request_execution(
  ScheduledTime = as.POSIXct(
    "2015-01-01"
  ),
  DocumentName = "string",
  DocumentVersion = "string",
  Parameters = list(
    list(
      "string"
    )
  ),
  ChangeRequestName = "string",
  ClientToken = "string",
  Runbooks = list(
    list(
      DocumentName = "string",
      DocumentVersion = "string",
      Parameters = list(
        list(
          "string"
        )
      ),
      TargetParameterName = "string",
      Targets = list(
        list(
          Key = "string",
          Values = list(
            "string"
          )
        )
      ),
      MaxConcurrency = "string",
      MaxErrors = "string",
      TargetLocations = list(
        list(
          Accounts = list(
            "string"
          ),
          Regions = list(
            "string"
          ),
          TargetLocationMaxConcurrency = "string",
          TargetLocationMaxErrors = "string",
          ExecutionRoleName = "string"
        )
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
