% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_describe_tags}
\alias{autoscaling_describe_tags}
\title{Describes the specified tags}
\usage{
autoscaling_describe_tags(Filters, NextToken, MaxRecords)
}
\arguments{
\item{Filters}{One or more filters to scope the tags to return. The maximum number of
filters per filter type (for example, \code{auto-scaling-group}) is 1000.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{MaxRecords}{The maximum number of items to return with this call. The default value
is \code{50} and the maximum value is \code{100}.}
}
\description{
Describes the specified tags.
}
\details{
You can use filters to limit the results. For example, you can query for
the tags for a specific Auto Scaling group. You can specify multiple
values for a filter. A tag must match at least one of the specified
values for it to be included in the results.

You can also specify multiple filters. The result includes information
for a particular tag only if it matches all the filters. If there\'s no
match, no special message is returned.
}
\section{Request syntax}{
\preformatted{svc$describe_tags(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxRecords = 123
)
}
}

\examples{
# This example describes the tags for the specified Auto Scaling group.
\donttest{svc$describe_tags(
  Filters = list(
    list(
      Name = "auto-scaling-group",
      Values = list(
        "my-auto-scaling-group"
      )
    )
  )
)}

}
\keyword{internal}
