% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_stacks}
\alias{opsworks_describe_stacks}
\title{Requests a description of one or more stacks}
\usage{
opsworks_describe_stacks(StackIds)
}
\arguments{
\item{StackIds}{An array of stack IDs that specify the stacks to be described. If you
omit this parameter, \code{DescribeStacks} returns a description of every
stack.}
}
\description{
Requests a description of one or more stacks.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$describe_stacks(
  StackIds = list(
    "string"
  )
)
}
}

\keyword{internal}
