% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_update_provisioned_product_properties}
\alias{servicecatalog_update_provisioned_product_properties}
\title{Requests updates to the properties of the specified provisioned product}
\usage{
servicecatalog_update_provisioned_product_properties(AcceptLanguage,
  ProvisionedProductId, ProvisionedProductProperties, IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProvisionedProductId}{[required] The identifier of the provisioned product.}

\item{ProvisionedProductProperties}{[required] A map that contains the provisioned product properties to be updated.

The \code{OWNER} key only accepts user ARNs. The owner is the user that is
allowed to see, update, terminate, and execute service actions in the
provisioned product.

The administrator can change the owner of a provisioned product to
another IAM user within the same account. Both end user owners and
administrators can see ownership history of the provisioned product
using the \code{ListRecordHistory} API. The new owner can describe all past
records for the provisioned product using the \code{DescribeRecord} API. The
previous owner can no longer use \code{DescribeRecord}, but can still see the
product\'s history from when he was an owner using \code{ListRecordHistory}.

If a provisioned product ownership is assigned to an end user, they can
see and perform any action through the API or Service Catalog console
such as update, terminate, and execute service actions. If an end user
provisions a product and the owner is updated to someone else, they will
no longer be able to see or perform any actions through API or the
Service Catalog console on that provisioned product.}

\item{IdempotencyToken}{[required] The idempotency token that uniquely identifies the provisioning product
update request.}
}
\description{
Requests updates to the properties of the specified provisioned product.
}
\section{Request syntax}{
\preformatted{svc$update_provisioned_product_properties(
  AcceptLanguage = "string",
  ProvisionedProductId = "string",
  ProvisionedProductProperties = list(
    "string"
  ),
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
