% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_maintenance_window_execution_task_invocations}
\alias{ssm_describe_maintenance_window_execution_task_invocations}
\title{Retrieves the individual task executions (one per target) for a
particular task run as part of a maintenance window execution}
\usage{
ssm_describe_maintenance_window_execution_task_invocations(
  WindowExecutionId, TaskId, Filters, MaxResults, NextToken)
}
\arguments{
\item{WindowExecutionId}{[required] The ID of the maintenance window execution the task is part of.}

\item{TaskId}{[required] The ID of the specific task in the maintenance window task that should
be retrieved.}

\item{Filters}{Optional filters used to scope down the returned task invocations. The
supported filter key is STATUS with the corresponding values PENDING,
IN\\_PROGRESS, SUCCESS, FAILED, TIMED\\_OUT, CANCELLING, and CANCELLED.}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}
}
\description{
Retrieves the individual task executions (one per target) for a
particular task run as part of a maintenance window execution.
}
\section{Request syntax}{
\preformatted{svc$describe_maintenance_window_execution_task_invocations(
  WindowExecutionId = "string",
  TaskId = "string",
  Filters = list(
    list(
      Key = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
