% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_describe_policy}
\alias{organizations_describe_policy}
\title{Retrieves information about a policy}
\usage{
organizations_describe_policy(PolicyId)
}
\arguments{
\item{PolicyId}{[required] The unique identifier (ID) of the policy that you want details about.
You can get the ID from the ListPolicies or ListPoliciesForTarget
operations.

The \href{http://wikipedia.org/wiki/regex}{regex pattern} for a policy ID
string requires \"p-\" followed by from 8 to 128 lowercase letters or
digits.}
}
\description{
Retrieves information about a policy.
}
\details{
This operation can be called only from the organization\'s master
account.
}
\section{Request syntax}{
\preformatted{svc$describe_policy(
  PolicyId = "string"
)
}
}

\examples{
# The following example shows how to request information about a
# policy:/n/n
\dontrun{svc$describe_policy(
  PolicyId = "p-examplepolicyid111"
)}

}
\keyword{internal}
