% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_services}
\alias{support_describe_services}
\title{Returns the current list of AWS services and a list of service
categories that applies to each one}
\usage{
support_describe_services(serviceCodeList, language)
}
\arguments{
\item{serviceCodeList}{A JSON-formatted list of service codes available for AWS services.}

\item{language}{The ISO 639-1 code for the language in which AWS provides support. AWS
Support currently supports English (\"en\") and Japanese (\"ja\").
Language parameters must be passed explicitly for operations that take
them.}
}
\description{
Returns the current list of AWS services and a list of service
categories that applies to each one. You then use service names and
categories in your CreateCase requests. Each AWS service has its own set
of categories.
}
\details{
The service codes and category codes correspond to the values that are
displayed in the \strong{Service} and \strong{Category} drop-down lists on the AWS
Support Center \href{https://console.aws.amazon.com/support/home#/case/create}{Create Case} page.
The values in those fields, however, do not necessarily match the
service codes and categories returned by the \code{DescribeServices} request.
Always use the service codes and categories obtained programmatically.
This practice ensures that you always have the most recent set of
service and category codes.
}
\section{Request syntax}{
\preformatted{svc$describe_services(
  serviceCodeList = list(
    "string"
  ),
  language = "string"
)
}
}

\keyword{internal}
