% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_change_set}
\alias{cloudformation_describe_change_set}
\title{Returns the inputs for the change set and a list of changes that
CloudFormation will make if you execute the change set}
\usage{
cloudformation_describe_change_set(
  ChangeSetName,
  StackName = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ChangeSetName}{[required] The name or Amazon Resource Name (ARN) of the change set that you want
to describe.}

\item{StackName}{If you specified the name of a change set, specify the stack name or ID
(ARN) of the change set you want to describe.}

\item{NextToken}{A string (provided by the
\code{\link[=cloudformation_describe_change_set]{describe_change_set}} response
output) that identifies the next page of information that you want to
retrieve.}
}
\description{
Returns the inputs for the change set and a list of changes that CloudFormation will make if you execute the change set. For more information, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-changesets.html}{Updating Stacks Using Change Sets} in the CloudFormation User Guide.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_describe_change_set/} for full documentation.
}
\keyword{internal}
