% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_delivery_destination}
\alias{cloudwatchlogs_put_delivery_destination}
\title{Creates or updates a logical delivery destination}
\usage{
cloudwatchlogs_put_delivery_destination(
  name,
  outputFormat = NULL,
  deliveryDestinationConfiguration,
  tags = NULL
)
}
\arguments{
\item{name}{[required] A name for this delivery destination. This name must be unique for all
delivery destinations in your account.}

\item{outputFormat}{The format for the logs that this delivery destination will receive.}

\item{deliveryDestinationConfiguration}{[required] A structure that contains the ARN of the Amazon Web Services resource
that will receive the logs.}

\item{tags}{An optional list of key-value pairs to associate with the resource.

For more information about tagging, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}}
}
\description{
Creates or updates a logical \emph{delivery destination}. A delivery destination is an Amazon Web Services resource that represents an Amazon Web Services service that logs can be sent to. CloudWatch Logs, Amazon S3, and Firehose are supported as logs delivery destinations.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_delivery_destination/} for full documentation.
}
\keyword{internal}
