% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_ecs_clusters}
\alias{opsworks_describe_ecs_clusters}
\title{Describes Amazon ECS clusters that are registered with a stack}
\usage{
opsworks_describe_ecs_clusters(
  EcsClusterArns = NULL,
  StackId = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{EcsClusterArns}{A list of ARNs, one for each cluster to be described.}

\item{StackId}{A stack ID. \code{\link[=opsworks_describe_ecs_clusters]{describe_ecs_clusters}}
returns a description of the cluster that is registered with the stack.}

\item{NextToken}{If the previous paginated request did not return all of the remaining
results, the response object's\code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call
\code{\link[=opsworks_describe_ecs_clusters]{describe_ecs_clusters}} again and
assign that token to the request object's \code{NextToken} parameter. If
there are no remaining results, the previous response object's
\code{NextToken} parameter is set to \code{null}.}

\item{MaxResults}{To receive a paginated response, use this parameter to specify the
maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}
}
\description{
Describes Amazon ECS clusters that are registered with a stack. If you specify only a stack ID, you can use the \code{MaxResults} and \code{NextToken} parameters to paginate the response. However, OpsWorks Stacks currently supports only one cluster per layer, so the result set has a maximum of one element.

See \url{https://www.paws-r-sdk.com/docs/opsworks_describe_ecs_clusters/} for full documentation.
}
\keyword{internal}
