# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53_service.R
NULL

#' Activates a key signing key (KSK) so that it can be used for signing by
#' DNSSEC
#'
#' @description
#' Activates a key signing key (KSK) so that it can be used for signing by
#' DNSSEC. This operation changes the KSK status to `ACTIVE`.
#'
#' @usage
#' route53_activate_key_signing_key(HostedZoneId, Name)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; An alphanumeric string used to identify a key signing key (KSK).
#'
#' @section Request syntax:
#' ```
#' svc$activate_key_signing_key(
#'   HostedZoneId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_activate_key_signing_key
route53_activate_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "ActivateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/activate",
    paginator = list()
  )
  input <- .route53$activate_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$activate_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$activate_key_signing_key <- route53_activate_key_signing_key

#' Associates an Amazon VPC with a private hosted zone
#'
#' @description
#' Associates an Amazon VPC with a private hosted zone.
#' 
#' To perform the association, the VPC and the private hosted zone must
#' already exist. You can't convert a public hosted zone into a private
#' hosted zone.
#' 
#' If you want to associate a VPC that was created by using one AWS account
#' with a private hosted zone that was created by using a different
#' account, the AWS account that created the private hosted zone must first
#' submit a `CreateVPCAssociationAuthorization` request. Then the account
#' that created the VPC must submit an `AssociateVPCWithHostedZone`
#' request.
#'
#' @usage
#' route53_associate_vpc_with_hosted_zone(HostedZoneId, VPC, Comment)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to associate an Amazon
#' VPC with.
#' 
#' Note that you can't associate a VPC with a hosted zone that doesn't have
#' an existing VPC association.
#' @param VPC &#91;required&#93; A complex type that contains information about the VPC that you want to
#' associate with a private hosted zone.
#' @param Comment *Optional:* A comment about the association request.
#'
#' @section Request syntax:
#' ```
#' svc$associate_vpc_with_hosted_zone(
#'   HostedZoneId = "string",
#'   VPC = list(
#'     VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'     VPCId = "string"
#'   ),
#'   Comment = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example associates the VPC with ID vpc-1a2b3c4d with the
#' # hosted zone with ID Z3M3LMPEXAMPLE.
#' svc$associate_vpc_with_hosted_zone(
#'   Comment = "",
#'   HostedZoneId = "Z3M3LMPEXAMPLE",
#'   VPC = list(
#'     VPCId = "vpc-1a2b3c4d",
#'     VPCRegion = "us-east-2"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname route53_associate_vpc_with_hosted_zone
route53_associate_vpc_with_hosted_zone <- function(HostedZoneId, VPC, Comment = NULL) {
  op <- new_operation(
    name = "AssociateVPCWithHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/associatevpc",
    paginator = list()
  )
  input <- .route53$associate_vpc_with_hosted_zone_input(HostedZoneId = HostedZoneId, VPC = VPC, Comment = Comment)
  output <- .route53$associate_vpc_with_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$associate_vpc_with_hosted_zone <- route53_associate_vpc_with_hosted_zone

#' Creates, changes, or deletes a resource record set, which contains
#' authoritative DNS information for a specified domain name or subdomain
#' name
#'
#' @description
#' Creates, changes, or deletes a resource record set, which contains
#' authoritative DNS information for a specified domain name or subdomain
#' name. For example, you can use `ChangeResourceRecordSets` to create a
#' resource record set that routes traffic for test.example.com to a web
#' server that has an IP address of 192.0.2.44.
#' 
#' **Deleting Resource Record Sets**
#' 
#' To delete a resource record set, you must specify all the same values
#' that you specified when you created it.
#' 
#' **Change Batches and Transactional Changes**
#' 
#' The request body must include a document with a
#' `ChangeResourceRecordSetsRequest` element. The request body contains a
#' list of change items, known as a change batch. Change batches are
#' considered transactional changes. Route 53 validates the changes in the
#' request and then either makes all or none of the changes in the change
#' batch request. This ensures that DNS routing isn't adversely affected by
#' partial changes to the resource record sets in a hosted zone.
#' 
#' For example, suppose a change batch request contains two changes: it
#' deletes the `CNAME` resource record set for www.example.com and creates
#' an alias resource record set for www.example.com. If validation for both
#' records succeeds, Route 53 deletes the first resource record set and
#' creates the second resource record set in a single operation. If
#' validation for either the `DELETE` or the `CREATE` action fails, then
#' the request is canceled, and the original `CNAME` record continues to
#' exist.
#' 
#' If you try to delete the same resource record set more than once in a
#' single change batch, Route 53 returns an `InvalidChangeBatch` error.
#' 
#' **Traffic Flow**
#' 
#' To create resource record sets for complex routing configurations, use
#' either the traffic flow visual editor in the Route 53 console or the API
#' actions for traffic policies and traffic policy instances. Save the
#' configuration as a traffic policy, then associate the traffic policy
#' with one or more domain names (such as example.com) or subdomain names
#' (such as www.example.com), in the same hosted zone or in multiple hosted
#' zones. You can roll back the updates if the new configuration isn't
#' performing as expected. For more information, see [Using Traffic Flow to
#' Route DNS
#' Traffic](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-flow.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' **Create, Delete, and Upsert**
#' 
#' Use `ChangeResourceRecordsSetsRequest` to perform the following actions:
#' 
#' -   `CREATE`: Creates a resource record set that has the specified
#'     values.
#' 
#' -   `DELETE`: Deletes an existing resource record set that has the
#'     specified values.
#' 
#' -   `UPSERT`: If a resource record set does not already exist, AWS
#'     creates it. If a resource set does exist, Route 53 updates it with
#'     the values in the request.
#' 
#' **Syntaxes for Creating, Updating, and Deleting Resource Record Sets**
#' 
#' The syntax for a request depends on the type of resource record set that
#' you want to create, delete, or update, such as weighted, alias, or
#' failover. The XML elements in your request must appear in the order
#' listed in the syntax.
#' 
#' For an example for each type of resource record set, see "Examples."
#' 
#' Don't refer to the syntax in the "Parameter Syntax" section, which
#' includes all of the elements for every kind of resource record set that
#' you can create, delete, or update by using `ChangeResourceRecordSets`.
#' 
#' **Change Propagation to Route 53 DNS Servers**
#' 
#' When you submit a `ChangeResourceRecordSets` request, Route 53
#' propagates your changes to all of the Route 53 authoritative DNS
#' servers. While your changes are propagating, `GetChange` returns a
#' status of `PENDING`. When propagation is complete, `GetChange` returns a
#' status of `INSYNC`. Changes generally propagate to all Route 53 name
#' servers within 60 seconds. For more information, see
#' [GetChange](https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html).
#' 
#' **Limits on ChangeResourceRecordSets Requests**
#' 
#' For information about the limits on a `ChangeResourceRecordSets`
#' request, see
#' [Limits](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
#' in the *Amazon Route 53 Developer Guide*.
#'
#' @usage
#' route53_change_resource_record_sets(HostedZoneId, ChangeBatch)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that contains the resource record sets that
#' you want to change.
#' @param ChangeBatch &#91;required&#93; A complex type that contains an optional comment and the `Changes`
#' element.
#'
#' @section Request syntax:
#' ```
#' svc$change_resource_record_sets(
#'   HostedZoneId = "string",
#'   ChangeBatch = list(
#'     Comment = "string",
#'     Changes = list(
#'       list(
#'         Action = "CREATE"|"DELETE"|"UPSERT",
#'         ResourceRecordSet = list(
#'           Name = "string",
#'           Type = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'           SetIdentifier = "string",
#'           Weight = 123,
#'           Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-north-1"|"cn-northwest-1"|"ap-east-1"|"me-south-1"|"ap-south-1"|"af-south-1"|"eu-south-1",
#'           GeoLocation = list(
#'             ContinentCode = "string",
#'             CountryCode = "string",
#'             SubdivisionCode = "string"
#'           ),
#'           Failover = "PRIMARY"|"SECONDARY",
#'           MultiValueAnswer = TRUE|FALSE,
#'           TTL = 123,
#'           ResourceRecords = list(
#'             list(
#'               Value = "string"
#'             )
#'           ),
#'           AliasTarget = list(
#'             HostedZoneId = "string",
#'             DNSName = "string",
#'             EvaluateTargetHealth = TRUE|FALSE
#'           ),
#'           HealthCheckId = "string",
#'           TrafficPolicyInstanceId = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates a resource record set that routes Internet
#' # traffic to a resource with an IP address of 192.0.2.44.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.44"
#'             )
#'           ),
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "Web server for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates two weighted resource record sets. The
#' # resource with a Weight of 100 will get 1/3rd of traffic (100/100+200),
#' # and the other resource will get the rest of the traffic for example.com.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           HealthCheckId = "abcdef11-2222-3333-4444-555555fedcba",
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.44"
#'             )
#'           ),
#'           SetIdentifier = "Seattle data center",
#'           TTL = 60L,
#'           Type = "A",
#'           Weight = 100L
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           HealthCheckId = "abcdef66-7777-8888-9999-000000fedcba",
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.45"
#'             )
#'           ),
#'           SetIdentifier = "Portland data center",
#'           TTL = 60L,
#'           Type = "A",
#'           Weight = 200L
#'         )
#'       )
#'     ),
#'     Comment = "Web servers for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates an alias resource record set that routes
#' # traffic to a CloudFront distribution.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "d123rk29d0stfj.cloudfront.net",
#'             EvaluateTargetHealth = FALSE,
#'             HostedZoneId = "Z2FDTNDATAQYW2"
#'           ),
#'           Name = "example.com",
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "CloudFront distribution for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates two weighted alias resource record sets
#' # that route traffic to ELB load balancers. The resource with a Weight of
#' # 100 will get 1/3rd of traffic (100/100+200), and the other resource will
#' # get the rest of the traffic for example.com.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-123456789.us-east-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z3AADJGX6KTTL2"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "Ohio region",
#'           Type = "A",
#'           Weight = 100L
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-987654321.us-west-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z1H1FL5HABSF5"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "Oregon region",
#'           Type = "A",
#'           Weight = 200L
#'         )
#'       )
#'     ),
#'     Comment = "ELB load balancers for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates two latency resource record sets that
#' # route traffic to EC2 instances. Traffic for example.com is routed either
#' # to the Ohio region or the Oregon region, depending on the latency
#' # between the user and those regions.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           HealthCheckId = "abcdef11-2222-3333-4444-555555fedcba",
#'           Name = "example.com",
#'           Region = "us-east-2",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.44"
#'             )
#'           ),
#'           SetIdentifier = "Ohio region",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           HealthCheckId = "abcdef66-7777-8888-9999-000000fedcba",
#'           Name = "example.com",
#'           Region = "us-west-2",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.45"
#'             )
#'           ),
#'           SetIdentifier = "Oregon region",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "EC2 instances for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates two latency alias resource record sets
#' # that route traffic for example.com to ELB load balancers. Requests are
#' # routed either to the Ohio region or the Oregon region, depending on the
#' # latency between the user and those regions.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-123456789.us-east-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z3AADJGX6KTTL2"
#'           ),
#'           Name = "example.com",
#'           Region = "us-east-2",
#'           SetIdentifier = "Ohio region",
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-987654321.us-west-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z1H1FL5HABSF5"
#'           ),
#'           Name = "example.com",
#'           Region = "us-west-2",
#'           SetIdentifier = "Oregon region",
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "ELB load balancers for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates primary and secondary failover resource
#' # record sets that route traffic to EC2 instances. Traffic is generally
#' # routed to the primary resource, in the Ohio region. If that resource is
#' # unavailable, traffic is routed to the secondary resource, in the Oregon
#' # region.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           Failover = "PRIMARY",
#'           HealthCheckId = "abcdef11-2222-3333-4444-555555fedcba",
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.44"
#'             )
#'           ),
#'           SetIdentifier = "Ohio region",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           Failover = "SECONDARY",
#'           HealthCheckId = "abcdef66-7777-8888-9999-000000fedcba",
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.45"
#'             )
#'           ),
#'           SetIdentifier = "Oregon region",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "Failover configuration for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates primary and secondary failover alias
#' # resource record sets that route traffic to ELB load balancers. Traffic
#' # is generally routed to the primary resource, in the Ohio region. If that
#' # resource is unavailable, traffic is routed to the secondary resource, in
#' # the Oregon region.
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-123456789.us-east-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z3AADJGX6KTTL2"
#'           ),
#'           Failover = "PRIMARY",
#'           Name = "example.com",
#'           SetIdentifier = "Ohio region",
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-987654321.us-west-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z1H1FL5HABSF5"
#'           ),
#'           Failover = "SECONDARY",
#'           Name = "example.com",
#'           SetIdentifier = "Oregon region",
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "Failover alias configuration for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates four geolocation resource record sets that
#' # use IPv4 addresses to route traffic to resources such as web servers
#' # running on EC2 instances. Traffic is routed to one of four IP addresses,
#' # for North America (NA), for South America (SA), for Europe (EU), and for
#' # all other locations (*).
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           GeoLocation = list(
#'             ContinentCode = "NA"
#'           ),
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.44"
#'             )
#'           ),
#'           SetIdentifier = "North America",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           GeoLocation = list(
#'             ContinentCode = "SA"
#'           ),
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.45"
#'             )
#'           ),
#'           SetIdentifier = "South America",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           GeoLocation = list(
#'             ContinentCode = "EU"
#'           ),
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.46"
#'             )
#'           ),
#'           SetIdentifier = "Europe",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           GeoLocation = list(
#'             CountryCode = "*"
#'           ),
#'           Name = "example.com",
#'           ResourceRecords = list(
#'             list(
#'               Value = "192.0.2.47"
#'             )
#'           ),
#'           SetIdentifier = "Other locations",
#'           TTL = 60L,
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "Geolocation configuration for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' 
#' # The following example creates four geolocation alias resource record
#' # sets that route traffic to ELB load balancers. Traffic is routed to one
#' # of four IP addresses, for North America (NA), for South America (SA),
#' # for Europe (EU), and for all other locations (*).
#' svc$change_resource_record_sets(
#'   ChangeBatch = list(
#'     Changes = list(
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-123456789.us-east-2.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z3AADJGX6KTTL2"
#'           ),
#'           GeoLocation = list(
#'             ContinentCode = "NA"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "North America",
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-234567890.sa-east-1.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z2P70J7HTTTPLU"
#'           ),
#'           GeoLocation = list(
#'             ContinentCode = "SA"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "South America",
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-234567890.eu-central-1.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z215JYRZR1TBD5"
#'           ),
#'           GeoLocation = list(
#'             ContinentCode = "EU"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "Europe",
#'           Type = "A"
#'         )
#'       ),
#'       list(
#'         Action = "CREATE",
#'         ResourceRecordSet = list(
#'           AliasTarget = list(
#'             DNSName = "example-com-234567890.ap-southeast-1.elb.amazonaws.com ",
#'             EvaluateTargetHealth = TRUE,
#'             HostedZoneId = "Z1LMS91P8CMLE5"
#'           ),
#'           GeoLocation = list(
#'             CountryCode = "*"
#'           ),
#'           Name = "example.com",
#'           SetIdentifier = "Other locations",
#'           Type = "A"
#'         )
#'       )
#'     ),
#'     Comment = "Geolocation alias configuration for example.com"
#'   ),
#'   HostedZoneId = "Z3M3LMPEXAMPLE"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname route53_change_resource_record_sets
route53_change_resource_record_sets <- function(HostedZoneId, ChangeBatch) {
  op <- new_operation(
    name = "ChangeResourceRecordSets",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/rrset/",
    paginator = list()
  )
  input <- .route53$change_resource_record_sets_input(HostedZoneId = HostedZoneId, ChangeBatch = ChangeBatch)
  output <- .route53$change_resource_record_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$change_resource_record_sets <- route53_change_resource_record_sets

#' Adds, edits, or deletes tags for a health check or a hosted zone
#'
#' @description
#' Adds, edits, or deletes tags for a health check or a hosted zone.
#' 
#' For information about using tags for cost allocation, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @usage
#' route53_change_tags_for_resource(ResourceType, ResourceId, AddTags,
#'   RemoveTagKeys)
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceId &#91;required&#93; The ID of the resource for which you want to add, change, or delete
#' tags.
#' @param AddTags A complex type that contains a list of the tags that you want to add to
#' the specified health check or hosted zone and/or the tags that you want
#' to edit `Value` for.
#' 
#' You can add a maximum of 10 tags to a health check or a hosted zone.
#' @param RemoveTagKeys A complex type that contains a list of the tags that you want to delete
#' from the specified health check or hosted zone. You can specify up to 10
#' keys.
#'
#' @section Request syntax:
#' ```
#' svc$change_tags_for_resource(
#'   ResourceType = "healthcheck"|"hostedzone",
#'   ResourceId = "string",
#'   AddTags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   RemoveTagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example adds two tags and removes one tag from the hosted
#' # zone with ID Z3M3LMPEXAMPLE.
#' svc$change_tags_for_resource(
#'   AddTags = list(
#'     list(
#'       Key = "apex",
#'       Value = "3874"
#'     ),
#'     list(
#'       Key = "acme",
#'       Value = "4938"
#'     )
#'   ),
#'   RemoveTagKeys = list(
#'     "Nadir"
#'   ),
#'   ResourceId = "Z3M3LMPEXAMPLE",
#'   ResourceType = "hostedzone"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname route53_change_tags_for_resource
route53_change_tags_for_resource <- function(ResourceType, ResourceId, AddTags = NULL, RemoveTagKeys = NULL) {
  op <- new_operation(
    name = "ChangeTagsForResource",
    http_method = "POST",
    http_path = "/2013-04-01/tags/{ResourceType}/{ResourceId}",
    paginator = list()
  )
  input <- .route53$change_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, AddTags = AddTags, RemoveTagKeys = RemoveTagKeys)
  output <- .route53$change_tags_for_resource_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$change_tags_for_resource <- route53_change_tags_for_resource

#' Creates a new health check
#'
#' @description
#' Creates a new health check.
#' 
#' For information about adding health checks to resource record sets, see
#' [HealthCheckId](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ResourceRecordSet.html#Route53-Type-ResourceRecordSet-HealthCheckId)
#' in
#' [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html).
#' 
#' **ELB Load Balancers**
#' 
#' If you're registering EC2 instances with an Elastic Load Balancing (ELB)
#' load balancer, do not create Amazon Route 53 health checks for the EC2
#' instances. When you register an EC2 instance with a load balancer, you
#' configure settings for an ELB health check, which performs a similar
#' function to a Route 53 health check.
#' 
#' **Private Hosted Zones**
#' 
#' You can associate health checks with failover resource record sets in a
#' private hosted zone. Note the following:
#' 
#' -   Route 53 health checkers are outside the VPC. To check the health of
#'     an endpoint within a VPC by IP address, you must assign a public IP
#'     address to the instance in the VPC.
#' 
#' -   You can configure a health checker to check the health of an
#'     external resource that the instance relies on, such as a database
#'     server.
#' 
#' -   You can create a CloudWatch metric, associate an alarm with the
#'     metric, and then create a health check that is based on the state of
#'     the alarm. For example, you might create a CloudWatch metric that
#'     checks the status of the Amazon EC2 `StatusCheckFailed` metric, add
#'     an alarm to the metric, and then create a health check that is based
#'     on the state of the alarm. For information about creating CloudWatch
#'     metrics and alarms by using the CloudWatch console, see the [Amazon
#'     CloudWatch User
#'     Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).
#'
#' @usage
#' route53_create_health_check(CallerReference, HealthCheckConfig)
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request and that allows you to retry
#' a failed `CreateHealthCheck` request without the risk of creating two
#' identical health checks:
#' 
#' -   If you send a `CreateHealthCheck` request with the same
#'     `CallerReference` and settings as a previous request, and if the
#'     health check doesn't exist, Amazon Route 53 creates the health
#'     check. If the health check does exist, Route 53 returns the settings
#'     for the existing health check.
#' 
#' -   If you send a `CreateHealthCheck` request with the same
#'     `CallerReference` as a deleted health check, regardless of the
#'     settings, Route 53 returns a `HealthCheckAlreadyExists` error.
#' 
#' -   If you send a `CreateHealthCheck` request with the same
#'     `CallerReference` as an existing health check but with different
#'     settings, Route 53 returns a `HealthCheckAlreadyExists` error.
#' 
#' -   If you send a `CreateHealthCheck` request with a unique
#'     `CallerReference` but settings identical to an existing health
#'     check, Route 53 creates the health check.
#' @param HealthCheckConfig &#91;required&#93; A complex type that contains settings for a new health check.
#'
#' @section Request syntax:
#' ```
#' svc$create_health_check(
#'   CallerReference = "string",
#'   HealthCheckConfig = list(
#'     IPAddress = "string",
#'     Port = 123,
#'     Type = "HTTP"|"HTTPS"|"HTTP_STR_MATCH"|"HTTPS_STR_MATCH"|"TCP"|"CALCULATED"|"CLOUDWATCH_METRIC",
#'     ResourcePath = "string",
#'     FullyQualifiedDomainName = "string",
#'     SearchString = "string",
#'     RequestInterval = 123,
#'     FailureThreshold = 123,
#'     MeasureLatency = TRUE|FALSE,
#'     Inverted = TRUE|FALSE,
#'     Disabled = TRUE|FALSE,
#'     HealthThreshold = 123,
#'     ChildHealthChecks = list(
#'       "string"
#'     ),
#'     EnableSNI = TRUE|FALSE,
#'     Regions = list(
#'       "us-east-1"|"us-west-1"|"us-west-2"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"
#'     ),
#'     AlarmIdentifier = list(
#'       Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"ap-east-1"|"me-south-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-northwest-1"|"cn-north-1"|"af-south-1"|"eu-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1",
#'       Name = "string"
#'     ),
#'     InsufficientDataHealthStatus = "Healthy"|"Unhealthy"|"LastKnownStatus"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_health_check
route53_create_health_check <- function(CallerReference, HealthCheckConfig) {
  op <- new_operation(
    name = "CreateHealthCheck",
    http_method = "POST",
    http_path = "/2013-04-01/healthcheck",
    paginator = list()
  )
  input <- .route53$create_health_check_input(CallerReference = CallerReference, HealthCheckConfig = HealthCheckConfig)
  output <- .route53$create_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_health_check <- route53_create_health_check

#' Creates a new public or private hosted zone
#'
#' @description
#' Creates a new public or private hosted zone. You create records in a
#' public hosted zone to define how you want to route traffic on the
#' internet for a domain, such as example.com, and its subdomains
#' (apex.example.com, acme.example.com). You create records in a private
#' hosted zone to define how you want to route traffic for a domain and its
#' subdomains within one or more Amazon Virtual Private Clouds (Amazon
#' VPCs).
#' 
#' You can't convert a public hosted zone to a private hosted zone or vice
#' versa. Instead, you must create a new hosted zone with the same name and
#' create new resource record sets.
#' 
#' For more information about charges for hosted zones, see [Amazon Route
#' 53 Pricing](https://aws.amazon.com/route53/pricing/).
#' 
#' Note the following:
#' 
#' -   You can't create a hosted zone for a top-level domain (TLD) such as
#'     .com.
#' 
#' -   For public hosted zones, Route 53 automatically creates a default
#'     SOA record and four NS records for the zone. For more information
#'     about SOA and NS records, see [NS and SOA Records that Route 53
#'     Creates for a Hosted
#'     Zone](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html)
#'     in the *Amazon Route 53 Developer Guide*.
#' 
#'     If you want to use the same name servers for multiple public hosted
#'     zones, you can optionally associate a reusable delegation set with
#'     the hosted zone. See the `DelegationSetId` element.
#' 
#' -   If your domain is registered with a registrar other than Route 53,
#'     you must update the name servers with your registrar to make Route
#'     53 the DNS service for the domain. For more information, see
#'     [Migrating DNS Service for an Existing Domain to Amazon Route
#'     53](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/MigratingDNS.html)
#'     in the *Amazon Route 53 Developer Guide*.
#' 
#' When you submit a `CreateHostedZone` request, the initial status of the
#' hosted zone is `PENDING`. For public hosted zones, this means that the
#' NS and SOA records are not yet available on all Route 53 DNS servers.
#' When the NS and SOA records are available, the status of the zone
#' changes to `INSYNC`.
#'
#' @usage
#' route53_create_hosted_zone(Name, VPC, CallerReference, HostedZoneConfig,
#'   DelegationSetId)
#'
#' @param Name &#91;required&#93; The name of the domain. Specify a fully qualified domain name, for
#' example, *www.example.com*. The trailing dot is optional; Amazon Route
#' 53 assumes that the domain name is fully qualified. This means that
#' Route 53 treats *www.example.com* (without a trailing dot) and
#' *www.example.com.* (with a trailing dot) as identical.
#' 
#' If you're creating a public hosted zone, this is the name you have
#' registered with your DNS registrar. If your domain name is registered
#' with a registrar other than Route 53, change the name servers for your
#' domain to the set of `NameServers` that `CreateHostedZone` returns in
#' `DelegationSet`.
#' @param VPC (Private hosted zones only) A complex type that contains information
#' about the Amazon VPC that you're associating with this hosted zone.
#' 
#' You can specify only one Amazon VPC when you create a private hosted
#' zone. To associate additional Amazon VPCs with the hosted zone, use
#' [AssociateVPCWithHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html)
#' after you create a hosted zone.
#' @param CallerReference &#91;required&#93; A unique string that identifies the request and that allows failed
#' `CreateHostedZone` requests to be retried without the risk of executing
#' the operation twice. You must use a unique `CallerReference` string
#' every time you submit a `CreateHostedZone` request. `CallerReference`
#' can be any unique string, for example, a date/time stamp.
#' @param HostedZoneConfig (Optional) A complex type that contains the following optional values:
#' 
#' -   For public and private hosted zones, an optional comment
#' 
#' -   For private hosted zones, an optional `PrivateZone` element
#' 
#' If you don't specify a comment or the `PrivateZone` element, omit
#' `HostedZoneConfig` and the other elements.
#' @param DelegationSetId If you want to associate a reusable delegation set with this hosted
#' zone, the ID that Amazon Route 53 assigned to the reusable delegation
#' set when you created it. For more information about reusable delegation
#' sets, see
#' [CreateReusableDelegationSet](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_hosted_zone(
#'   Name = "string",
#'   VPC = list(
#'     VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'     VPCId = "string"
#'   ),
#'   CallerReference = "string",
#'   HostedZoneConfig = list(
#'     Comment = "string",
#'     PrivateZone = TRUE|FALSE
#'   ),
#'   DelegationSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_hosted_zone
route53_create_hosted_zone <- function(Name, VPC = NULL, CallerReference, HostedZoneConfig = NULL, DelegationSetId = NULL) {
  op <- new_operation(
    name = "CreateHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone",
    paginator = list()
  )
  input <- .route53$create_hosted_zone_input(Name = Name, VPC = VPC, CallerReference = CallerReference, HostedZoneConfig = HostedZoneConfig, DelegationSetId = DelegationSetId)
  output <- .route53$create_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_hosted_zone <- route53_create_hosted_zone

#' Creates a new key signing key (KSK) associated with a hosted zone
#'
#' @description
#' Creates a new key signing key (KSK) associated with a hosted zone. You
#' can only have two KSKs per hosted zone.
#'
#' @usage
#' route53_create_key_signing_key(CallerReference, HostedZoneId,
#'   KeyManagementServiceArn, Name, Status)
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request.
#' @param HostedZoneId &#91;required&#93; The unique string (ID) used to identify a hosted zone.
#' @param KeyManagementServiceArn &#91;required&#93; The Amazon resource name (ARN) for a customer managed key (CMK) in AWS
#' Key Management Service (KMS). The `KeyManagementServiceArn` must be
#' unique for each key signing key (KSK) in a single hosted zone. To see an
#' example of `KeyManagementServiceArn` that grants the correct permissions
#' for DNSSEC, scroll down to **Example**.
#' 
#' You must configure the CMK as follows:
#' 
#' ### Status
#' 
#' Enabled
#' 
#' ### Key spec
#' 
#' ECC\\_NIST\\_P256
#' 
#' ### Key usage
#' 
#' Sign and verify
#' 
#' ### Key policy
#' 
#' The key policy must give permission for the following actions:
#' 
#' -   DescribeKey
#' 
#' -   GetPublicKey
#' 
#' -   Sign
#' 
#' The key policy must also include the Amazon Route 53 service in the
#' principal for your account. Specify the following:
#' 
#' -   `"Service": "api-service.dnssec.route53.aws.internal"`
#' 
#' For more information about working with CMK in KMS, see [AWS Key
#' Management Service
#' concepts](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html).
#' @param Name &#91;required&#93; An alphanumeric string used to identify a key signing key (KSK). `Name`
#' must be unique for each key signing key in the same hosted zone.
#' @param Status &#91;required&#93; A string specifying the initial status of the key signing key (KSK). You
#' can set the value to `ACTIVE` or `INACTIVE`.
#'
#' @section Request syntax:
#' ```
#' svc$create_key_signing_key(
#'   CallerReference = "string",
#'   HostedZoneId = "string",
#'   KeyManagementServiceArn = "string",
#'   Name = "string",
#'   Status = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_key_signing_key
route53_create_key_signing_key <- function(CallerReference, HostedZoneId, KeyManagementServiceArn, Name, Status) {
  op <- new_operation(
    name = "CreateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey",
    paginator = list()
  )
  input <- .route53$create_key_signing_key_input(CallerReference = CallerReference, HostedZoneId = HostedZoneId, KeyManagementServiceArn = KeyManagementServiceArn, Name = Name, Status = Status)
  output <- .route53$create_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_key_signing_key <- route53_create_key_signing_key

#' Creates a configuration for DNS query logging
#'
#' @description
#' Creates a configuration for DNS query logging. After you create a query
#' logging configuration, Amazon Route 53 begins to publish log data to an
#' Amazon CloudWatch Logs log group.
#' 
#' DNS query logs contain information about the queries that Route 53
#' receives for a specified public hosted zone, such as the following:
#' 
#' -   Route 53 edge location that responded to the DNS query
#' 
#' -   Domain or subdomain that was requested
#' 
#' -   DNS record type, such as A or AAAA
#' 
#' -   DNS response code, such as `NoError` or `ServFail`
#' 
#' ### Log Group and Resource Policy
#' 
#' Before you create a query logging configuration, perform the following
#' operations.
#' 
#' If you create a query logging configuration using the Route 53 console,
#' Route 53 performs these operations automatically.
#' 
#' 1.  Create a CloudWatch Logs log group, and make note of the ARN, which
#'     you specify when you create a query logging configuration. Note the
#'     following:
#' 
#'     -   You must create the log group in the us-east-1 region.
#' 
#'     -   You must use the same AWS account to create the log group and
#'         the hosted zone that you want to configure query logging for.
#' 
#'     -   When you create log groups for query logging, we recommend that
#'         you use a consistent prefix, for example:
#' 
#'         `/aws/route53/<i>hosted zone name</i> `
#' 
#'         In the next step, you'll create a resource policy, which
#'         controls access to one or more log groups and the associated AWS
#'         resources, such as Route 53 hosted zones. There's a limit on the
#'         number of resource policies that you can create, so we recommend
#'         that you use a consistent prefix so you can use the same
#'         resource policy for all the log groups that you create for query
#'         logging.
#' 
#' 2.  Create a CloudWatch Logs resource policy, and give it the
#'     permissions that Route 53 needs to create log streams and to send
#'     query logs to log streams. For the value of `Resource`, specify the
#'     ARN for the log group that you created in the previous step. To use
#'     the same resource policy for all the CloudWatch Logs log groups that
#'     you created for query logging configurations, replace the hosted
#'     zone name with `*`, for example:
#' 
#'     `arn:aws:logs:us-east-1:123412341234:log-group:/aws/route53/*`
#' 
#'     You can't use the CloudWatch console to create or edit a resource
#'     policy. You must use the CloudWatch API, one of the AWS SDKs, or the
#'     AWS CLI.
#' 
#' ### Log Streams and Edge Locations
#' 
#' When Route 53 finishes creating the configuration for DNS query logging,
#' it does the following:
#' 
#' -   Creates a log stream for an edge location the first time that the
#'     edge location responds to DNS queries for the specified hosted zone.
#'     That log stream is used to log all queries that Route 53 responds to
#'     for that edge location.
#' 
#' -   Begins to send query logs to the applicable log stream.
#' 
#' The name of each log stream is in the following format:
#' 
#' ` <i>hosted zone ID</i>/<i>edge location code</i> `
#' 
#' The edge location code is a three-letter code and an arbitrarily
#' assigned number, for example, DFW3. The three-letter code typically
#' corresponds with the International Air Transport Association airport
#' code for an airport near the edge location. (These abbreviations might
#' change in the future.) For a list of edge locations, see "The Route 53
#' Global Network" on the [Route 53 Product
#' Details](https://aws.amazon.com/route53/features/) page.
#' 
#' ### Queries That Are Logged
#' 
#' Query logs contain only the queries that DNS resolvers forward to Route
#' 53. If a DNS resolver has already cached the response to a query (such
#' as the IP address for a load balancer for example.com), the resolver
#' will continue to return the cached response. It doesn't forward another
#' query to Route 53 until the TTL for the corresponding resource record
#' set expires. Depending on how many DNS queries are submitted for a
#' resource record set, and depending on the TTL for that resource record
#' set, query logs might contain information about only one query out of
#' every several thousand queries that are submitted to DNS. For more
#' information about how DNS works, see [Routing Internet Traffic to Your
#' Website or Web
#' Application](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/welcome-dns-service.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' ### Log File Format
#' 
#' For a list of the values in each query log and the format of each value,
#' see [Logging DNS
#' Queries](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' ### Pricing
#' 
#' For information about charges for query logs, see [Amazon CloudWatch
#' Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' ### How to Stop Logging
#' 
#' If you want Route 53 to stop sending query logs to CloudWatch Logs,
#' delete the query logging configuration. For more information, see
#' [DeleteQueryLoggingConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html).
#'
#' @usage
#' route53_create_query_logging_config(HostedZoneId,
#'   CloudWatchLogsLogGroupArn)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to log queries for. You can log
#' queries only for public hosted zones.
#' @param CloudWatchLogsLogGroupArn &#91;required&#93; The Amazon Resource Name (ARN) for the log group that you want to Amazon
#' Route 53 to send query logs to. This is the format of the ARN:
#' 
#' arn:aws:logs:*region*:*account-id*:log-group:*log\\_group\\_name*
#' 
#' To get the ARN for a log group, you can use the CloudWatch console, the
#' [DescribeLogGroups](https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeLogGroups.html)
#' API action, the
#' [describe-log-groups](https://docs.aws.amazon.com/cli/latest/reference/logs/describe-log-groups.html)
#' command, or the applicable command in one of the AWS SDKs.
#'
#' @section Request syntax:
#' ```
#' svc$create_query_logging_config(
#'   HostedZoneId = "string",
#'   CloudWatchLogsLogGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_query_logging_config
route53_create_query_logging_config <- function(HostedZoneId, CloudWatchLogsLogGroupArn) {
  op <- new_operation(
    name = "CreateQueryLoggingConfig",
    http_method = "POST",
    http_path = "/2013-04-01/queryloggingconfig",
    paginator = list()
  )
  input <- .route53$create_query_logging_config_input(HostedZoneId = HostedZoneId, CloudWatchLogsLogGroupArn = CloudWatchLogsLogGroupArn)
  output <- .route53$create_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_query_logging_config <- route53_create_query_logging_config

#' Creates a delegation set (a group of four name servers) that can be
#' reused by multiple hosted zones that were created by the same AWS
#' account
#'
#' @description
#' Creates a delegation set (a group of four name servers) that can be
#' reused by multiple hosted zones that were created by the same AWS
#' account.
#' 
#' You can also create a reusable delegation set that uses the four name
#' servers that are associated with an existing hosted zone. Specify the
#' hosted zone ID in the `CreateReusableDelegationSet` request.
#' 
#' You can't associate a reusable delegation set with a private hosted
#' zone.
#' 
#' For information about using a reusable delegation set to configure white
#' label name servers, see [Configuring White Label Name
#' Servers](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/white-label-name-servers.html).
#' 
#' The process for migrating existing hosted zones to use a reusable
#' delegation set is comparable to the process for configuring white label
#' name servers. You need to perform the following steps:
#' 
#' 1.  Create a reusable delegation set.
#' 
#' 2.  Recreate hosted zones, and reduce the TTL to 60 seconds or less.
#' 
#' 3.  Recreate resource record sets in the new hosted zones.
#' 
#' 4.  Change the registrar's name servers to use the name servers for the
#'     new hosted zones.
#' 
#' 5.  Monitor traffic for the website or application.
#' 
#' 6.  Change TTLs back to their original values.
#' 
#' If you want to migrate existing hosted zones to use a reusable
#' delegation set, the existing hosted zones can't use any of the name
#' servers that are assigned to the reusable delegation set. If one or more
#' hosted zones do use one or more name servers that are assigned to the
#' reusable delegation set, you can do one of the following:
#' 
#' -   For small numbers of hosted zones—up to a few hundred—it's
#'     relatively easy to create reusable delegation sets until you get one
#'     that has four name servers that don't overlap with any of the name
#'     servers in your hosted zones.
#' 
#' -   For larger numbers of hosted zones, the easiest solution is to use
#'     more than one reusable delegation set.
#' 
#' -   For larger numbers of hosted zones, you can also migrate hosted
#'     zones that have overlapping name servers to hosted zones that don't
#'     have overlapping name servers, then migrate the hosted zones again
#'     to use the reusable delegation set.
#'
#' @usage
#' route53_create_reusable_delegation_set(CallerReference, HostedZoneId)
#'
#' @param CallerReference &#91;required&#93; A unique string that identifies the request, and that allows you to
#' retry failed `CreateReusableDelegationSet` requests without the risk of
#' executing the operation twice. You must use a unique `CallerReference`
#' string every time you submit a `CreateReusableDelegationSet` request.
#' `CallerReference` can be any unique string, for example a date/time
#' stamp.
#' @param HostedZoneId If you want to mark the delegation set for an existing hosted zone as
#' reusable, the ID for that hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$create_reusable_delegation_set(
#'   CallerReference = "string",
#'   HostedZoneId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_reusable_delegation_set
route53_create_reusable_delegation_set <- function(CallerReference, HostedZoneId = NULL) {
  op <- new_operation(
    name = "CreateReusableDelegationSet",
    http_method = "POST",
    http_path = "/2013-04-01/delegationset",
    paginator = list()
  )
  input <- .route53$create_reusable_delegation_set_input(CallerReference = CallerReference, HostedZoneId = HostedZoneId)
  output <- .route53$create_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_reusable_delegation_set <- route53_create_reusable_delegation_set

#' Creates a traffic policy, which you use to create multiple DNS resource
#' record sets for one domain name (such as example
#'
#' @description
#' Creates a traffic policy, which you use to create multiple DNS resource
#' record sets for one domain name (such as example.com) or one subdomain
#' name (such as www.example.com).
#'
#' @usage
#' route53_create_traffic_policy(Name, Document, Comment)
#'
#' @param Name &#91;required&#93; The name of the traffic policy.
#' @param Document &#91;required&#93; The definition of this traffic policy in JSON format. For more
#' information, see [Traffic Policy Document
#' Format](https://docs.aws.amazon.com/Route53/latest/APIReference/api-policies-traffic-policy-document-format.html).
#' @param Comment (Optional) Any comments that you want to include about the traffic
#' policy.
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_policy(
#'   Name = "string",
#'   Document = "string",
#'   Comment = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy
route53_create_traffic_policy <- function(Name, Document, Comment = NULL) {
  op <- new_operation(
    name = "CreateTrafficPolicy",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_input(Name = Name, Document = Document, Comment = Comment)
  output <- .route53$create_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy <- route53_create_traffic_policy

#' Creates resource record sets in a specified hosted zone based on the
#' settings in a specified traffic policy version
#'
#' @description
#' Creates resource record sets in a specified hosted zone based on the
#' settings in a specified traffic policy version. In addition,
#' `CreateTrafficPolicyInstance` associates the resource record sets with a
#' specified domain name (such as example.com) or subdomain name (such as
#' www.example.com). Amazon Route 53 responds to DNS queries for the domain
#' or subdomain name by using the resource record sets that
#' `CreateTrafficPolicyInstance` created.
#'
#' @usage
#' route53_create_traffic_policy_instance(HostedZoneId, Name, TTL,
#'   TrafficPolicyId, TrafficPolicyVersion)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want Amazon Route 53 to create
#' resource record sets in by using the configuration in a traffic policy.
#' @param Name &#91;required&#93; The domain name (such as example.com) or subdomain name (such as
#' www.example.com) for which Amazon Route 53 responds to DNS queries by
#' using the resource record sets that Route 53 creates for this traffic
#' policy instance.
#' @param TTL &#91;required&#93; (Optional) The TTL that you want Amazon Route 53 to assign to all of the
#' resource record sets that it creates in the specified hosted zone.
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy that you want to use to create resource
#' record sets in the specified hosted zone.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy that you want to use to create
#' resource record sets in the specified hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_policy_instance(
#'   HostedZoneId = "string",
#'   Name = "string",
#'   TTL = 123,
#'   TrafficPolicyId = "string",
#'   TrafficPolicyVersion = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy_instance
route53_create_traffic_policy_instance <- function(HostedZoneId, Name, TTL, TrafficPolicyId, TrafficPolicyVersion) {
  op <- new_operation(
    name = "CreateTrafficPolicyInstance",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicyinstance",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_instance_input(HostedZoneId = HostedZoneId, Name = Name, TTL = TTL, TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion)
  output <- .route53$create_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy_instance <- route53_create_traffic_policy_instance

#' Creates a new version of an existing traffic policy
#'
#' @description
#' Creates a new version of an existing traffic policy. When you create a
#' new version of a traffic policy, you specify the ID of the traffic
#' policy that you want to update and a JSON-formatted document that
#' describes the new version. You use traffic policies to create multiple
#' DNS resource record sets for one domain name (such as example.com) or
#' one subdomain name (such as www.example.com). You can create a maximum
#' of 1000 versions of a traffic policy. If you reach the limit and need to
#' create another version, you'll need to start a new traffic policy.
#'
#' @usage
#' route53_create_traffic_policy_version(Id, Document, Comment)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy for which you want to create a new version.
#' @param Document &#91;required&#93; The definition of this version of the traffic policy, in JSON format.
#' You specified the JSON in the `CreateTrafficPolicyVersion` request. For
#' more information about the JSON format, see
#' [CreateTrafficPolicy](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html).
#' @param Comment The comment that you specified in the `CreateTrafficPolicyVersion`
#' request, if any.
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_policy_version(
#'   Id = "string",
#'   Document = "string",
#'   Comment = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_traffic_policy_version
route53_create_traffic_policy_version <- function(Id, Document, Comment = NULL) {
  op <- new_operation(
    name = "CreateTrafficPolicyVersion",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy/{Id}",
    paginator = list()
  )
  input <- .route53$create_traffic_policy_version_input(Id = Id, Document = Document, Comment = Comment)
  output <- .route53$create_traffic_policy_version_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_traffic_policy_version <- route53_create_traffic_policy_version

#' Authorizes the AWS account that created a specified VPC to submit an
#' AssociateVPCWithHostedZone request to associate the VPC with a specified
#' hosted zone that was created by a different account
#'
#' @description
#' Authorizes the AWS account that created a specified VPC to submit an
#' `AssociateVPCWithHostedZone` request to associate the VPC with a
#' specified hosted zone that was created by a different account. To submit
#' a `CreateVPCAssociationAuthorization` request, you must use the account
#' that created the hosted zone. After you authorize the association, use
#' the account that created the VPC to submit an
#' `AssociateVPCWithHostedZone` request.
#' 
#' If you want to associate multiple VPCs that you created by using one
#' account with a hosted zone that you created by using a different
#' account, you must submit one authorization request for each VPC.
#'
#' @usage
#' route53_create_vpc_association_authorization(HostedZoneId, VPC)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to authorize associating
#' a VPC with.
#' @param VPC &#91;required&#93; A complex type that contains the VPC ID and region for the VPC that you
#' want to authorize associating with your hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_association_authorization(
#'   HostedZoneId = "string",
#'   VPC = list(
#'     VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'     VPCId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_create_vpc_association_authorization
route53_create_vpc_association_authorization <- function(HostedZoneId, VPC) {
  op <- new_operation(
    name = "CreateVPCAssociationAuthorization",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
    paginator = list()
  )
  input <- .route53$create_vpc_association_authorization_input(HostedZoneId = HostedZoneId, VPC = VPC)
  output <- .route53$create_vpc_association_authorization_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$create_vpc_association_authorization <- route53_create_vpc_association_authorization

#' Deactivates a key signing key (KSK) so that it will not be used for
#' signing by DNSSEC
#'
#' @description
#' Deactivates a key signing key (KSK) so that it will not be used for
#' signing by DNSSEC. This operation changes the KSK status to `INACTIVE`.
#'
#' @usage
#' route53_deactivate_key_signing_key(HostedZoneId, Name)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; An alphanumeric string used to identify a key signing key (KSK).
#'
#' @section Request syntax:
#' ```
#' svc$deactivate_key_signing_key(
#'   HostedZoneId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_deactivate_key_signing_key
route53_deactivate_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "DeactivateKeySigningKey",
    http_method = "POST",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}/deactivate",
    paginator = list()
  )
  input <- .route53$deactivate_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$deactivate_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$deactivate_key_signing_key <- route53_deactivate_key_signing_key

#' Deletes a health check
#'
#' @description
#' Deletes a health check.
#' 
#' Amazon Route 53 does not prevent you from deleting a health check even
#' if the health check is associated with one or more resource record sets.
#' If you delete a health check and you don't update the associated
#' resource record sets, the future status of the health check can't be
#' predicted and may change. This will affect the routing of DNS queries
#' for your DNS failover configuration. For more information, see
#' [Replacing and Deleting Health
#' Checks](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html#health-checks-deleting.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' If you're using AWS Cloud Map and you configured Cloud Map to create a
#' Route 53 health check when you register an instance, you can't use the
#' Route 53 `DeleteHealthCheck` command to delete the health check. The
#' health check is deleted automatically when you deregister the instance;
#' there can be a delay of several hours before the health check is deleted
#' from Route 53.
#'
#' @usage
#' route53_delete_health_check(HealthCheckId)
#'
#' @param HealthCheckId &#91;required&#93; The ID of the health check that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_health_check(
#'   HealthCheckId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_health_check
route53_delete_health_check <- function(HealthCheckId) {
  op <- new_operation(
    name = "DeleteHealthCheck",
    http_method = "DELETE",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$delete_health_check_input(HealthCheckId = HealthCheckId)
  output <- .route53$delete_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_health_check <- route53_delete_health_check

#' Deletes a hosted zone
#'
#' @description
#' Deletes a hosted zone.
#' 
#' If the hosted zone was created by another service, such as AWS Cloud
#' Map, see [Deleting Public Hosted Zones That Were Created by Another
#' Service](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html#delete-public-hosted-zone-created-by-another-service)
#' in the *Amazon Route 53 Developer Guide* for information about how to
#' delete it. (The process is the same for public and private hosted zones
#' that were created by another service.)
#' 
#' If you want to keep your domain registration but you want to stop
#' routing internet traffic to your website or web application, we
#' recommend that you delete resource record sets in the hosted zone
#' instead of deleting the hosted zone.
#' 
#' If you delete a hosted zone, you can't undelete it. You must create a
#' new hosted zone and update the name servers for your domain
#' registration, which can require up to 48 hours to take effect. (If you
#' delegated responsibility for a subdomain to a hosted zone and you delete
#' the child hosted zone, you must update the name servers in the parent
#' hosted zone.) In addition, if you delete a hosted zone, someone could
#' hijack the domain and route traffic to their own resources using your
#' domain name.
#' 
#' If you want to avoid the monthly charge for the hosted zone, you can
#' transfer DNS service for the domain to a free DNS service. When you
#' transfer DNS service, you have to update the name servers for the domain
#' registration. If the domain is registered with Route 53, see
#' [UpdateDomainNameservers](https://docs.aws.amazon.com/Route53/latest/APIReference/API_domains_UpdateDomainNameservers.html)
#' for information about how to replace Route 53 name servers with name
#' servers for the new DNS service. If the domain is registered with
#' another registrar, use the method provided by the registrar to update
#' name servers for the domain registration. For more information, perform
#' an internet search on "free DNS service."
#' 
#' You can delete a hosted zone only if it contains only the default SOA
#' record and NS resource record sets. If the hosted zone contains other
#' resource record sets, you must delete them before you can delete the
#' hosted zone. If you try to delete a hosted zone that contains other
#' resource record sets, the request fails, and Route 53 returns a
#' `HostedZoneNotEmpty` error. For information about deleting records from
#' your hosted zone, see
#' [ChangeResourceRecordSets](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html).
#' 
#' To verify that the hosted zone has been deleted, do one of the
#' following:
#' 
#' -   Use the `GetHostedZone` action to request information about the
#'     hosted zone.
#' 
#' -   Use the `ListHostedZones` action to get a list of the hosted zones
#'     associated with the current AWS account.
#'
#' @usage
#' route53_delete_hosted_zone(Id)
#'
#' @param Id &#91;required&#93; The ID of the hosted zone you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_hosted_zone(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_hosted_zone
route53_delete_hosted_zone <- function(Id) {
  op <- new_operation(
    name = "DeleteHostedZone",
    http_method = "DELETE",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$delete_hosted_zone_input(Id = Id)
  output <- .route53$delete_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_hosted_zone <- route53_delete_hosted_zone

#' Deletes a key signing key (KSK)
#'
#' @description
#' Deletes a key signing key (KSK). Before you can delete a KSK, you must
#' deactivate it. The KSK must be deactived before you can delete it
#' regardless of whether the hosted zone is enabled for DNSSEC signing.
#'
#' @usage
#' route53_delete_key_signing_key(HostedZoneId, Name)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#' @param Name &#91;required&#93; An alphanumeric string used to identify a key signing key (KSK).
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_signing_key(
#'   HostedZoneId = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_key_signing_key
route53_delete_key_signing_key <- function(HostedZoneId, Name) {
  op <- new_operation(
    name = "DeleteKeySigningKey",
    http_method = "DELETE",
    http_path = "/2013-04-01/keysigningkey/{HostedZoneId}/{Name}",
    paginator = list()
  )
  input <- .route53$delete_key_signing_key_input(HostedZoneId = HostedZoneId, Name = Name)
  output <- .route53$delete_key_signing_key_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_key_signing_key <- route53_delete_key_signing_key

#' Deletes a configuration for DNS query logging
#'
#' @description
#' Deletes a configuration for DNS query logging. If you delete a
#' configuration, Amazon Route 53 stops sending query logs to CloudWatch
#' Logs. Route 53 doesn't delete any logs that are already in CloudWatch
#' Logs.
#' 
#' For more information about DNS query logs, see
#' [CreateQueryLoggingConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
#'
#' @usage
#' route53_delete_query_logging_config(Id)
#'
#' @param Id &#91;required&#93; The ID of the configuration that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_query_logging_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_query_logging_config
route53_delete_query_logging_config <- function(Id) {
  op <- new_operation(
    name = "DeleteQueryLoggingConfig",
    http_method = "DELETE",
    http_path = "/2013-04-01/queryloggingconfig/{Id}",
    paginator = list()
  )
  input <- .route53$delete_query_logging_config_input(Id = Id)
  output <- .route53$delete_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_query_logging_config <- route53_delete_query_logging_config

#' Deletes a reusable delegation set
#'
#' @description
#' Deletes a reusable delegation set.
#' 
#' You can delete a reusable delegation set only if it isn't associated
#' with any hosted zones.
#' 
#' To verify that the reusable delegation set is not associated with any
#' hosted zones, submit a
#' [GetReusableDelegationSet](https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html)
#' request and specify the ID of the reusable delegation set that you want
#' to delete.
#'
#' @usage
#' route53_delete_reusable_delegation_set(Id)
#'
#' @param Id &#91;required&#93; The ID of the reusable delegation set that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_reusable_delegation_set(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_reusable_delegation_set
route53_delete_reusable_delegation_set <- function(Id) {
  op <- new_operation(
    name = "DeleteReusableDelegationSet",
    http_method = "DELETE",
    http_path = "/2013-04-01/delegationset/{Id}",
    paginator = list()
  )
  input <- .route53$delete_reusable_delegation_set_input(Id = Id)
  output <- .route53$delete_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_reusable_delegation_set <- route53_delete_reusable_delegation_set

#' Deletes a traffic policy
#'
#' @description
#' Deletes a traffic policy.
#' 
#' When you delete a traffic policy, Route 53 sets a flag on the policy to
#' indicate that it has been deleted. However, Route 53 never fully deletes
#' the traffic policy. Note the following:
#' 
#' -   Deleted traffic policies aren't listed if you run
#'     [ListTrafficPolicies](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html).
#' 
#' -   There's no way to get a list of deleted policies.
#' 
#' -   If you retain the ID of the policy, you can get information about
#'     the policy, including the traffic policy document, by running
#'     [GetTrafficPolicy](https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html).
#'
#' @usage
#' route53_delete_traffic_policy(Id, Version)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy that you want to delete.
#' @param Version &#91;required&#93; The version number of the traffic policy that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_policy(
#'   Id = "string",
#'   Version = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_traffic_policy
route53_delete_traffic_policy <- function(Id, Version) {
  op <- new_operation(
    name = "DeleteTrafficPolicy",
    http_method = "DELETE",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$delete_traffic_policy_input(Id = Id, Version = Version)
  output <- .route53$delete_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_traffic_policy <- route53_delete_traffic_policy

#' Deletes a traffic policy instance and all of the resource record sets
#' that Amazon Route 53 created when you created the instance
#'
#' @description
#' Deletes a traffic policy instance and all of the resource record sets
#' that Amazon Route 53 created when you created the instance.
#' 
#' In the Route 53 console, traffic policy instances are known as policy
#' records.
#'
#' @usage
#' route53_delete_traffic_policy_instance(Id)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to delete.
#' 
#' When you delete a traffic policy instance, Amazon Route 53 also deletes
#' all of the resource record sets that were created when you created the
#' traffic policy instance.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_policy_instance(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_traffic_policy_instance
route53_delete_traffic_policy_instance <- function(Id) {
  op <- new_operation(
    name = "DeleteTrafficPolicyInstance",
    http_method = "DELETE",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$delete_traffic_policy_instance_input(Id = Id)
  output <- .route53$delete_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_traffic_policy_instance <- route53_delete_traffic_policy_instance

#' Removes authorization to submit an AssociateVPCWithHostedZone request to
#' associate a specified VPC with a hosted zone that was created by a
#' different account
#'
#' @description
#' Removes authorization to submit an `AssociateVPCWithHostedZone` request
#' to associate a specified VPC with a hosted zone that was created by a
#' different account. You must use the account that created the hosted zone
#' to submit a `DeleteVPCAssociationAuthorization` request.
#' 
#' Sending this request only prevents the AWS account that created the VPC
#' from associating the VPC with the Amazon Route 53 hosted zone in the
#' future. If the VPC is already associated with the hosted zone,
#' `DeleteVPCAssociationAuthorization` won't disassociate the VPC from the
#' hosted zone. If you want to delete an existing association, use
#' `DisassociateVPCFromHostedZone`.
#'
#' @usage
#' route53_delete_vpc_association_authorization(HostedZoneId, VPC)
#'
#' @param HostedZoneId &#91;required&#93; When removing authorization to associate a VPC that was created by one
#' AWS account with a hosted zone that was created with a different AWS
#' account, the ID of the hosted zone.
#' @param VPC &#91;required&#93; When removing authorization to associate a VPC that was created by one
#' AWS account with a hosted zone that was created with a different AWS
#' account, a complex type that includes the ID and region of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_association_authorization(
#'   HostedZoneId = "string",
#'   VPC = list(
#'     VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'     VPCId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_delete_vpc_association_authorization
route53_delete_vpc_association_authorization <- function(HostedZoneId, VPC) {
  op <- new_operation(
    name = "DeleteVPCAssociationAuthorization",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/deauthorizevpcassociation",
    paginator = list()
  )
  input <- .route53$delete_vpc_association_authorization_input(HostedZoneId = HostedZoneId, VPC = VPC)
  output <- .route53$delete_vpc_association_authorization_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$delete_vpc_association_authorization <- route53_delete_vpc_association_authorization

#' Disables DNSSEC signing in a specific hosted zone
#'
#' @description
#' Disables DNSSEC signing in a specific hosted zone. This action does not
#' deactivate any key signing keys (KSKs) that are active in the hosted
#' zone.
#'
#' @usage
#' route53_disable_hosted_zone_dnssec(HostedZoneId)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$disable_hosted_zone_dnssec(
#'   HostedZoneId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_disable_hosted_zone_dnssec
route53_disable_hosted_zone_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "DisableHostedZoneDNSSEC",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/disable-dnssec",
    paginator = list()
  )
  input <- .route53$disable_hosted_zone_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$disable_hosted_zone_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$disable_hosted_zone_dnssec <- route53_disable_hosted_zone_dnssec

#' Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an
#' Amazon Route 53 private hosted zone
#'
#' @description
#' Disassociates an Amazon Virtual Private Cloud (Amazon VPC) from an
#' Amazon Route 53 private hosted zone. Note the following:
#' 
#' -   You can't disassociate the last Amazon VPC from a private hosted
#'     zone.
#' 
#' -   You can't convert a private hosted zone into a public hosted zone.
#' 
#' -   You can submit a `DisassociateVPCFromHostedZone` request using
#'     either the account that created the hosted zone or the account that
#'     created the Amazon VPC.
#' 
#' -   Some services, such as AWS Cloud Map and Amazon Elastic File System
#'     (Amazon EFS) automatically create hosted zones and associate VPCs
#'     with the hosted zones. A service can create a hosted zone using your
#'     account or using its own account. You can disassociate a VPC from a
#'     hosted zone only if the service created the hosted zone using your
#'     account.
#' 
#'     When you run
#'     [DisassociateVPCFromHostedZone](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html),
#'     if the hosted zone has a value for `OwningAccount`, you can use
#'     `DisassociateVPCFromHostedZone`. If the hosted zone has a value for
#'     `OwningService`, you can't use `DisassociateVPCFromHostedZone`.
#'
#' @usage
#' route53_disassociate_vpc_from_hosted_zone(HostedZoneId, VPC, Comment)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the private hosted zone that you want to disassociate a VPC
#' from.
#' @param VPC &#91;required&#93; A complex type that contains information about the VPC that you're
#' disassociating from the specified hosted zone.
#' @param Comment *Optional:* A comment about the disassociation request.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_vpc_from_hosted_zone(
#'   HostedZoneId = "string",
#'   VPC = list(
#'     VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'     VPCId = "string"
#'   ),
#'   Comment = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_disassociate_vpc_from_hosted_zone
route53_disassociate_vpc_from_hosted_zone <- function(HostedZoneId, VPC, Comment = NULL) {
  op <- new_operation(
    name = "DisassociateVPCFromHostedZone",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/disassociatevpc",
    paginator = list()
  )
  input <- .route53$disassociate_vpc_from_hosted_zone_input(HostedZoneId = HostedZoneId, VPC = VPC, Comment = Comment)
  output <- .route53$disassociate_vpc_from_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$disassociate_vpc_from_hosted_zone <- route53_disassociate_vpc_from_hosted_zone

#' Enables DNSSEC signing in a specific hosted zone
#'
#' @description
#' Enables DNSSEC signing in a specific hosted zone.
#'
#' @usage
#' route53_enable_hosted_zone_dnssec(HostedZoneId)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$enable_hosted_zone_dnssec(
#'   HostedZoneId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_enable_hosted_zone_dnssec
route53_enable_hosted_zone_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "EnableHostedZoneDNSSEC",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}/enable-dnssec",
    paginator = list()
  )
  input <- .route53$enable_hosted_zone_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$enable_hosted_zone_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$enable_hosted_zone_dnssec <- route53_enable_hosted_zone_dnssec

#' Gets the specified limit for the current account, for example, the
#' maximum number of health checks that you can create using the account
#'
#' @description
#' Gets the specified limit for the current account, for example, the
#' maximum number of health checks that you can create using the account.
#' 
#' For the default limit, see
#' [Limits](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
#' in the *Amazon Route 53 Developer Guide*. To request a higher limit,
#' open a case.
#' 
#' You can also view account limits in AWS Trusted Advisor. Sign in to the
#' AWS Management Console and open the Trusted Advisor console at
#' https://console.aws.amazon.com/trustedadvisor/. Then choose **Service
#' limits** in the navigation pane.
#'
#' @usage
#' route53_get_account_limit(Type)
#'
#' @param Type &#91;required&#93; The limit that you want to get. Valid values include the following:
#' 
#' -   **MAX\\_HEALTH\\_CHECKS\\_BY\\_OWNER**: The maximum number of health
#'     checks that you can create using the current account.
#' 
#' -   **MAX\\_HOSTED\\_ZONES\\_BY\\_OWNER**: The maximum number of hosted
#'     zones that you can create using the current account.
#' 
#' -   **MAX\\_REUSABLE\\_DELEGATION\\_SETS\\_BY\\_OWNER**: The maximum number
#'     of reusable delegation sets that you can create using the current
#'     account.
#' 
#' -   **MAX\\_TRAFFIC\\_POLICIES\\_BY\\_OWNER**: The maximum number of traffic
#'     policies that you can create using the current account.
#' 
#' -   **MAX\\_TRAFFIC\\_POLICY\\_INSTANCES\\_BY\\_OWNER**: The maximum number
#'     of traffic policy instances that you can create using the current
#'     account. (Traffic policy instances are referred to as traffic flow
#'     policy records in the Amazon Route 53 console.)
#'
#' @section Request syntax:
#' ```
#' svc$get_account_limit(
#'   Type = "MAX_HEALTH_CHECKS_BY_OWNER"|"MAX_HOSTED_ZONES_BY_OWNER"|"MAX_TRAFFIC_POLICY_INSTANCES_BY_OWNER"|"MAX_REUSABLE_DELEGATION_SETS_BY_OWNER"|"MAX_TRAFFIC_POLICIES_BY_OWNER"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_account_limit
route53_get_account_limit <- function(Type) {
  op <- new_operation(
    name = "GetAccountLimit",
    http_method = "GET",
    http_path = "/2013-04-01/accountlimit/{Type}",
    paginator = list()
  )
  input <- .route53$get_account_limit_input(Type = Type)
  output <- .route53$get_account_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_account_limit <- route53_get_account_limit

#' Returns the current status of a change batch request
#'
#' @description
#' Returns the current status of a change batch request. The status is one
#' of the following values:
#' 
#' -   `PENDING` indicates that the changes in this request have not
#'     propagated to all Amazon Route 53 DNS servers. This is the initial
#'     status of all change batch requests.
#' 
#' -   `INSYNC` indicates that the changes have propagated to all Route 53
#'     DNS servers.
#'
#' @usage
#' route53_get_change(Id)
#'
#' @param Id &#91;required&#93; The ID of the change batch request. The value that you specify here is
#' the value that `ChangeResourceRecordSets` returned in the `Id` element
#' when you submitted the request.
#'
#' @section Request syntax:
#' ```
#' svc$get_change(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_change
route53_get_change <- function(Id) {
  op <- new_operation(
    name = "GetChange",
    http_method = "GET",
    http_path = "/2013-04-01/change/{Id}",
    paginator = list()
  )
  input <- .route53$get_change_input(Id = Id)
  output <- .route53$get_change_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_change <- route53_get_change

#' GetCheckerIpRanges still works, but we recommend that you download
#' ip-ranges
#'
#' @description
#' `GetCheckerIpRanges` still works, but we recommend that you download
#' ip-ranges.json, which includes IP address ranges for all AWS services.
#' For more information, see [IP Address Ranges of Amazon Route 53
#' Servers](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-ip-addresses.html)
#' in the *Amazon Route 53 Developer Guide*.
#'
#' @usage
#' route53_get_checker_ip_ranges()
#'
#' @section Request syntax:
#' ```
#' svc$get_checker_ip_ranges()
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_checker_ip_ranges
route53_get_checker_ip_ranges <- function() {
  op <- new_operation(
    name = "GetCheckerIpRanges",
    http_method = "GET",
    http_path = "/2013-04-01/checkeripranges",
    paginator = list()
  )
  input <- .route53$get_checker_ip_ranges_input()
  output <- .route53$get_checker_ip_ranges_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_checker_ip_ranges <- route53_get_checker_ip_ranges

#' Returns information about DNSSEC for a specific hosted zone, including
#' the key signing keys (KSKs) and zone signing keys (ZSKs) in the hosted
#' zone
#'
#' @description
#' Returns information about DNSSEC for a specific hosted zone, including
#' the key signing keys (KSKs) and zone signing keys (ZSKs) in the hosted
#' zone.
#'
#' @usage
#' route53_get_dnssec(HostedZoneId)
#'
#' @param HostedZoneId &#91;required&#93; A unique string used to identify a hosted zone.
#'
#' @section Request syntax:
#' ```
#' svc$get_dnssec(
#'   HostedZoneId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_dnssec
route53_get_dnssec <- function(HostedZoneId) {
  op <- new_operation(
    name = "GetDNSSEC",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/dnssec",
    paginator = list()
  )
  input <- .route53$get_dnssec_input(HostedZoneId = HostedZoneId)
  output <- .route53$get_dnssec_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_dnssec <- route53_get_dnssec

#' Gets information about whether a specified geographic location is
#' supported for Amazon Route 53 geolocation resource record sets
#'
#' @description
#' Gets information about whether a specified geographic location is
#' supported for Amazon Route 53 geolocation resource record sets.
#' 
#' Use the following syntax to determine whether a continent is supported
#' for geolocation:
#' 
#' `GET /2013-04-01/geolocation?continentcode=<i>two-letter abbreviation for a continent</i> `
#' 
#' Use the following syntax to determine whether a country is supported for
#' geolocation:
#' 
#' `GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i> `
#' 
#' Use the following syntax to determine whether a subdivision of a country
#' is supported for geolocation:
#' 
#' `GET /2013-04-01/geolocation?countrycode=<i>two-character country code</i>&amp;subdivisioncode=<i>subdivision code</i> `
#'
#' @usage
#' route53_get_geo_location(ContinentCode, CountryCode, SubdivisionCode)
#'
#' @param ContinentCode For geolocation resource record sets, a two-letter abbreviation that
#' identifies a continent. Amazon Route 53 supports the following continent
#' codes:
#' 
#' -   **AF**: Africa
#' 
#' -   **AN**: Antarctica
#' 
#' -   **AS**: Asia
#' 
#' -   **EU**: Europe
#' 
#' -   **OC**: Oceania
#' 
#' -   **NA**: North America
#' 
#' -   **SA**: South America
#' @param CountryCode Amazon Route 53 uses the two-letter country codes that are specified in
#' [ISO standard 3166-1
#' alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
#' @param SubdivisionCode For `SubdivisionCode`, Amazon Route 53 supports only states of the
#' United States. For a list of state abbreviations, see Appendix B:
#' Two–Letter State and Possession Abbreviations on the United States
#' Postal Service website.
#' 
#' If you specify `subdivisioncode`, you must also specify `US` for
#' `CountryCode`.
#'
#' @section Request syntax:
#' ```
#' svc$get_geo_location(
#'   ContinentCode = "string",
#'   CountryCode = "string",
#'   SubdivisionCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_geo_location
route53_get_geo_location <- function(ContinentCode = NULL, CountryCode = NULL, SubdivisionCode = NULL) {
  op <- new_operation(
    name = "GetGeoLocation",
    http_method = "GET",
    http_path = "/2013-04-01/geolocation",
    paginator = list()
  )
  input <- .route53$get_geo_location_input(ContinentCode = ContinentCode, CountryCode = CountryCode, SubdivisionCode = SubdivisionCode)
  output <- .route53$get_geo_location_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_geo_location <- route53_get_geo_location

#' Gets information about a specified health check
#'
#' @description
#' Gets information about a specified health check.
#'
#' @usage
#' route53_get_health_check(HealthCheckId)
#'
#' @param HealthCheckId &#91;required&#93; The identifier that Amazon Route 53 assigned to the health check when
#' you created it. When you add or update a resource record set, you use
#' this value to specify which health check to use. The value can be up to
#' 64 characters long.
#'
#' @section Request syntax:
#' ```
#' svc$get_health_check(
#'   HealthCheckId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check
route53_get_health_check <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheck",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$get_health_check_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check <- route53_get_health_check

#' Retrieves the number of health checks that are associated with the
#' current AWS account
#'
#' @description
#' Retrieves the number of health checks that are associated with the
#' current AWS account.
#'
#' @usage
#' route53_get_health_check_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_health_check_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_count
route53_get_health_check_count <- function() {
  op <- new_operation(
    name = "GetHealthCheckCount",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheckcount",
    paginator = list()
  )
  input <- .route53$get_health_check_count_input()
  output <- .route53$get_health_check_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_count <- route53_get_health_check_count

#' Gets the reason that a specified health check failed most recently
#'
#' @description
#' Gets the reason that a specified health check failed most recently.
#'
#' @usage
#' route53_get_health_check_last_failure_reason(HealthCheckId)
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check for which you want the last failure reason.
#' When you created the health check, `CreateHealthCheck` returned the ID
#' in the response, in the `HealthCheckId` element.
#' 
#' If you want to get the last failure reason for a calculated health
#' check, you must use the Amazon Route 53 console or the CloudWatch
#' console. You can't use `GetHealthCheckLastFailureReason` for a
#' calculated health check.
#'
#' @section Request syntax:
#' ```
#' svc$get_health_check_last_failure_reason(
#'   HealthCheckId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_last_failure_reason
route53_get_health_check_last_failure_reason <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheckLastFailureReason",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
    paginator = list()
  )
  input <- .route53$get_health_check_last_failure_reason_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_last_failure_reason_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_last_failure_reason <- route53_get_health_check_last_failure_reason

#' Gets status of a specified health check
#'
#' @description
#' Gets status of a specified health check.
#'
#' @usage
#' route53_get_health_check_status(HealthCheckId)
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check that you want the current status for. When
#' you created the health check, `CreateHealthCheck` returned the ID in the
#' response, in the `HealthCheckId` element.
#' 
#' If you want to check the status of a calculated health check, you must
#' use the Amazon Route 53 console or the CloudWatch console. You can't use
#' `GetHealthCheckStatus` to get the status of a calculated health check.
#'
#' @section Request syntax:
#' ```
#' svc$get_health_check_status(
#'   HealthCheckId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_health_check_status
route53_get_health_check_status <- function(HealthCheckId) {
  op <- new_operation(
    name = "GetHealthCheckStatus",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}/status",
    paginator = list()
  )
  input <- .route53$get_health_check_status_input(HealthCheckId = HealthCheckId)
  output <- .route53$get_health_check_status_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_health_check_status <- route53_get_health_check_status

#' Gets information about a specified hosted zone including the four name
#' servers assigned to the hosted zone
#'
#' @description
#' Gets information about a specified hosted zone including the four name
#' servers assigned to the hosted zone.
#'
#' @usage
#' route53_get_hosted_zone(Id)
#'
#' @param Id &#91;required&#93; The ID of the hosted zone that you want to get information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_hosted_zone(
#'   Id = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example gets information about the Z3M3LMPEXAMPLE hosted
#' # zone.
#' svc$get_hosted_zone(
#'   Id = "Z3M3LMPEXAMPLE"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone
route53_get_hosted_zone <- function(Id) {
  op <- new_operation(
    name = "GetHostedZone",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_input(Id = Id)
  output <- .route53$get_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone <- route53_get_hosted_zone

#' Retrieves the number of hosted zones that are associated with the
#' current AWS account
#'
#' @description
#' Retrieves the number of hosted zones that are associated with the
#' current AWS account.
#'
#' @usage
#' route53_get_hosted_zone_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_hosted_zone_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone_count
route53_get_hosted_zone_count <- function() {
  op <- new_operation(
    name = "GetHostedZoneCount",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonecount",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_count_input()
  output <- .route53$get_hosted_zone_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone_count <- route53_get_hosted_zone_count

#' Gets the specified limit for a specified hosted zone, for example, the
#' maximum number of records that you can create in the hosted zone
#'
#' @description
#' Gets the specified limit for a specified hosted zone, for example, the
#' maximum number of records that you can create in the hosted zone.
#' 
#' For the default limit, see
#' [Limits](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
#' in the *Amazon Route 53 Developer Guide*. To request a higher limit,
#' open a case.
#'
#' @usage
#' route53_get_hosted_zone_limit(Type, HostedZoneId)
#'
#' @param Type &#91;required&#93; The limit that you want to get. Valid values include the following:
#' 
#' -   **MAX\\_RRSETS\\_BY\\_ZONE**: The maximum number of records that you
#'     can create in the specified hosted zone.
#' 
#' -   **MAX\\_VPCS\\_ASSOCIATED\\_BY\\_ZONE**: The maximum number of Amazon
#'     VPCs that you can associate with the specified private hosted zone.
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to get a limit for.
#'
#' @section Request syntax:
#' ```
#' svc$get_hosted_zone_limit(
#'   Type = "MAX_RRSETS_BY_ZONE"|"MAX_VPCS_ASSOCIATED_BY_ZONE",
#'   HostedZoneId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_hosted_zone_limit
route53_get_hosted_zone_limit <- function(Type, HostedZoneId) {
  op <- new_operation(
    name = "GetHostedZoneLimit",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonelimit/{Id}/{Type}",
    paginator = list()
  )
  input <- .route53$get_hosted_zone_limit_input(Type = Type, HostedZoneId = HostedZoneId)
  output <- .route53$get_hosted_zone_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_hosted_zone_limit <- route53_get_hosted_zone_limit

#' Gets information about a specified configuration for DNS query logging
#'
#' @description
#' Gets information about a specified configuration for DNS query logging.
#' 
#' For more information about DNS query logs, see
#' [CreateQueryLoggingConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html)
#' and [Logging DNS
#' Queries](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html).
#'
#' @usage
#' route53_get_query_logging_config(Id)
#'
#' @param Id &#91;required&#93; The ID of the configuration for DNS query logging that you want to get
#' information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_query_logging_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_query_logging_config
route53_get_query_logging_config <- function(Id) {
  op <- new_operation(
    name = "GetQueryLoggingConfig",
    http_method = "GET",
    http_path = "/2013-04-01/queryloggingconfig/{Id}",
    paginator = list()
  )
  input <- .route53$get_query_logging_config_input(Id = Id)
  output <- .route53$get_query_logging_config_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_query_logging_config <- route53_get_query_logging_config

#' Retrieves information about a specified reusable delegation set,
#' including the four name servers that are assigned to the delegation set
#'
#' @description
#' Retrieves information about a specified reusable delegation set,
#' including the four name servers that are assigned to the delegation set.
#'
#' @usage
#' route53_get_reusable_delegation_set(Id)
#'
#' @param Id &#91;required&#93; The ID of the reusable delegation set that you want to get a list of
#' name servers for.
#'
#' @section Request syntax:
#' ```
#' svc$get_reusable_delegation_set(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_reusable_delegation_set
route53_get_reusable_delegation_set <- function(Id) {
  op <- new_operation(
    name = "GetReusableDelegationSet",
    http_method = "GET",
    http_path = "/2013-04-01/delegationset/{Id}",
    paginator = list()
  )
  input <- .route53$get_reusable_delegation_set_input(Id = Id)
  output <- .route53$get_reusable_delegation_set_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_reusable_delegation_set <- route53_get_reusable_delegation_set

#' Gets the maximum number of hosted zones that you can associate with the
#' specified reusable delegation set
#'
#' @description
#' Gets the maximum number of hosted zones that you can associate with the
#' specified reusable delegation set.
#' 
#' For the default limit, see
#' [Limits](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html)
#' in the *Amazon Route 53 Developer Guide*. To request a higher limit,
#' open a case.
#'
#' @usage
#' route53_get_reusable_delegation_set_limit(Type, DelegationSetId)
#'
#' @param Type &#91;required&#93; Specify `MAX_ZONES_BY_REUSABLE_DELEGATION_SET` to get the maximum number
#' of hosted zones that you can associate with the specified reusable
#' delegation set.
#' @param DelegationSetId &#91;required&#93; The ID of the delegation set that you want to get the limit for.
#'
#' @section Request syntax:
#' ```
#' svc$get_reusable_delegation_set_limit(
#'   Type = "MAX_ZONES_BY_REUSABLE_DELEGATION_SET",
#'   DelegationSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_reusable_delegation_set_limit
route53_get_reusable_delegation_set_limit <- function(Type, DelegationSetId) {
  op <- new_operation(
    name = "GetReusableDelegationSetLimit",
    http_method = "GET",
    http_path = "/2013-04-01/reusabledelegationsetlimit/{Id}/{Type}",
    paginator = list()
  )
  input <- .route53$get_reusable_delegation_set_limit_input(Type = Type, DelegationSetId = DelegationSetId)
  output <- .route53$get_reusable_delegation_set_limit_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_reusable_delegation_set_limit <- route53_get_reusable_delegation_set_limit

#' Gets information about a specific traffic policy version
#'
#' @description
#' Gets information about a specific traffic policy version.
#' 
#' For information about how of deleting a traffic policy affects the
#' response from `GetTrafficPolicy`, see
#' [DeleteTrafficPolicy](https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html).
#'
#' @usage
#' route53_get_traffic_policy(Id, Version)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy that you want to get information about.
#' @param Version &#91;required&#93; The version number of the traffic policy that you want to get
#' information about.
#'
#' @section Request syntax:
#' ```
#' svc$get_traffic_policy(
#'   Id = "string",
#'   Version = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy
route53_get_traffic_policy <- function(Id, Version) {
  op <- new_operation(
    name = "GetTrafficPolicy",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_input(Id = Id, Version = Version)
  output <- .route53$get_traffic_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy <- route53_get_traffic_policy

#' Gets information about a specified traffic policy instance
#'
#' @description
#' Gets information about a specified traffic policy instance.
#' 
#' After you submit a `CreateTrafficPolicyInstance` or an
#' `UpdateTrafficPolicyInstance` request, there's a brief delay while
#' Amazon Route 53 creates the resource record sets that are specified in
#' the traffic policy definition. For more information, see the `State`
#' response element.
#' 
#' In the Route 53 console, traffic policy instances are known as policy
#' records.
#'
#' @usage
#' route53_get_traffic_policy_instance(Id)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to get information
#' about.
#'
#' @section Request syntax:
#' ```
#' svc$get_traffic_policy_instance(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy_instance
route53_get_traffic_policy_instance <- function(Id) {
  op <- new_operation(
    name = "GetTrafficPolicyInstance",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_instance_input(Id = Id)
  output <- .route53$get_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy_instance <- route53_get_traffic_policy_instance

#' Gets the number of traffic policy instances that are associated with the
#' current AWS account
#'
#' @description
#' Gets the number of traffic policy instances that are associated with the
#' current AWS account.
#'
#' @usage
#' route53_get_traffic_policy_instance_count()
#'
#' @section Request syntax:
#' ```
#' svc$get_traffic_policy_instance_count()
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_get_traffic_policy_instance_count
route53_get_traffic_policy_instance_count <- function() {
  op <- new_operation(
    name = "GetTrafficPolicyInstanceCount",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstancecount",
    paginator = list()
  )
  input <- .route53$get_traffic_policy_instance_count_input()
  output <- .route53$get_traffic_policy_instance_count_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$get_traffic_policy_instance_count <- route53_get_traffic_policy_instance_count

#' Retrieves a list of supported geographic locations
#'
#' @description
#' Retrieves a list of supported geographic locations.
#' 
#' Countries are listed first, and continents are listed last. If Amazon
#' Route 53 supports subdivisions for a country (for example, states or
#' provinces), the subdivisions for that country are listed in alphabetical
#' order immediately after the corresponding country.
#' 
#' For a list of supported geolocation codes, see the
#' [GeoLocation](https://docs.aws.amazon.com/Route53/latest/APIReference/API_GeoLocation.html)
#' data type.
#'
#' @usage
#' route53_list_geo_locations(StartContinentCode, StartCountryCode,
#'   StartSubdivisionCode, MaxItems)
#'
#' @param StartContinentCode The code for the continent with which you want to start listing
#' locations that Amazon Route 53 supports for geolocation. If Route 53 has
#' already returned a page or more of results, if `IsTruncated` is true,
#' and if `NextContinentCode` from the previous response has a value, enter
#' that value in `startcontinentcode` to return the next page of results.
#' 
#' Include `startcontinentcode` only if you want to list continents. Don't
#' include `startcontinentcode` when you're listing countries or countries
#' with their subdivisions.
#' @param StartCountryCode The code for the country with which you want to start listing locations
#' that Amazon Route 53 supports for geolocation. If Route 53 has already
#' returned a page or more of results, if `IsTruncated` is `true`, and if
#' `NextCountryCode` from the previous response has a value, enter that
#' value in `startcountrycode` to return the next page of results.
#' @param StartSubdivisionCode The code for the state of the United States with which you want to start
#' listing locations that Amazon Route 53 supports for geolocation. If
#' Route 53 has already returned a page or more of results, if
#' `IsTruncated` is `true`, and if `NextSubdivisionCode` from the previous
#' response has a value, enter that value in `startsubdivisioncode` to
#' return the next page of results.
#' 
#' To list subdivisions (U.S. states), you must include both
#' `startcountrycode` and `startsubdivisioncode`.
#' @param MaxItems (Optional) The maximum number of geolocations to be included in the
#' response body for this request. If more than `maxitems` geolocations
#' remain to be listed, then the value of the `IsTruncated` element in the
#' response is `true`.
#'
#' @section Request syntax:
#' ```
#' svc$list_geo_locations(
#'   StartContinentCode = "string",
#'   StartCountryCode = "string",
#'   StartSubdivisionCode = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_geo_locations
route53_list_geo_locations <- function(StartContinentCode = NULL, StartCountryCode = NULL, StartSubdivisionCode = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGeoLocations",
    http_method = "GET",
    http_path = "/2013-04-01/geolocations",
    paginator = list()
  )
  input <- .route53$list_geo_locations_input(StartContinentCode = StartContinentCode, StartCountryCode = StartCountryCode, StartSubdivisionCode = StartSubdivisionCode, MaxItems = MaxItems)
  output <- .route53$list_geo_locations_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_geo_locations <- route53_list_geo_locations

#' Retrieve a list of the health checks that are associated with the
#' current AWS account
#'
#' @description
#' Retrieve a list of the health checks that are associated with the
#' current AWS account.
#'
#' @usage
#' route53_list_health_checks(Marker, MaxItems)
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more health checks. To get another group, submit another
#' `ListHealthChecks` request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first health check that Amazon
#' Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more health checks to get.
#' @param MaxItems The maximum number of health checks that you want `ListHealthChecks` to
#' return in response to the current request. Amazon Route 53 returns a
#' maximum of 100 items. If you set `MaxItems` to a value greater than 100,
#' Route 53 returns only the first 100 health checks.
#'
#' @section Request syntax:
#' ```
#' svc$list_health_checks(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_health_checks
route53_list_health_checks <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListHealthChecks",
    http_method = "GET",
    http_path = "/2013-04-01/healthcheck",
    paginator = list()
  )
  input <- .route53$list_health_checks_input(Marker = Marker, MaxItems = MaxItems)
  output <- .route53$list_health_checks_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_health_checks <- route53_list_health_checks

#' Retrieves a list of the public and private hosted zones that are
#' associated with the current AWS account
#'
#' @description
#' Retrieves a list of the public and private hosted zones that are
#' associated with the current AWS account. The response includes a
#' `HostedZones` child element for each hosted zone.
#' 
#' Amazon Route 53 returns a maximum of 100 items in each response. If you
#' have a lot of hosted zones, you can use the `maxitems` parameter to list
#' them in groups of up to 100.
#'
#' @usage
#' route53_list_hosted_zones(Marker, MaxItems, DelegationSetId)
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more hosted zones. To get more hosted zones, submit another
#' `ListHostedZones` request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first hosted zone that Amazon
#' Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more hosted zones to get.
#' @param MaxItems (Optional) The maximum number of hosted zones that you want Amazon Route
#' 53 to return. If you have more than `maxitems` hosted zones, the value
#' of `IsTruncated` in the response is `true`, and the value of
#' `NextMarker` is the hosted zone ID of the first hosted zone that Route
#' 53 will return if you submit another request.
#' @param DelegationSetId If you're using reusable delegation sets and you want to list all of the
#' hosted zones that are associated with a reusable delegation set, specify
#' the ID of that reusable delegation set.
#'
#' @section Request syntax:
#' ```
#' svc$list_hosted_zones(
#'   Marker = "string",
#'   MaxItems = "string",
#'   DelegationSetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones
route53_list_hosted_zones <- function(Marker = NULL, MaxItems = NULL, DelegationSetId = NULL) {
  op <- new_operation(
    name = "ListHostedZones",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_input(Marker = Marker, MaxItems = MaxItems, DelegationSetId = DelegationSetId)
  output <- .route53$list_hosted_zones_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones <- route53_list_hosted_zones

#' Retrieves a list of your hosted zones in lexicographic order
#'
#' @description
#' Retrieves a list of your hosted zones in lexicographic order. The
#' response includes a `HostedZones` child element for each hosted zone
#' created by the current AWS account.
#' 
#' `ListHostedZonesByName` sorts hosted zones by name with the labels
#' reversed. For example:
#' 
#' `com.example.www.`
#' 
#' Note the trailing dot, which can change the sort order in some
#' circumstances.
#' 
#' If the domain name includes escape characters or Punycode,
#' `ListHostedZonesByName` alphabetizes the domain name using the escaped
#' or Punycoded value, which is the format that Amazon Route 53 saves in
#' its database. For example, to create a hosted zone for exämple.com, you
#' specify ex\\344mple.com for the domain name. `ListHostedZonesByName`
#' alphabetizes it as:
#' 
#' `com.ex\\344mple.`
#' 
#' The labels are reversed and alphabetized using the escaped value. For
#' more information about valid domain name formats, including
#' internationalized domain names, see [DNS Domain Name
#' Format](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DomainNameFormat.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' Route 53 returns up to 100 items in each response. If you have a lot of
#' hosted zones, use the `MaxItems` parameter to list them in groups of up
#' to 100. The response includes values that help navigate from one group
#' of `MaxItems` hosted zones to the next:
#' 
#' -   The `DNSName` and `HostedZoneId` elements in the response contain
#'     the values, if any, specified for the `dnsname` and `hostedzoneid`
#'     parameters in the request that produced the current response.
#' 
#' -   The `MaxItems` element in the response contains the value, if any,
#'     that you specified for the `maxitems` parameter in the request that
#'     produced the current response.
#' 
#' -   If the value of `IsTruncated` in the response is true, there are
#'     more hosted zones associated with the current AWS account.
#' 
#'     If `IsTruncated` is false, this response includes the last hosted
#'     zone that is associated with the current account. The `NextDNSName`
#'     element and `NextHostedZoneId` elements are omitted from the
#'     response.
#' 
#' -   The `NextDNSName` and `NextHostedZoneId` elements in the response
#'     contain the domain name and the hosted zone ID of the next hosted
#'     zone that is associated with the current AWS account. If you want to
#'     list more hosted zones, make another call to
#'     `ListHostedZonesByName`, and specify the value of `NextDNSName` and
#'     `NextHostedZoneId` in the `dnsname` and `hostedzoneid` parameters,
#'     respectively.
#'
#' @usage
#' route53_list_hosted_zones_by_name(DNSName, HostedZoneId, MaxItems)
#'
#' @param DNSName (Optional) For your first request to `ListHostedZonesByName`, include
#' the `dnsname` parameter only if you want to specify the name of the
#' first hosted zone in the response. If you don't include the `dnsname`
#' parameter, Amazon Route 53 returns all of the hosted zones that were
#' created by the current AWS account, in ASCII order. For subsequent
#' requests, include both `dnsname` and `hostedzoneid` parameters. For
#' `dnsname`, specify the value of `NextDNSName` from the previous
#' response.
#' @param HostedZoneId (Optional) For your first request to `ListHostedZonesByName`, do not
#' include the `hostedzoneid` parameter.
#' 
#' If you have more hosted zones than the value of `maxitems`,
#' `ListHostedZonesByName` returns only the first `maxitems` hosted zones.
#' To get the next group of `maxitems` hosted zones, submit another request
#' to `ListHostedZonesByName` and include both `dnsname` and `hostedzoneid`
#' parameters. For the value of `hostedzoneid`, specify the value of the
#' `NextHostedZoneId` element from the previous response.
#' @param MaxItems The maximum number of hosted zones to be included in the response body
#' for this request. If you have more than `maxitems` hosted zones, then
#' the value of the `IsTruncated` element in the response is true, and the
#' values of `NextDNSName` and `NextHostedZoneId` specify the first hosted
#' zone in the next group of `maxitems` hosted zones.
#'
#' @section Request syntax:
#' ```
#' svc$list_hosted_zones_by_name(
#'   DNSName = "string",
#'   HostedZoneId = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones_by_name
route53_list_hosted_zones_by_name <- function(DNSName = NULL, HostedZoneId = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListHostedZonesByName",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonesbyname",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_by_name_input(DNSName = DNSName, HostedZoneId = HostedZoneId, MaxItems = MaxItems)
  output <- .route53$list_hosted_zones_by_name_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones_by_name <- route53_list_hosted_zones_by_name

#' Lists all the private hosted zones that a specified VPC is associated
#' with, regardless of which AWS account or AWS service owns the hosted
#' zones
#'
#' @description
#' Lists all the private hosted zones that a specified VPC is associated
#' with, regardless of which AWS account or AWS service owns the hosted
#' zones. The `HostedZoneOwner` structure in the response contains one of
#' the following values:
#' 
#' -   An `OwningAccount` element, which contains the account number of
#'     either the current AWS account or another AWS account. Some
#'     services, such as AWS Cloud Map, create hosted zones using the
#'     current account.
#' 
#' -   An `OwningService` element, which identifies the AWS service that
#'     created and owns the hosted zone. For example, if a hosted zone was
#'     created by Amazon Elastic File System (Amazon EFS), the value of
#'     `Owner` is `efs.amazonaws.com`.
#'
#' @usage
#' route53_list_hosted_zones_by_vpc(VPCId, VPCRegion, MaxItems, NextToken)
#'
#' @param VPCId &#91;required&#93; The ID of the Amazon VPC that you want to list hosted zones for.
#' @param VPCRegion &#91;required&#93; For the Amazon VPC that you specified for `VPCId`, the AWS Region that
#' you created the VPC in.
#' @param MaxItems (Optional) The maximum number of hosted zones that you want Amazon Route
#' 53 to return. If the specified VPC is associated with more than
#' `MaxItems` hosted zones, the response includes a `NextToken` element.
#' `NextToken` contains an encrypted token that identifies the first hosted
#' zone that Route 53 will return if you submit another request.
#' @param NextToken If the previous response included a `NextToken` element, the specified
#' VPC is associated with more hosted zones. To get more hosted zones,
#' submit another `ListHostedZonesByVPC` request.
#' 
#' For the value of `NextToken`, specify the value of `NextToken` from the
#' previous response.
#' 
#' If the previous response didn't include a `NextToken` element, there are
#' no more hosted zones to get.
#'
#' @section Request syntax:
#' ```
#' svc$list_hosted_zones_by_vpc(
#'   VPCId = "string",
#'   VPCRegion = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ap-east-1"|"me-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-south-1"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"ca-central-1"|"cn-north-1"|"af-south-1"|"eu-south-1",
#'   MaxItems = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_hosted_zones_by_vpc
route53_list_hosted_zones_by_vpc <- function(VPCId, VPCRegion, MaxItems = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListHostedZonesByVPC",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzonesbyvpc",
    paginator = list()
  )
  input <- .route53$list_hosted_zones_by_vpc_input(VPCId = VPCId, VPCRegion = VPCRegion, MaxItems = MaxItems, NextToken = NextToken)
  output <- .route53$list_hosted_zones_by_vpc_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_hosted_zones_by_vpc <- route53_list_hosted_zones_by_vpc

#' Lists the configurations for DNS query logging that are associated with
#' the current AWS account or the configuration that is associated with a
#' specified hosted zone
#'
#' @description
#' Lists the configurations for DNS query logging that are associated with
#' the current AWS account or the configuration that is associated with a
#' specified hosted zone.
#' 
#' For more information about DNS query logs, see
#' [CreateQueryLoggingConfig](https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html).
#' Additional information, including the format of DNS query logs, appears
#' in [Logging DNS
#' Queries](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html)
#' in the *Amazon Route 53 Developer Guide*.
#'
#' @usage
#' route53_list_query_logging_configs(HostedZoneId, NextToken, MaxResults)
#'
#' @param HostedZoneId (Optional) If you want to list the query logging configuration that is
#' associated with a hosted zone, specify the ID in `HostedZoneId`.
#' 
#' If you don't specify a hosted zone ID, `ListQueryLoggingConfigs` returns
#' all of the configurations that are associated with the current AWS
#' account.
#' @param NextToken (Optional) If the current AWS account has more than `MaxResults` query
#' logging configurations, use `NextToken` to get the second and subsequent
#' pages of results.
#' 
#' For the first `ListQueryLoggingConfigs` request, omit this value.
#' 
#' For the second and subsequent requests, get the value of `NextToken`
#' from the previous response and specify that value for `NextToken` in the
#' request.
#' @param MaxResults (Optional) The maximum number of query logging configurations that you
#' want Amazon Route 53 to return in response to the current request. If
#' the current AWS account has more than `MaxResults` configurations, use
#' the value of
#' [NextToken](https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax)
#' in the response to get the next page of results.
#' 
#' If you don't specify a value for `MaxResults`, Route 53 returns up to
#' 100 configurations.
#'
#' @section Request syntax:
#' ```
#' svc$list_query_logging_configs(
#'   HostedZoneId = "string",
#'   NextToken = "string",
#'   MaxResults = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_query_logging_configs
route53_list_query_logging_configs <- function(HostedZoneId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListQueryLoggingConfigs",
    http_method = "GET",
    http_path = "/2013-04-01/queryloggingconfig",
    paginator = list()
  )
  input <- .route53$list_query_logging_configs_input(HostedZoneId = HostedZoneId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_query_logging_configs_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_query_logging_configs <- route53_list_query_logging_configs

#' Lists the resource record sets in a specified hosted zone
#'
#' @description
#' Lists the resource record sets in a specified hosted zone.
#' 
#' `ListResourceRecordSets` returns up to 100 resource record sets at a
#' time in ASCII order, beginning at a position specified by the `name` and
#' `type` elements.
#' 
#' **Sort order**
#' 
#' `ListResourceRecordSets` sorts results first by DNS name with the labels
#' reversed, for example:
#' 
#' `com.example.www.`
#' 
#' Note the trailing dot, which can change the sort order when the record
#' name contains characters that appear before `.` (decimal 46) in the
#' ASCII table. These characters include the following:
#' `! \" # $ % &amp; \' ( ) * + , -`
#' 
#' When multiple records have the same DNS name, `ListResourceRecordSets`
#' sorts results by the record type.
#' 
#' **Specifying where to start listing records**
#' 
#' You can use the name and type elements to specify the resource record
#' set that the list begins with:
#' 
#' ### If you do not specify Name or Type
#' 
#' The results begin with the first resource record set that the hosted
#' zone contains.
#' 
#' ### If you specify Name but not Type
#' 
#' The results begin with the first resource record set in the list whose
#' name is greater than or equal to `Name`.
#' 
#' ### If you specify Type but not Name
#' 
#' Amazon Route 53 returns the `InvalidInput` error.
#' 
#' ### If you specify both Name and Type
#' 
#' The results begin with the first resource record set in the list whose
#' name is greater than or equal to `Name`, and whose type is greater than
#' or equal to `Type`.
#' 
#' **Resource record sets that are PENDING**
#' 
#' This action returns the most current version of the records. This
#' includes records that are `PENDING`, and that are not yet available on
#' all Route 53 DNS servers.
#' 
#' **Changing resource record sets**
#' 
#' To ensure that you get an accurate listing of the resource record sets
#' for a hosted zone at a point in time, do not submit a
#' `ChangeResourceRecordSets` request while you're paging through the
#' results of a `ListResourceRecordSets` request. If you do, some pages may
#' display results without the latest changes while other pages display
#' results with the latest changes.
#' 
#' **Displaying the next page of results**
#' 
#' If a `ListResourceRecordSets` command returns more than one page of
#' results, the value of `IsTruncated` is `true`. To display the next page
#' of results, get the values of `NextRecordName`, `NextRecordType`, and
#' `NextRecordIdentifier` (if any) from the response. Then submit another
#' `ListResourceRecordSets` request, and specify those values for
#' `StartRecordName`, `StartRecordType`, and `StartRecordIdentifier`.
#'
#' @usage
#' route53_list_resource_record_sets(HostedZoneId, StartRecordName,
#'   StartRecordType, StartRecordIdentifier, MaxItems)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that contains the resource record sets that
#' you want to list.
#' @param StartRecordName The first name in the lexicographic ordering of resource record sets
#' that you want to list. If the specified record name doesn't exist, the
#' results begin with the first resource record set that has a name greater
#' than the value of `name`.
#' @param StartRecordType The type of resource record set to begin the record listing from.
#' 
#' Valid values for basic resource record sets: `A` | `AAAA` | `CAA` |
#' `CNAME` | `MX` | `NAPTR` | `NS` | `PTR` | `SOA` | `SPF` | `SRV` | `TXT`
#' 
#' Values for weighted, latency, geolocation, and failover resource record
#' sets: `A` | `AAAA` | `CAA` | `CNAME` | `MX` | `NAPTR` | `PTR` | `SPF` |
#' `SRV` | `TXT`
#' 
#' Values for alias resource record sets:
#' 
#' -   **API Gateway custom regional API or edge-optimized API**: A
#' 
#' -   **CloudFront distribution**: A or AAAA
#' 
#' -   **Elastic Beanstalk environment that has a regionalized subdomain**:
#'     A
#' 
#' -   **Elastic Load Balancing load balancer**: A | AAAA
#' 
#' -   **S3 bucket**: A
#' 
#' -   **VPC interface VPC endpoint**: A
#' 
#' -   **Another resource record set in this hosted zone:** The type of the
#'     resource record set that the alias references.
#' 
#' Constraint: Specifying `type` without specifying `name` returns an
#' `InvalidInput` error.
#' @param StartRecordIdentifier *Resource record sets that have a routing policy other than simple:* If
#' results were truncated for a given DNS name and type, specify the value
#' of `NextRecordIdentifier` from the previous response to get the next
#' resource record set that has the current DNS name and type.
#' @param MaxItems (Optional) The maximum number of resource records sets to include in the
#' response body for this request. If the response includes more than
#' `maxitems` resource record sets, the value of the `IsTruncated` element
#' in the response is `true`, and the values of the `NextRecordName` and
#' `NextRecordType` elements in the response identify the first resource
#' record set in the next group of `maxitems` resource record sets.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_record_sets(
#'   HostedZoneId = "string",
#'   StartRecordName = "string",
#'   StartRecordType = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'   StartRecordIdentifier = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_resource_record_sets
route53_list_resource_record_sets <- function(HostedZoneId, StartRecordName = NULL, StartRecordType = NULL, StartRecordIdentifier = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListResourceRecordSets",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/rrset",
    paginator = list()
  )
  input <- .route53$list_resource_record_sets_input(HostedZoneId = HostedZoneId, StartRecordName = StartRecordName, StartRecordType = StartRecordType, StartRecordIdentifier = StartRecordIdentifier, MaxItems = MaxItems)
  output <- .route53$list_resource_record_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_resource_record_sets <- route53_list_resource_record_sets

#' Retrieves a list of the reusable delegation sets that are associated
#' with the current AWS account
#'
#' @description
#' Retrieves a list of the reusable delegation sets that are associated
#' with the current AWS account.
#'
#' @usage
#' route53_list_reusable_delegation_sets(Marker, MaxItems)
#'
#' @param Marker If the value of `IsTruncated` in the previous response was `true`, you
#' have more reusable delegation sets. To get another group, submit another
#' `ListReusableDelegationSets` request.
#' 
#' For the value of `marker`, specify the value of `NextMarker` from the
#' previous response, which is the ID of the first reusable delegation set
#' that Amazon Route 53 will return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more reusable delegation sets to get.
#' @param MaxItems The number of reusable delegation sets that you want Amazon Route 53 to
#' return in the response to this request. If you specify a value greater
#' than 100, Route 53 returns only the first 100 reusable delegation sets.
#'
#' @section Request syntax:
#' ```
#' svc$list_reusable_delegation_sets(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_reusable_delegation_sets
route53_list_reusable_delegation_sets <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListReusableDelegationSets",
    http_method = "GET",
    http_path = "/2013-04-01/delegationset",
    paginator = list()
  )
  input <- .route53$list_reusable_delegation_sets_input(Marker = Marker, MaxItems = MaxItems)
  output <- .route53$list_reusable_delegation_sets_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_reusable_delegation_sets <- route53_list_reusable_delegation_sets

#' Lists tags for one health check or hosted zone
#'
#' @description
#' Lists tags for one health check or hosted zone.
#' 
#' For information about using tags for cost allocation, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @usage
#' route53_list_tags_for_resource(ResourceType, ResourceId)
#'
#' @param ResourceType &#91;required&#93; The type of the resource.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceId &#91;required&#93; The ID of the resource for which you want to retrieve tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceType = "healthcheck"|"hostedzone",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_tags_for_resource
route53_list_tags_for_resource <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2013-04-01/tags/{ResourceType}/{ResourceId}",
    paginator = list()
  )
  input <- .route53$list_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .route53$list_tags_for_resource_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_tags_for_resource <- route53_list_tags_for_resource

#' Lists tags for up to 10 health checks or hosted zones
#'
#' @description
#' Lists tags for up to 10 health checks or hosted zones.
#' 
#' For information about using tags for cost allocation, see [Using Cost
#' Allocation
#' Tags](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *AWS Billing and Cost Management User Guide*.
#'
#' @usage
#' route53_list_tags_for_resources(ResourceType, ResourceIds)
#'
#' @param ResourceType &#91;required&#93; The type of the resources.
#' 
#' -   The resource type for health checks is `healthcheck`.
#' 
#' -   The resource type for hosted zones is `hostedzone`.
#' @param ResourceIds &#91;required&#93; A complex type that contains the ResourceId element for each resource
#' for which you want to get a list of tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resources(
#'   ResourceType = "healthcheck"|"hostedzone",
#'   ResourceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_tags_for_resources
route53_list_tags_for_resources <- function(ResourceType, ResourceIds) {
  op <- new_operation(
    name = "ListTagsForResources",
    http_method = "POST",
    http_path = "/2013-04-01/tags/{ResourceType}",
    paginator = list()
  )
  input <- .route53$list_tags_for_resources_input(ResourceType = ResourceType, ResourceIds = ResourceIds)
  output <- .route53$list_tags_for_resources_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_tags_for_resources <- route53_list_tags_for_resources

#' Gets information about the latest version for every traffic policy that
#' is associated with the current AWS account
#'
#' @description
#' Gets information about the latest version for every traffic policy that
#' is associated with the current AWS account. Policies are listed in the
#' order that they were created in.
#' 
#' For information about how of deleting a traffic policy affects the
#' response from `ListTrafficPolicies`, see
#' [DeleteTrafficPolicy](https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html).
#'
#' @usage
#' route53_list_traffic_policies(TrafficPolicyIdMarker, MaxItems)
#'
#' @param TrafficPolicyIdMarker (Conditional) For your first request to `ListTrafficPolicies`, don't
#' include the `TrafficPolicyIdMarker` parameter.
#' 
#' If you have more traffic policies than the value of `MaxItems`,
#' `ListTrafficPolicies` returns only the first `MaxItems` traffic
#' policies. To get the next group of policies, submit another request to
#' `ListTrafficPolicies`. For the value of `TrafficPolicyIdMarker`, specify
#' the value of `TrafficPolicyIdMarker` that was returned in the previous
#' response.
#' @param MaxItems (Optional) The maximum number of traffic policies that you want Amazon
#' Route 53 to return in response to this request. If you have more than
#' `MaxItems` traffic policies, the value of `IsTruncated` in the response
#' is `true`, and the value of `TrafficPolicyIdMarker` is the ID of the
#' first traffic policy that Route 53 will return if you submit another
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$list_traffic_policies(
#'   TrafficPolicyIdMarker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policies
route53_list_traffic_policies <- function(TrafficPolicyIdMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicies",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicies",
    paginator = list()
  )
  input <- .route53$list_traffic_policies_input(TrafficPolicyIdMarker = TrafficPolicyIdMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policies_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policies <- route53_list_traffic_policies

#' Gets information about the traffic policy instances that you created by
#' using the current AWS account
#'
#' @description
#' Gets information about the traffic policy instances that you created by
#' using the current AWS account.
#' 
#' After you submit an `UpdateTrafficPolicyInstance` request, there's a
#' brief delay while Amazon Route 53 creates the resource record sets that
#' are specified in the traffic policy definition. For more information,
#' see the `State` response element.
#' 
#' Route 53 returns a maximum of 100 items in each response. If you have a
#' lot of traffic policy instances, you can use the `MaxItems` parameter to
#' list them in groups of up to 100.
#'
#' @usage
#' route53_list_traffic_policy_instances(HostedZoneIdMarker,
#'   TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker,
#'   MaxItems)
#'
#' @param HostedZoneIdMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstances` request. For the
#' value of `HostedZoneId`, specify the value of `HostedZoneIdMarker` from
#' the previous response, which is the hosted zone ID of the first traffic
#' policy instance in the next group of traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstances` request. For the
#' value of `trafficpolicyinstancename`, specify the value of
#' `TrafficPolicyInstanceNameMarker` from the previous response, which is
#' the name of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstances` request. For the
#' value of `trafficpolicyinstancetype`, specify the value of
#' `TrafficPolicyInstanceTypeMarker` from the previous response, which is
#' the type of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances that you want Amazon
#' Route 53 to return in response to a `ListTrafficPolicyInstances`
#' request. If you have more than `MaxItems` traffic policy instances, the
#' value of the `IsTruncated` element in the response is `true`, and the
#' values of `HostedZoneIdMarker`, `TrafficPolicyInstanceNameMarker`, and
#' `TrafficPolicyInstanceTypeMarker` represent the first traffic policy
#' instance in the next group of `MaxItems` traffic policy instances.
#'
#' @section Request syntax:
#' ```
#' svc$list_traffic_policy_instances(
#'   HostedZoneIdMarker = "string",
#'   TrafficPolicyInstanceNameMarker = "string",
#'   TrafficPolicyInstanceTypeMarker = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances
route53_list_traffic_policy_instances <- function(HostedZoneIdMarker = NULL, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstances",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_input(HostedZoneIdMarker = HostedZoneIdMarker, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances <- route53_list_traffic_policy_instances

#' Gets information about the traffic policy instances that you created in
#' a specified hosted zone
#'
#' @description
#' Gets information about the traffic policy instances that you created in
#' a specified hosted zone.
#' 
#' After you submit a `CreateTrafficPolicyInstance` or an
#' `UpdateTrafficPolicyInstance` request, there's a brief delay while
#' Amazon Route 53 creates the resource record sets that are specified in
#' the traffic policy definition. For more information, see the `State`
#' response element.
#' 
#' Route 53 returns a maximum of 100 items in each response. If you have a
#' lot of traffic policy instances, you can use the `MaxItems` parameter to
#' list them in groups of up to 100.
#'
#' @usage
#' route53_list_traffic_policy_instances_by_hosted_zone(HostedZoneId,
#'   TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker,
#'   MaxItems)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want to list traffic policy instances
#' for.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response is true, you have
#' more traffic policy instances. To get more traffic policy instances,
#' submit another `ListTrafficPolicyInstances` request. For the value of
#' `trafficpolicyinstancename`, specify the value of
#' `TrafficPolicyInstanceNameMarker` from the previous response, which is
#' the name of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response is true, you have
#' more traffic policy instances. To get more traffic policy instances,
#' submit another `ListTrafficPolicyInstances` request. For the value of
#' `trafficpolicyinstancetype`, specify the value of
#' `TrafficPolicyInstanceTypeMarker` from the previous response, which is
#' the type of the first traffic policy instance in the next group of
#' traffic policy instances.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances to be included in the
#' response body for this request. If you have more than `MaxItems` traffic
#' policy instances, the value of the `IsTruncated` element in the response
#' is `true`, and the values of `HostedZoneIdMarker`,
#' `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker`
#' represent the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#'
#' @section Request syntax:
#' ```
#' svc$list_traffic_policy_instances_by_hosted_zone(
#'   HostedZoneId = "string",
#'   TrafficPolicyInstanceNameMarker = "string",
#'   TrafficPolicyInstanceTypeMarker = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances_by_hosted_zone
route53_list_traffic_policy_instances_by_hosted_zone <- function(HostedZoneId, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstancesByHostedZone",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances/hostedzone",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_by_hosted_zone_input(HostedZoneId = HostedZoneId, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_by_hosted_zone_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances_by_hosted_zone <- route53_list_traffic_policy_instances_by_hosted_zone

#' Gets information about the traffic policy instances that you created by
#' using a specify traffic policy version
#'
#' @description
#' Gets information about the traffic policy instances that you created by
#' using a specify traffic policy version.
#' 
#' After you submit a `CreateTrafficPolicyInstance` or an
#' `UpdateTrafficPolicyInstance` request, there's a brief delay while
#' Amazon Route 53 creates the resource record sets that are specified in
#' the traffic policy definition. For more information, see the `State`
#' response element.
#' 
#' Route 53 returns a maximum of 100 items in each response. If you have a
#' lot of traffic policy instances, you can use the `MaxItems` parameter to
#' list them in groups of up to 100.
#'
#' @usage
#' route53_list_traffic_policy_instances_by_policy(TrafficPolicyId,
#'   TrafficPolicyVersion, HostedZoneIdMarker,
#'   TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker,
#'   MaxItems)
#'
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy for which you want to list traffic policy
#' instances.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy for which you want to list traffic
#' policy instances. The version must be associated with the traffic policy
#' that is specified by `TrafficPolicyId`.
#' @param HostedZoneIdMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstancesByPolicy` request.
#' 
#' For the value of `hostedzoneid`, specify the value of
#' `HostedZoneIdMarker` from the previous response, which is the hosted
#' zone ID of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceNameMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstancesByPolicy` request.
#' 
#' For the value of `trafficpolicyinstancename`, specify the value of
#' `TrafficPolicyInstanceNameMarker` from the previous response, which is
#' the name of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param TrafficPolicyInstanceTypeMarker If the value of `IsTruncated` in the previous response was `true`, you
#' have more traffic policy instances. To get more traffic policy
#' instances, submit another `ListTrafficPolicyInstancesByPolicy` request.
#' 
#' For the value of `trafficpolicyinstancetype`, specify the value of
#' `TrafficPolicyInstanceTypeMarker` from the previous response, which is
#' the name of the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#' 
#' If the value of `IsTruncated` in the previous response was `false`,
#' there are no more traffic policy instances to get.
#' @param MaxItems The maximum number of traffic policy instances to be included in the
#' response body for this request. If you have more than `MaxItems` traffic
#' policy instances, the value of the `IsTruncated` element in the response
#' is `true`, and the values of `HostedZoneIdMarker`,
#' `TrafficPolicyInstanceNameMarker`, and `TrafficPolicyInstanceTypeMarker`
#' represent the first traffic policy instance that Amazon Route 53 will
#' return if you submit another request.
#'
#' @section Request syntax:
#' ```
#' svc$list_traffic_policy_instances_by_policy(
#'   TrafficPolicyId = "string",
#'   TrafficPolicyVersion = 123,
#'   HostedZoneIdMarker = "string",
#'   TrafficPolicyInstanceNameMarker = "string",
#'   TrafficPolicyInstanceTypeMarker = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_instances_by_policy
route53_list_traffic_policy_instances_by_policy <- function(TrafficPolicyId, TrafficPolicyVersion, HostedZoneIdMarker = NULL, TrafficPolicyInstanceNameMarker = NULL, TrafficPolicyInstanceTypeMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyInstancesByPolicy",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicyinstances/trafficpolicy",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_instances_by_policy_input(TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion, HostedZoneIdMarker = HostedZoneIdMarker, TrafficPolicyInstanceNameMarker = TrafficPolicyInstanceNameMarker, TrafficPolicyInstanceTypeMarker = TrafficPolicyInstanceTypeMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_instances_by_policy_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_instances_by_policy <- route53_list_traffic_policy_instances_by_policy

#' Gets information about all of the versions for a specified traffic
#' policy
#'
#' @description
#' Gets information about all of the versions for a specified traffic
#' policy.
#' 
#' Traffic policy versions are listed in numerical order by
#' `VersionNumber`.
#'
#' @usage
#' route53_list_traffic_policy_versions(Id, TrafficPolicyVersionMarker,
#'   MaxItems)
#'
#' @param Id &#91;required&#93; Specify the value of `Id` of the traffic policy for which you want to
#' list all versions.
#' @param TrafficPolicyVersionMarker For your first request to `ListTrafficPolicyVersions`, don't include the
#' `TrafficPolicyVersionMarker` parameter.
#' 
#' If you have more traffic policy versions than the value of `MaxItems`,
#' `ListTrafficPolicyVersions` returns only the first group of `MaxItems`
#' versions. To get more traffic policy versions, submit another
#' `ListTrafficPolicyVersions` request. For the value of
#' `TrafficPolicyVersionMarker`, specify the value of
#' `TrafficPolicyVersionMarker` in the previous response.
#' @param MaxItems The maximum number of traffic policy versions that you want Amazon Route
#' 53 to include in the response body for this request. If the specified
#' traffic policy has more than `MaxItems` versions, the value of
#' `IsTruncated` in the response is `true`, and the value of the
#' `TrafficPolicyVersionMarker` element is the ID of the first version that
#' Route 53 will return if you submit another request.
#'
#' @section Request syntax:
#' ```
#' svc$list_traffic_policy_versions(
#'   Id = "string",
#'   TrafficPolicyVersionMarker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_traffic_policy_versions
route53_list_traffic_policy_versions <- function(Id, TrafficPolicyVersionMarker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListTrafficPolicyVersions",
    http_method = "GET",
    http_path = "/2013-04-01/trafficpolicies/{Id}/versions",
    paginator = list()
  )
  input <- .route53$list_traffic_policy_versions_input(Id = Id, TrafficPolicyVersionMarker = TrafficPolicyVersionMarker, MaxItems = MaxItems)
  output <- .route53$list_traffic_policy_versions_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_traffic_policy_versions <- route53_list_traffic_policy_versions

#' Gets a list of the VPCs that were created by other accounts and that can
#' be associated with a specified hosted zone because you've submitted one
#' or more CreateVPCAssociationAuthorization requests
#'
#' @description
#' Gets a list of the VPCs that were created by other accounts and that can
#' be associated with a specified hosted zone because you've submitted one
#' or more `CreateVPCAssociationAuthorization` requests.
#' 
#' The response includes a `VPCs` element with a `VPC` child element for
#' each VPC that can be associated with the hosted zone.
#'
#' @usage
#' route53_list_vpc_association_authorizations(HostedZoneId, NextToken,
#'   MaxResults)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone for which you want a list of VPCs that can be
#' associated with the hosted zone.
#' @param NextToken *Optional*: If a response includes a `NextToken` element, there are more
#' VPCs that can be associated with the specified hosted zone. To get the
#' next page of results, submit another request, and include the value of
#' `NextToken` from the response in the `nexttoken` parameter in another
#' `ListVPCAssociationAuthorizations` request.
#' @param MaxResults *Optional*: An integer that specifies the maximum number of VPCs that
#' you want Amazon Route 53 to return. If you don't specify a value for
#' `MaxResults`, Route 53 returns up to 50 VPCs per page.
#'
#' @section Request syntax:
#' ```
#' svc$list_vpc_association_authorizations(
#'   HostedZoneId = "string",
#'   NextToken = "string",
#'   MaxResults = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_list_vpc_association_authorizations
route53_list_vpc_association_authorizations <- function(HostedZoneId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListVPCAssociationAuthorizations",
    http_method = "GET",
    http_path = "/2013-04-01/hostedzone/{Id}/authorizevpcassociation",
    paginator = list()
  )
  input <- .route53$list_vpc_association_authorizations_input(HostedZoneId = HostedZoneId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .route53$list_vpc_association_authorizations_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$list_vpc_association_authorizations <- route53_list_vpc_association_authorizations

#' Gets the value that Amazon Route 53 returns in response to a DNS request
#' for a specified record name and type
#'
#' @description
#' Gets the value that Amazon Route 53 returns in response to a DNS request
#' for a specified record name and type. You can optionally specify the IP
#' address of a DNS resolver, an EDNS0 client subnet IP address, and a
#' subnet mask.
#'
#' @usage
#' route53_test_dns_answer(HostedZoneId, RecordName, RecordType,
#'   ResolverIP, EDNS0ClientSubnetIP, EDNS0ClientSubnetMask)
#'
#' @param HostedZoneId &#91;required&#93; The ID of the hosted zone that you want Amazon Route 53 to simulate a
#' query for.
#' @param RecordName &#91;required&#93; The name of the resource record set that you want Amazon Route 53 to
#' simulate a query for.
#' @param RecordType &#91;required&#93; The type of the resource record set.
#' @param ResolverIP If you want to simulate a request from a specific DNS resolver, specify
#' the IP address for that resolver. If you omit this value,
#' `TestDnsAnswer` uses the IP address of a DNS resolver in the AWS US East
#' (N. Virginia) Region (`us-east-1`).
#' @param EDNS0ClientSubnetIP If the resolver that you specified for resolverip supports EDNS0,
#' specify the IPv4 or IPv6 address of a client in the applicable location,
#' for example, `192.0.2.44` or `2001:db8:85a3::8a2e:370:7334`.
#' @param EDNS0ClientSubnetMask If you specify an IP address for `edns0clientsubnetip`, you can
#' optionally specify the number of bits of the IP address that you want
#' the checking tool to include in the DNS query. For example, if you
#' specify `192.0.2.44` for `edns0clientsubnetip` and `24` for
#' `edns0clientsubnetmask`, the checking tool will simulate a request from
#' 192.0.2.0/24. The default value is 24 bits for IPv4 addresses and 64
#' bits for IPv6 addresses.
#' 
#' The range of valid values depends on whether `edns0clientsubnetip` is an
#' IPv4 or an IPv6 address:
#' 
#' -   **IPv4**: Specify a value between 0 and 32
#' 
#' -   **IPv6**: Specify a value between 0 and 128
#'
#' @section Request syntax:
#' ```
#' svc$test_dns_answer(
#'   HostedZoneId = "string",
#'   RecordName = "string",
#'   RecordType = "SOA"|"A"|"TXT"|"NS"|"CNAME"|"MX"|"NAPTR"|"PTR"|"SRV"|"SPF"|"AAAA"|"CAA"|"DS",
#'   ResolverIP = "string",
#'   EDNS0ClientSubnetIP = "string",
#'   EDNS0ClientSubnetMask = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_test_dns_answer
route53_test_dns_answer <- function(HostedZoneId, RecordName, RecordType, ResolverIP = NULL, EDNS0ClientSubnetIP = NULL, EDNS0ClientSubnetMask = NULL) {
  op <- new_operation(
    name = "TestDNSAnswer",
    http_method = "GET",
    http_path = "/2013-04-01/testdnsanswer",
    paginator = list()
  )
  input <- .route53$test_dns_answer_input(HostedZoneId = HostedZoneId, RecordName = RecordName, RecordType = RecordType, ResolverIP = ResolverIP, EDNS0ClientSubnetIP = EDNS0ClientSubnetIP, EDNS0ClientSubnetMask = EDNS0ClientSubnetMask)
  output <- .route53$test_dns_answer_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$test_dns_answer <- route53_test_dns_answer

#' Updates an existing health check
#'
#' @description
#' Updates an existing health check. Note that some values can't be
#' updated.
#' 
#' For more information about updating health checks, see [Creating,
#' Updating, and Deleting Health
#' Checks](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html)
#' in the *Amazon Route 53 Developer Guide*.
#'
#' @usage
#' route53_update_health_check(HealthCheckId, HealthCheckVersion,
#'   IPAddress, Port, ResourcePath, FullyQualifiedDomainName, SearchString,
#'   FailureThreshold, Inverted, Disabled, HealthThreshold,
#'   ChildHealthChecks, EnableSNI, Regions, AlarmIdentifier,
#'   InsufficientDataHealthStatus, ResetElements)
#'
#' @param HealthCheckId &#91;required&#93; The ID for the health check for which you want detailed information.
#' When you created the health check, `CreateHealthCheck` returned the ID
#' in the response, in the `HealthCheckId` element.
#' @param HealthCheckVersion A sequential counter that Amazon Route 53 sets to `1` when you create a
#' health check and increments by 1 each time you update settings for the
#' health check.
#' 
#' We recommend that you use `GetHealthCheck` or `ListHealthChecks` to get
#' the current value of `HealthCheckVersion` for the health check that you
#' want to update, and that you include that value in your
#' `UpdateHealthCheck` request. This prevents Route 53 from overwriting an
#' intervening update:
#' 
#' -   If the value in the `UpdateHealthCheck` request matches the value of
#'     `HealthCheckVersion` in the health check, Route 53 updates the
#'     health check with the new settings.
#' 
#' -   If the value of `HealthCheckVersion` in the health check is greater,
#'     the health check was changed after you got the version number. Route
#'     53 does not update the health check, and it returns a
#'     `HealthCheckVersionMismatch` error.
#' @param IPAddress The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route
#' 53 to perform health checks on. If you don't specify a value for
#' `IPAddress`, Route 53 sends a DNS request to resolve the domain name
#' that you specify in `FullyQualifiedDomainName` at the interval that you
#' specify in `RequestInterval`. Using an IP address that is returned by
#' DNS, Route 53 then checks the health of the endpoint.
#' 
#' Use one of the following formats for the value of `IPAddress`:
#' 
#' -   **IPv4 address**: four values between 0 and 255, separated by
#'     periods (.), for example, `192.0.2.44`.
#' 
#' -   **IPv6 address**: eight groups of four hexadecimal values, separated
#'     by colons (:), for example,
#'     `2001:0db8:85a3:0000:0000:abcd:0001:2345`. You can also shorten IPv6
#'     addresses as described in RFC 5952, for example,
#'     `2001:db8:85a3::abcd:1:2345`.
#' 
#' If the endpoint is an EC2 instance, we recommend that you create an
#' Elastic IP address, associate it with your EC2 instance, and specify the
#' Elastic IP address for `IPAddress`. This ensures that the IP address of
#' your instance never changes. For more information, see the applicable
#' documentation:
#' 
#' -   Linux: [Elastic IP Addresses
#'     (EIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#'     in the *Amazon EC2 User Guide for Linux Instances*
#' 
#' -   Windows: [Elastic IP Addresses
#'     (EIP)](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html)
#'     in the *Amazon EC2 User Guide for Windows Instances*
#' 
#' If a health check already has a value for `IPAddress`, you can change
#' the value. However, you can't update an existing health check to add or
#' remove the value of `IPAddress`.
#' 
#' For more information, see
#' [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
#' 
#' Constraints: Route 53 can't check the health of endpoints for which the
#' IP address is in local, private, non-routable, or multicast ranges. For
#' more information about IP addresses for which you can't create health
#' checks, see the following documents:
#' 
#' -   [RFC 5735, Special Use IPv4
#'     Addresses](https://tools.ietf.org/html/rfc5735)
#' 
#' -   [RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address
#'     Space](https://tools.ietf.org/html/rfc6598)
#' 
#' -   [RFC 5156, Special-Use IPv6
#'     Addresses](https://tools.ietf.org/html/rfc5156)
#' @param Port The port on the endpoint that you want Amazon Route 53 to perform health
#' checks on.
#' 
#' Don't specify a value for `Port` when you specify a value for `Type` of
#' `CLOUDWATCH_METRIC` or `CALCULATED`.
#' @param ResourcePath The path that you want Amazon Route 53 to request when performing health
#' checks. The path can be any value for which your endpoint will return an
#' HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
#' the file /docs/route53-health-check.html. You can also include query
#' string parameters, for example, `/welcome.html?language=jp&amp;login=y`.
#' 
#' Specify this value only if you want to change it.
#' @param FullyQualifiedDomainName Amazon Route 53 behavior depends on whether you specify a value for
#' `IPAddress`.
#' 
#' If a health check already has a value for `IPAddress`, you can change
#' the value. However, you can't update an existing health check to add or
#' remove the value of `IPAddress`.
#' 
#' **If you specify a value for** `IPAddress`:
#' 
#' Route 53 sends health check requests to the specified IPv4 or IPv6
#' address and passes the value of `FullyQualifiedDomainName` in the `Host`
#' header for all health checks except TCP health checks. This is typically
#' the fully qualified DNS name of the endpoint on which you want Route 53
#' to perform health checks.
#' 
#' When Route 53 checks the health of an endpoint, here is how it
#' constructs the `Host` header:
#' 
#' -   If you specify a value of `80` for `Port` and `HTTP` or
#'     `HTTP_STR_MATCH` for `Type`, Route 53 passes the value of
#'     `FullyQualifiedDomainName` to the endpoint in the `Host` header.
#' 
#' -   If you specify a value of `443` for `Port` and `HTTPS` or
#'     `HTTPS_STR_MATCH` for `Type`, Route 53 passes the value of
#'     `FullyQualifiedDomainName` to the endpoint in the `Host` header.
#' 
#' -   If you specify another value for `Port` and any value except `TCP`
#'     for `Type`, Route 53 passes *`FullyQualifiedDomainName`:`Port`* to
#'     the endpoint in the `Host` header.
#' 
#' If you don't specify a value for `FullyQualifiedDomainName`, Route 53
#' substitutes the value of `IPAddress` in the `Host` header in each of the
#' above cases.
#' 
#' **If you don't specify a value for** `IPAddress`:
#' 
#' If you don't specify a value for `IPAddress`, Route 53 sends a DNS
#' request to the domain that you specify in `FullyQualifiedDomainName` at
#' the interval you specify in `RequestInterval`. Using an IPv4 address
#' that is returned by DNS, Route 53 then checks the health of the
#' endpoint.
#' 
#' If you don't specify a value for `IPAddress`, Route 53 uses only IPv4 to
#' send health checks to the endpoint. If there's no resource record set
#' with a type of A for the name that you specify for
#' `FullyQualifiedDomainName`, the health check fails with a "DNS
#' resolution failed" error.
#' 
#' If you want to check the health of weighted, latency, or failover
#' resource record sets and you choose to specify the endpoint only by
#' `FullyQualifiedDomainName`, we recommend that you create a separate
#' health check for each endpoint. For example, create a health check for
#' each HTTP server that is serving content for www.example.com. For the
#' value of `FullyQualifiedDomainName`, specify the domain name of the
#' server (such as `us-east-2-www.example.com`), not the name of the
#' resource record sets (www.example.com).
#' 
#' In this configuration, if the value of `FullyQualifiedDomainName`
#' matches the name of the resource record sets and you then associate the
#' health check with those resource record sets, health check results will
#' be unpredictable.
#' 
#' In addition, if the value of `Type` is `HTTP`, `HTTPS`,
#' `HTTP_STR_MATCH`, or `HTTPS_STR_MATCH`, Route 53 passes the value of
#' `FullyQualifiedDomainName` in the `Host` header, as it does when you
#' specify a value for `IPAddress`. If the value of `Type` is `TCP`, Route
#' 53 doesn't pass a `Host` header.
#' @param SearchString If the value of `Type` is `HTTP_STR_MATCH` or `HTTPS_STR_MATCH`, the
#' string that you want Amazon Route 53 to search for in the response body
#' from the specified resource. If the string appears in the response body,
#' Route 53 considers the resource healthy. (You can't change the value of
#' `Type` when you update a health check.)
#' @param FailureThreshold The number of consecutive health checks that an endpoint must pass or
#' fail for Amazon Route 53 to change the current status of the endpoint
#' from unhealthy to healthy or vice versa. For more information, see [How
#' Amazon Route 53 Determines Whether an Endpoint Is
#' Healthy](https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
#' in the *Amazon Route 53 Developer Guide*.
#' 
#' If you don't specify a value for `FailureThreshold`, the default value
#' is three health checks.
#' @param Inverted Specify whether you want Amazon Route 53 to invert the status of a
#' health check, for example, to consider a health check unhealthy when it
#' otherwise would be considered healthy.
#' @param Disabled Stops Route 53 from performing health checks. When you disable a health
#' check, here's what happens:
#' 
#' -   **Health checks that check the health of endpoints:** Route 53 stops
#'     submitting requests to your application, server, or other resource.
#' 
#' -   **Calculated health checks:** Route 53 stops aggregating the status
#'     of the referenced health checks.
#' 
#' -   **Health checks that monitor CloudWatch alarms:** Route 53 stops
#'     monitoring the corresponding CloudWatch metrics.
#' 
#' After you disable a health check, Route 53 considers the status of the
#' health check to always be healthy. If you configured DNS failover, Route
#' 53 continues to route traffic to the corresponding resources. If you
#' want to stop routing traffic to a resource, change the value of
#' [Inverted](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted).
#' 
#' Charges for a health check still apply when the health check is
#' disabled. For more information, see [Amazon Route 53
#' Pricing](https://aws.amazon.com/route53/pricing/).
#' @param HealthThreshold The number of child health checks that are associated with a
#' `CALCULATED` health that Amazon Route 53 must consider healthy for the
#' `CALCULATED` health check to be considered healthy. To specify the child
#' health checks that you want to associate with a `CALCULATED` health
#' check, use the `ChildHealthChecks` and `ChildHealthCheck` elements.
#' 
#' Note the following:
#' 
#' -   If you specify a number greater than the number of child health
#'     checks, Route 53 always considers this health check to be unhealthy.
#' 
#' -   If you specify `0`, Route 53 always considers this health check to
#'     be healthy.
#' @param ChildHealthChecks A complex type that contains one `ChildHealthCheck` element for each
#' health check that you want to associate with a `CALCULATED` health
#' check.
#' @param EnableSNI Specify whether you want Amazon Route 53 to send the value of
#' `FullyQualifiedDomainName` to the endpoint in the `client_hello` message
#' during `TLS` negotiation. This allows the endpoint to respond to `HTTPS`
#' health check requests with the applicable SSL/TLS certificate.
#' 
#' Some endpoints require that HTTPS requests include the host name in the
#' `client_hello` message. If you don't enable SNI, the status of the
#' health check will be SSL alert `handshake_failure`. A health check can
#' also have that status for other reasons. If SNI is enabled and you're
#' still getting the error, check the SSL/TLS configuration on your
#' endpoint and confirm that your certificate is valid.
#' 
#' The SSL/TLS certificate on your endpoint includes a domain name in the
#' `Common Name` field and possibly several more in the
#' `Subject Alternative Names` field. One of the domain names in the
#' certificate should match the value that you specify for
#' `FullyQualifiedDomainName`. If the endpoint responds to the
#' `client_hello` message with a certificate that does not include the
#' domain name that you specified in `FullyQualifiedDomainName`, a health
#' checker will retry the handshake. In the second attempt, the health
#' checker will omit `FullyQualifiedDomainName` from the `client_hello`
#' message.
#' @param Regions A complex type that contains one `Region` element for each region that
#' you want Amazon Route 53 health checkers to check the specified endpoint
#' from.
#' @param AlarmIdentifier A complex type that identifies the CloudWatch alarm that you want Amazon
#' Route 53 health checkers to use to determine whether the specified
#' health check is healthy.
#' @param InsufficientDataHealthStatus When CloudWatch has insufficient data about the metric to determine the
#' alarm state, the status that you want Amazon Route 53 to assign to the
#' health check:
#' 
#' -   `Healthy`: Route 53 considers the health check to be healthy.
#' 
#' -   `Unhealthy`: Route 53 considers the health check to be unhealthy.
#' 
#' -   `LastKnownStatus`: Route 53 uses the status of the health check from
#'     the last time CloudWatch had sufficient data to determine the alarm
#'     state. For new health checks that have no last known status, the
#'     default status for the health check is healthy.
#' @param ResetElements A complex type that contains one `ResettableElementName` element for
#' each element that you want to reset to the default value. Valid values
#' for `ResettableElementName` include the following:
#' 
#' -   `ChildHealthChecks`: Amazon Route 53 resets
#'     [ChildHealthChecks](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks)
#'     to null.
#' 
#' -   `FullyQualifiedDomainName`: Route 53 resets
#'     [FullyQualifiedDomainName](https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName).
#'     to null.
#' 
#' -   `Regions`: Route 53 resets the
#'     [Regions](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions)
#'     list to the default set of regions.
#' 
#' -   `ResourcePath`: Route 53 resets
#'     [ResourcePath](https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath)
#'     to null.
#'
#' @section Request syntax:
#' ```
#' svc$update_health_check(
#'   HealthCheckId = "string",
#'   HealthCheckVersion = 123,
#'   IPAddress = "string",
#'   Port = 123,
#'   ResourcePath = "string",
#'   FullyQualifiedDomainName = "string",
#'   SearchString = "string",
#'   FailureThreshold = 123,
#'   Inverted = TRUE|FALSE,
#'   Disabled = TRUE|FALSE,
#'   HealthThreshold = 123,
#'   ChildHealthChecks = list(
#'     "string"
#'   ),
#'   EnableSNI = TRUE|FALSE,
#'   Regions = list(
#'     "us-east-1"|"us-west-1"|"us-west-2"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"
#'   ),
#'   AlarmIdentifier = list(
#'     Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"ap-east-1"|"me-south-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-northwest-1"|"cn-north-1"|"af-south-1"|"eu-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1",
#'     Name = "string"
#'   ),
#'   InsufficientDataHealthStatus = "Healthy"|"Unhealthy"|"LastKnownStatus",
#'   ResetElements = list(
#'     "FullyQualifiedDomainName"|"Regions"|"ResourcePath"|"ChildHealthChecks"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_update_health_check
route53_update_health_check <- function(HealthCheckId, HealthCheckVersion = NULL, IPAddress = NULL, Port = NULL, ResourcePath = NULL, FullyQualifiedDomainName = NULL, SearchString = NULL, FailureThreshold = NULL, Inverted = NULL, Disabled = NULL, HealthThreshold = NULL, ChildHealthChecks = NULL, EnableSNI = NULL, Regions = NULL, AlarmIdentifier = NULL, InsufficientDataHealthStatus = NULL, ResetElements = NULL) {
  op <- new_operation(
    name = "UpdateHealthCheck",
    http_method = "POST",
    http_path = "/2013-04-01/healthcheck/{HealthCheckId}",
    paginator = list()
  )
  input <- .route53$update_health_check_input(HealthCheckId = HealthCheckId, HealthCheckVersion = HealthCheckVersion, IPAddress = IPAddress, Port = Port, ResourcePath = ResourcePath, FullyQualifiedDomainName = FullyQualifiedDomainName, SearchString = SearchString, FailureThreshold = FailureThreshold, Inverted = Inverted, Disabled = Disabled, HealthThreshold = HealthThreshold, ChildHealthChecks = ChildHealthChecks, EnableSNI = EnableSNI, Regions = Regions, AlarmIdentifier = AlarmIdentifier, InsufficientDataHealthStatus = InsufficientDataHealthStatus, ResetElements = ResetElements)
  output <- .route53$update_health_check_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_health_check <- route53_update_health_check

#' Updates the comment for a specified hosted zone
#'
#' @description
#' Updates the comment for a specified hosted zone.
#'
#' @usage
#' route53_update_hosted_zone_comment(Id, Comment)
#'
#' @param Id &#91;required&#93; The ID for the hosted zone that you want to update the comment for.
#' @param Comment The new comment for the hosted zone. If you don't specify a value for
#' `Comment`, Amazon Route 53 deletes the existing value of the `Comment`
#' element, if any.
#'
#' @section Request syntax:
#' ```
#' svc$update_hosted_zone_comment(
#'   Id = "string",
#'   Comment = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_update_hosted_zone_comment
route53_update_hosted_zone_comment <- function(Id, Comment = NULL) {
  op <- new_operation(
    name = "UpdateHostedZoneComment",
    http_method = "POST",
    http_path = "/2013-04-01/hostedzone/{Id}",
    paginator = list()
  )
  input <- .route53$update_hosted_zone_comment_input(Id = Id, Comment = Comment)
  output <- .route53$update_hosted_zone_comment_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_hosted_zone_comment <- route53_update_hosted_zone_comment

#' Updates the comment for a specified traffic policy version
#'
#' @description
#' Updates the comment for a specified traffic policy version.
#'
#' @usage
#' route53_update_traffic_policy_comment(Id, Version, Comment)
#'
#' @param Id &#91;required&#93; The value of `Id` for the traffic policy that you want to update the
#' comment for.
#' @param Version &#91;required&#93; The value of `Version` for the traffic policy that you want to update
#' the comment for.
#' @param Comment &#91;required&#93; The new comment for the specified traffic policy and version.
#'
#' @section Request syntax:
#' ```
#' svc$update_traffic_policy_comment(
#'   Id = "string",
#'   Version = 123,
#'   Comment = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_update_traffic_policy_comment
route53_update_traffic_policy_comment <- function(Id, Version, Comment) {
  op <- new_operation(
    name = "UpdateTrafficPolicyComment",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicy/{Id}/{Version}",
    paginator = list()
  )
  input <- .route53$update_traffic_policy_comment_input(Id = Id, Version = Version, Comment = Comment)
  output <- .route53$update_traffic_policy_comment_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_traffic_policy_comment <- route53_update_traffic_policy_comment

#' Updates the resource record sets in a specified hosted zone that were
#' created based on the settings in a specified traffic policy version
#'
#' @description
#' Updates the resource record sets in a specified hosted zone that were
#' created based on the settings in a specified traffic policy version.
#' 
#' When you update a traffic policy instance, Amazon Route 53 continues to
#' respond to DNS queries for the root resource record set name (such as
#' example.com) while it replaces one group of resource record sets with
#' another. Route 53 performs the following operations:
#' 
#' 1.  Route 53 creates a new group of resource record sets based on the
#'     specified traffic policy. This is true regardless of how significant
#'     the differences are between the existing resource record sets and
#'     the new resource record sets.
#' 
#' 2.  When all of the new resource record sets have been created, Route 53
#'     starts to respond to DNS queries for the root resource record set
#'     name (such as example.com) by using the new resource record sets.
#' 
#' 3.  Route 53 deletes the old group of resource record sets that are
#'     associated with the root resource record set name.
#'
#' @usage
#' route53_update_traffic_policy_instance(Id, TTL, TrafficPolicyId,
#'   TrafficPolicyVersion)
#'
#' @param Id &#91;required&#93; The ID of the traffic policy instance that you want to update.
#' @param TTL &#91;required&#93; The TTL that you want Amazon Route 53 to assign to all of the updated
#' resource record sets.
#' @param TrafficPolicyId &#91;required&#93; The ID of the traffic policy that you want Amazon Route 53 to use to
#' update resource record sets for the specified traffic policy instance.
#' @param TrafficPolicyVersion &#91;required&#93; The version of the traffic policy that you want Amazon Route 53 to use
#' to update resource record sets for the specified traffic policy
#' instance.
#'
#' @section Request syntax:
#' ```
#' svc$update_traffic_policy_instance(
#'   Id = "string",
#'   TTL = 123,
#'   TrafficPolicyId = "string",
#'   TrafficPolicyVersion = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname route53_update_traffic_policy_instance
route53_update_traffic_policy_instance <- function(Id, TTL, TrafficPolicyId, TrafficPolicyVersion) {
  op <- new_operation(
    name = "UpdateTrafficPolicyInstance",
    http_method = "POST",
    http_path = "/2013-04-01/trafficpolicyinstance/{Id}",
    paginator = list()
  )
  input <- .route53$update_traffic_policy_instance_input(Id = Id, TTL = TTL, TrafficPolicyId = TrafficPolicyId, TrafficPolicyVersion = TrafficPolicyVersion)
  output <- .route53$update_traffic_policy_instance_output()
  config <- get_config()
  svc <- .route53$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53$operations$update_traffic_policy_instance <- route53_update_traffic_policy_instance
