% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_delete_cache_policy}
\alias{cloudfront_delete_cache_policy}
\title{Deletes a cache policy}
\usage{
cloudfront_delete_cache_policy(Id, IfMatch)
}
\arguments{
\item{Id}{[required] The unique identifier for the cache policy that you are deleting. To get
the identifier, you can use \code{ListCachePolicies}.}

\item{IfMatch}{The version of the cache policy that you are deleting. The version is
the cache policy’s \code{ETag} value, which you can get using
\code{ListCachePolicies}, \code{GetCachePolicy}, or \code{GetCachePolicyConfig}.}
}
\description{
Deletes a cache policy.

You cannot delete a cache policy if it’s attached to a cache behavior.
First update your distributions to remove the cache policy from all
cache behaviors, then delete the cache policy.

To delete a cache policy, you must provide the policy’s identifier and
version. To get these values, you can use \code{ListCachePolicies} or
\code{GetCachePolicy}.
}
\section{Request syntax}{
\preformatted{svc$delete_cache_policy(
  Id = "string",
  IfMatch = "string"
)
}
}

\keyword{internal}
