% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_add_tags}
\alias{elbv2_add_tags}
\title{Adds the specified tags to the specified Elastic Load Balancing resource}
\usage{
elbv2_add_tags(ResourceArns, Tags)
}
\arguments{
\item{ResourceArns}{[required] The Amazon Resource Name (ARN) of the resource.}

\item{Tags}{[required] The tags.}
}
\description{
Adds the specified tags to the specified Elastic Load Balancing
resource. You can tag your Application Load Balancers, Network Load
Balancers, Gateway Load Balancers, target groups, listeners, and rules.

Each tag consists of a key and an optional value. If a resource already
has a tag with the same key, \code{AddTags} updates its value.
}
\section{Request syntax}{
\preformatted{svc$add_tags(
  ResourceArns = list(
    "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
\dontrun{
# This example adds the specified tags to the specified load balancer.
svc$add_tags(
  ResourceArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/5..."
  ),
  Tags = list(
    list(
      Key = "project",
      Value = "lima"
    ),
    list(
      Key = "department",
      Value = "digital-media"
    )
  )
)
}

}
\keyword{internal}
