% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_list_operations}
\alias{servicediscovery_list_operations}
\title{Lists operations that match the criteria that you specify}
\usage{
servicediscovery_list_operations(NextToken, MaxResults, Filters)
}
\arguments{
\item{NextToken}{For the first \code{ListOperations} request, omit this value.

If the response contains \code{NextToken}, submit another \code{ListOperations}
request to get the next group of results. Specify the value of
\code{NextToken} from the previous response in the next request.

AWS Cloud Map gets \code{MaxResults} operations and then filters them based
on the specified criteria. It's possible that no operations in the first
\code{MaxResults} operations matched the specified criteria but that
subsequent groups of \code{MaxResults} operations do contain operations that
match the criteria.}

\item{MaxResults}{The maximum number of items that you want AWS Cloud Map to return in the
response to a \code{ListOperations} request. If you don't specify a value for
\code{MaxResults}, AWS Cloud Map returns up to 100 operations.}

\item{Filters}{A complex type that contains specifications for the operations that you
want to list, for example, operations that you started between a
specified start date and end date.

If you specify more than one filter, an operation must match all filters
to be returned by \code{ListOperations}.}
}
\description{
Lists operations that match the criteria that you specify.
}
\section{Request syntax}{
\preformatted{svc$list_operations(
  NextToken = "string",
  MaxResults = 123,
  Filters = list(
    list(
      Name = "NAMESPACE_ID"|"SERVICE_ID"|"STATUS"|"TYPE"|"UPDATE_DATE",
      Values = list(
        "string"
      ),
      Condition = "EQ"|"IN"|"BETWEEN"
    )
  )
)
}
}

\examples{
\dontrun{
# This example gets the operations that have a STATUS of either PENDING or
# SUCCESS.
svc$list_operations(
  Filters = list(
    list(
      Condition = "IN",
      Name = "STATUS",
      Values = list(
        "PENDING",
        "SUCCESS"
      )
    )
  )
)
}

}
\keyword{internal}
