% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_create_virtual_gateway}
\alias{appmesh_create_virtual_gateway}
\title{Creates a virtual gateway}
\usage{
appmesh_create_virtual_gateway(
  clientToken = NULL,
  meshName,
  meshOwner = NULL,
  spec,
  tags = NULL,
  virtualGatewayName
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 36 letters, numbers, hyphens, and
underscores are allowed.}

\item{meshName}{[required] The name of the service mesh to create the virtual gateway in.}

\item{meshOwner}{The Amazon Web Services IAM account ID of the service mesh owner. If the
account ID is not your own, then the account that you specify must share
the mesh with your account before you can create the resource in the
service mesh. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{spec}{[required] The virtual gateway specification to apply.}

\item{tags}{Optional metadata that you can apply to the virtual gateway to assist
with categorization and organization. Each tag consists of a key and an
optional value, both of which you define. Tag keys can have a maximum
character length of 128 characters, and tag values can have a maximum
length of 256 characters.}

\item{virtualGatewayName}{[required] The name to use for the virtual gateway.}
}
\description{
Creates a virtual gateway.

See \url{https://paws-r.github.io/docs/appmesh/create_virtual_gateway.html} for full documentation.
}
\keyword{internal}
