% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_resolver_configs}
\alias{route53resolver_list_resolver_configs}
\title{Retrieves the Resolver configurations that you have defined}
\usage{
route53resolver_list_resolver_configs(MaxResults = NULL, NextToken = NULL)
}
\arguments{
\item{MaxResults}{The maximum number of Resolver configurations that you want to return in
the response to a
\code{\link[=route53resolver_list_resolver_configs]{list_resolver_configs}}
request. If you don't specify a value for \code{MaxResults}, up to 100
Resolver configurations are returned.}

\item{NextToken}{(Optional) If the current Amazon Web Services account has more than
\code{MaxResults} Resolver configurations, use \code{NextToken} to get the second
and subsequent pages of results.

For the first
\code{\link[=route53resolver_list_resolver_configs]{list_resolver_configs}}
request, omit this value.

For the second and subsequent requests, get the value of \code{NextToken}
from the previous response and specify that value for \code{NextToken} in the
request.}
}
\description{
Retrieves the Resolver configurations that you have defined. Route 53 Resolver uses the configurations to manage DNS resolution behavior for your VPCs.

See \url{https://paws-r.github.io/docs/route53resolver/list_resolver_configs.html} for full documentation.
}
\keyword{internal}
