% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_resolver_endpoint}
\alias{route53resolver_create_resolver_endpoint}
\title{Creates a Resolver endpoint}
\usage{
route53resolver_create_resolver_endpoint(
  CreatorRequestId,
  Name = NULL,
  SecurityGroupIds,
  Direction,
  IpAddresses,
  Tags = NULL,
  ResolverEndpointType = NULL,
  OutpostArn = NULL,
  PreferredInstanceType = NULL
)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{Name}{A friendly name that lets you easily find a configuration in the
Resolver dashboard in the Route 53 console.}

\item{SecurityGroupIds}{[required] The ID of one or more security groups that you want to use to control
access to this VPC. The security group that you specify must include one
or more inbound rules (for inbound Resolver endpoints) or outbound rules
(for outbound Resolver endpoints). Inbound and outbound rules must allow
TCP and UDP access. For inbound access, open port 53. For outbound
access, open the port that you're using for DNS queries on your network.}

\item{Direction}{[required] Specify the applicable value:
\itemize{
\item \code{INBOUND}: Resolver forwards DNS queries to the DNS service for a
VPC from your network
\item \code{OUTBOUND}: Resolver forwards DNS queries from the DNS service for a
VPC to your network
}}

\item{IpAddresses}{[required] The subnets and IP addresses in your VPC that DNS queries originate from
(for outbound endpoints) or that you forward DNS queries to (for inbound
endpoints). The subnet ID uniquely identifies a VPC.}

\item{Tags}{A list of the tag keys and values that you want to associate with the
endpoint.}

\item{ResolverEndpointType}{For the endpoint type you can choose either IPv4, IPv6, or dual-stack. A
dual-stack endpoint means that it will resolve via both IPv4 and IPv6.
This endpoint type is applied to all IP addresses.}

\item{OutpostArn}{The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
must also specify a value for the \code{PreferredInstanceType}.}

\item{PreferredInstanceType}{The instance type. If you specify this, you must also specify a value
for the \code{OutpostArn}.}
}
\description{
Creates a Resolver endpoint. There are two types of Resolver endpoints, inbound and outbound:

See \url{https://www.paws-r-sdk.com/docs/route53resolver_create_resolver_endpoint/} for full documentation.
}
\keyword{internal}
