% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appfabric_operations.R
\name{appfabric_create_app_bundle}
\alias{appfabric_create_app_bundle}
\title{Creates an app bundle to collect data from an application using
AppFabric}
\usage{
appfabric_create_app_bundle(
  clientToken = NULL,
  customerManagedKeyIdentifier = NULL,
  tags = NULL
)
}
\arguments{
\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}

\item{customerManagedKeyIdentifier}{The Amazon Resource Name (ARN) of the Key Management Service (KMS) key
to use to encrypt the application data. If this is not specified, an
Amazon Web Services owned key is used for encryption.}

\item{tags}{A map of the key-value pairs of the tag or tags to assign to the
resource.}
}
\description{
Creates an app bundle to collect data from an application using AppFabric.

See \url{https://www.paws-r-sdk.com/docs/appfabric_create_app_bundle/} for full documentation.
}
\keyword{internal}
