% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_list_records}
\alias{cognitosync_list_records}
\title{Gets paginated records, optionally changed after a particular sync count
for a dataset and identity}
\usage{
cognitosync_list_records(IdentityPoolId, IdentityId, DatasetName,
  LastSyncCount, NextToken, MaxResults, SyncSessionToken)
}
\arguments{
\item{IdentityPoolId}{[required] A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.}

\item{IdentityId}{[required] A name-spaced GUID (for example, us-east-1:23EC4050-6AEA-7089-A2DD-08002EXAMPLE) created by Amazon Cognito. GUID generation is unique within a region.}

\item{DatasetName}{[required] A string of up to 128 characters. Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (dash), and '.' (dot).}

\item{LastSyncCount}{The last server sync count for this record.}

\item{NextToken}{A pagination token for obtaining the next page of results.}

\item{MaxResults}{The maximum number of results to be returned.}

\item{SyncSessionToken}{A token containing a session ID, identity ID, and expiration.}
}
\description{
Gets paginated records, optionally changed after a particular sync count
for a dataset and identity. With Amazon Cognito Sync, each identity has
access only to its own data. Thus, the credentials used to make this API
call need to have access to the identity data.

ListRecords can be called with temporary user credentials provided by
Cognito Identity or with developer credentials. You should use Cognito
Identity credentials to make this API call.
}
\section{Request syntax}{
\preformatted{svc$list_records(
  IdentityPoolId = "string",
  IdentityId = "string",
  DatasetName = "string",
  LastSyncCount = 123,
  NextToken = "string",
  MaxResults = 123,
  SyncSessionToken = "string"
)
}
}

\keyword{internal}
