% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acm_operations.R
\name{acm_add_tags_to_certificate}
\alias{acm_add_tags_to_certificate}
\title{Adds one or more tags to an ACM certificate}
\usage{
acm_add_tags_to_certificate(CertificateArn, Tags)
}
\arguments{
\item{CertificateArn}{[required] String that contains the ARN of the ACM certificate to which the tag is
to be applied. This must be of the form:

\code{arn:aws:acm:region:123456789012:certificate/12345678-1234-1234-1234-123456789012}

For more information about ARNs, see \href{https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html}{Amazon Resource Names (ARNs) and AWS Service Namespaces}.}

\item{Tags}{[required] The key-value pair that defines the tag. The tag value is optional.}
}
\value{
An empty list.
}
\description{
Adds one or more tags to an ACM certificate. Tags are labels that you
can use to identify and organize your AWS resources. Each tag consists
of a \code{key} and an optional \code{value}. You specify the certificate on input
by its Amazon Resource Name (ARN). You specify the tag by using a
key-value pair.

You can apply a tag to just one certificate if you want to identify a
specific characteristic of that certificate, or you can apply the same
tag to multiple certificates if you want to filter for a common
relationship among those certificates. Similarly, you can apply the same
tag to multiple resources if you want to specify a relationship among
those resources. For example, you can add the same tag to an ACM
certificate and an Elastic Load Balancing load balancer to indicate that
they are both used by the same website. For more information, see
\href{https://docs.aws.amazon.com/acm/latest/userguide/tags.html}{Tagging ACM certificates}.

To remove one or more tags, use the
\code{\link[=acm_remove_tags_from_certificate]{remove_tags_from_certificate}}
action. To view all of the tags that have been applied to the
certificate, use the
\code{\link[=acm_list_tags_for_certificate]{list_tags_for_certificate}} action.
}
\section{Request syntax}{
\preformatted{svc$add_tags_to_certificate(
  CertificateArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
