% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_delete_user_attributes}
\alias{cognitoidentityprovider_admin_delete_user_attributes}
\title{Deletes the user attributes in a user pool as an administrator}
\usage{
cognitoidentityprovider_admin_delete_user_attributes(UserPoolId,
  Username, UserAttributeNames)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to delete user
attributes.}

\item{Username}{[required] The user name of the user from which you would like to delete
attributes.}

\item{UserAttributeNames}{[required] An array of strings representing the user attribute names you wish to
delete.

For custom attributes, you must prepend the \verb{custom:} prefix to the
attribute name.}
}
\value{
An empty list.
}
\description{
Deletes the user attributes in a user pool as an administrator. Works on
any user.

Calling this action requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_delete_user_attributes(
  UserPoolId = "string",
  Username = "string",
  UserAttributeNames = list(
    "string"
  )
)
}
}

\keyword{internal}
