% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_describe_user_pool_client}
\alias{cognitoidentityprovider_describe_user_pool_client}
\title{Client method for returning the configuration information and metadata
of the specified user pool app client}
\usage{
cognitoidentityprovider_describe_user_pool_client(UserPoolId, ClientId)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool you want to describe.}

\item{ClientId}{[required] The app client ID of the app associated with the user pool.}
}
\value{
A list with the following syntax:\preformatted{list(
  UserPoolClient = list(
    UserPoolId = "string",
    ClientName = "string",
    ClientId = "string",
    ClientSecret = "string",
    LastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    CreationDate = as.POSIXct(
      "2015-01-01"
    ),
    RefreshTokenValidity = 123,
    AccessTokenValidity = 123,
    IdTokenValidity = 123,
    TokenValidityUnits = list(
      AccessToken = "seconds"|"minutes"|"hours"|"days",
      IdToken = "seconds"|"minutes"|"hours"|"days",
      RefreshToken = "seconds"|"minutes"|"hours"|"days"
    ),
    ReadAttributes = list(
      "string"
    ),
    WriteAttributes = list(
      "string"
    ),
    ExplicitAuthFlows = list(
      "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"|"ALLOW_ADMIN_USER_PASSWORD_AUTH"|"ALLOW_CUSTOM_AUTH"|"ALLOW_USER_PASSWORD_AUTH"|"ALLOW_USER_SRP_AUTH"|"ALLOW_REFRESH_TOKEN_AUTH"
    ),
    SupportedIdentityProviders = list(
      "string"
    ),
    CallbackURLs = list(
      "string"
    ),
    LogoutURLs = list(
      "string"
    ),
    DefaultRedirectURI = "string",
    AllowedOAuthFlows = list(
      "code"|"implicit"|"client_credentials"
    ),
    AllowedOAuthScopes = list(
      "string"
    ),
    AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
    AnalyticsConfiguration = list(
      ApplicationId = "string",
      ApplicationArn = "string",
      RoleArn = "string",
      ExternalId = "string",
      UserDataShared = TRUE|FALSE
    ),
    PreventUserExistenceErrors = "LEGACY"|"ENABLED"
  )
)
}
}
\description{
Client method for returning the configuration information and metadata
of the specified user pool app client.
}
\section{Request syntax}{
\preformatted{svc$describe_user_pool_client(
  UserPoolId = "string",
  ClientId = "string"
)
}
}

\keyword{internal}
