% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_certificate}
\alias{directoryservice_describe_certificate}
\title{Displays information about the certificate registered for secure LDAP or
client certificate authentication}
\usage{
directoryservice_describe_certificate(DirectoryId, CertificateId)
}
\arguments{
\item{DirectoryId}{[required] The identifier of the directory.}

\item{CertificateId}{[required] The identifier of the certificate.}
}
\value{
A list with the following syntax:\preformatted{list(
  Certificate = list(
    CertificateId = "string",
    State = "Registering"|"Registered"|"RegisterFailed"|"Deregistering"|"Deregistered"|"DeregisterFailed",
    StateReason = "string",
    CommonName = "string",
    RegisteredDateTime = as.POSIXct(
      "2015-01-01"
    ),
    ExpiryDateTime = as.POSIXct(
      "2015-01-01"
    ),
    Type = "ClientCertAuth"|"ClientLDAPS",
    ClientCertAuthSettings = list(
      OCSPUrl = "string"
    )
  )
)
}
}
\description{
Displays information about the certificate registered for secure LDAP or
client certificate authentication.
}
\section{Request syntax}{
\preformatted{svc$describe_certificate(
  DirectoryId = "string",
  CertificateId = "string"
)
}
}

\keyword{internal}
