% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_list_virtual_mfa_devices}
\alias{iam_list_virtual_mfa_devices}
\title{Lists the virtual MFA devices defined in the AWS account by assignment
status}
\usage{
iam_list_virtual_mfa_devices(AssignmentStatus, Marker, MaxItems)
}
\arguments{
\item{AssignmentStatus}{The status (\code{Unassigned} or \code{Assigned}) of the devices to list. If you
do not specify an \code{AssignmentStatus}, the operation defaults to \code{Any},
which lists both assigned and unassigned virtual MFA devices.,}

\item{Marker}{Use this parameter only when paginating results and only after you
receive a response indicating that the results are truncated. Set it to
the value of the \code{Marker} element in the response that you received to
indicate where the next call should start.}

\item{MaxItems}{Use this only when paginating results to indicate the maximum number of
items you want in the response. If additional items exist beyond the
maximum you specify, the \code{IsTruncated} response element is \code{true}.

If you do not include this parameter, the number of items defaults to
100. Note that IAM might return fewer results, even when there are more
results available. In that case, the \code{IsTruncated} response element
returns \code{true}, and \code{Marker} contains a value to include in the
subsequent call that tells the service where to continue from.}
}
\value{
A list with the following syntax:\preformatted{list(
  VirtualMFADevices = list(
    list(
      SerialNumber = "string",
      Base32StringSeed = raw,
      QRCodePNG = raw,
      User = list(
        Path = "string",
        UserName = "string",
        UserId = "string",
        Arn = "string",
        CreateDate = as.POSIXct(
          "2015-01-01"
        ),
        PasswordLastUsed = as.POSIXct(
          "2015-01-01"
        ),
        PermissionsBoundary = list(
          PermissionsBoundaryType = "PermissionsBoundaryPolicy",
          PermissionsBoundaryArn = "string"
        ),
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        )
      ),
      EnableDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  IsTruncated = TRUE|FALSE,
  Marker = "string"
)
}
}
\description{
Lists the virtual MFA devices defined in the AWS account by assignment
status. If you do not specify an assignment status, the operation
returns a list of all virtual MFA devices. Assignment status can be
\code{Assigned}, \code{Unassigned}, or \code{Any}.

You can paginate the results using the \code{MaxItems} and \code{Marker}
parameters.
}
\section{Request syntax}{
\preformatted{svc$list_virtual_mfa_devices(
  AssignmentStatus = "Assigned"|"Unassigned"|"Any",
  Marker = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following command lists the virtual MFA devices that have been
# configured for the current account.
svc$list_virtual_mfa_devices()
}

}
\keyword{internal}
