# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon GuardDuty
#'
#' @description
#' Amazon GuardDuty is a continuous security monitoring service that
#' analyzes and processes the following data sources: VPC Flow Logs, AWS
#' CloudTrail event logs, and DNS logs. It uses threat intelligence feeds,
#' such as lists of malicious IPs and domains, and machine learning to
#' identify unexpected and potentially unauthorized and malicious activity
#' within your AWS environment. This can include issues like escalations of
#' privileges, uses of exposed credentials, or communication with malicious
#' IPs, URLs, or domains. For example, GuardDuty can detect compromised EC2
#' instances serving malware or mining bitcoin. It also monitors AWS
#' account access behavior for signs of compromise, such as unauthorized
#' infrastructure deployments, like instances deployed in a region that has
#' never been used, or unusual API calls, like a password policy change to
#' reduce password strength. GuardDuty informs you of the status of your
#' AWS environment by producing security findings that you can view in the
#' GuardDuty console or through Amazon CloudWatch events. For more
#' information, see [Amazon GuardDuty User
#' Guide](https://docs.aws.amazon.com/guardduty/latest/ug/what-is-guardduty.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- guardduty(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- guardduty()
#' svc$accept_invitation(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=guardduty_accept_invitation]{accept_invitation} \tab Accepts the invitation to be monitored by a master GuardDuty account \cr
#'  \link[=guardduty_archive_findings]{archive_findings} \tab Archives Amazon GuardDuty findings specified by the list of finding IDs \cr
#'  \link[=guardduty_create_detector]{create_detector} \tab Creates a single Amazon GuardDuty detector \cr
#'  \link[=guardduty_create_filter]{create_filter} \tab Creates a filter using the specified finding criteria \cr
#'  \link[=guardduty_create_ip_set]{create_ip_set} \tab Creates a new IPSet - a list of trusted IP addresses that have been whitelisted for secure communication with AWS infrastructure and applications \cr
#'  \link[=guardduty_create_members]{create_members} \tab Creates member accounts of the current AWS account by specifying a list of AWS account IDs \cr
#'  \link[=guardduty_create_sample_findings]{create_sample_findings} \tab Generates example findings of types specified by the list of finding types \cr
#'  \link[=guardduty_create_threat_intel_set]{create_threat_intel_set} \tab Create a new ThreatIntelSet \cr
#'  \link[=guardduty_decline_invitations]{decline_invitations} \tab Declines invitations sent to the current member account by AWS account specified by their account IDs \cr
#'  \link[=guardduty_delete_detector]{delete_detector} \tab Deletes a Amazon GuardDuty detector specified by the detector ID \cr
#'  \link[=guardduty_delete_filter]{delete_filter} \tab Deletes the filter specified by the filter name \cr
#'  \link[=guardduty_delete_ip_set]{delete_ip_set} \tab Deletes the IPSet specified by the IPSet ID \cr
#'  \link[=guardduty_delete_invitations]{delete_invitations} \tab Deletes invitations sent to the current member account by AWS accounts specified by their account IDs \cr
#'  \link[=guardduty_delete_members]{delete_members} \tab Deletes GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs \cr
#'  \link[=guardduty_delete_threat_intel_set]{delete_threat_intel_set} \tab Deletes ThreatIntelSet specified by the ThreatIntelSet ID \cr
#'  \link[=guardduty_disassociate_from_master_account]{disassociate_from_master_account} \tab Disassociates the current GuardDuty member account from its master account \cr
#'  \link[=guardduty_disassociate_members]{disassociate_members} \tab Disassociates GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs \cr
#'  \link[=guardduty_get_detector]{get_detector} \tab Retrieves an Amazon GuardDuty detector specified by the detectorId \cr
#'  \link[=guardduty_get_filter]{get_filter} \tab Returns the details of the filter specified by the filter name \cr
#'  \link[=guardduty_get_findings]{get_findings} \tab Describes Amazon GuardDuty findings specified by finding IDs \cr
#'  \link[=guardduty_get_findings_statistics]{get_findings_statistics} \tab Lists Amazon GuardDuty findings' statistics for the specified detector ID \cr
#'  \link[=guardduty_get_ip_set]{get_ip_set} \tab Retrieves the IPSet specified by the IPSet ID \cr
#'  \link[=guardduty_get_invitations_count]{get_invitations_count} \tab Returns the count of all GuardDuty membership invitations that were sent to the current member account except the currently accepted invitation \cr
#'  \link[=guardduty_get_master_account]{get_master_account} \tab Provides the details for the GuardDuty master account to the current GuardDuty member account \cr
#'  \link[=guardduty_get_members]{get_members} \tab Retrieves GuardDuty member accounts (to the current GuardDuty master account) specified by the account IDs \cr
#'  \link[=guardduty_get_threat_intel_set]{get_threat_intel_set} \tab Retrieves the ThreatIntelSet that is specified by the ThreatIntelSet ID \cr
#'  \link[=guardduty_invite_members]{invite_members} \tab Invites other AWS accounts (created as members of the current AWS account by CreateMembers) to enable GuardDuty and allow the current AWS account to view and manage these accounts' GuardDuty findings on their behalf as the master account\cr
#'  \link[=guardduty_list_detectors]{list_detectors} \tab Lists detectorIds of all the existing Amazon GuardDuty detector resources \cr
#'  \link[=guardduty_list_filters]{list_filters} \tab Returns a paginated list of the current filters \cr
#'  \link[=guardduty_list_findings]{list_findings} \tab Lists Amazon GuardDuty findings for the specified detector ID \cr
#'  \link[=guardduty_list_ip_sets]{list_ip_sets} \tab Lists the IPSets of the GuardDuty service specified by the detector ID \cr
#'  \link[=guardduty_list_invitations]{list_invitations} \tab Lists all GuardDuty membership invitations that were sent to the current AWS account \cr
#'  \link[=guardduty_list_members]{list_members} \tab Lists details about all member accounts for the current GuardDuty master account \cr
#'  \link[=guardduty_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for a resource \cr
#'  \link[=guardduty_list_threat_intel_sets]{list_threat_intel_sets} \tab Lists the ThreatIntelSets of the GuardDuty service specified by the detector ID \cr
#'  \link[=guardduty_start_monitoring_members]{start_monitoring_members} \tab Re-enables GuardDuty to monitor findings of the member accounts specified by the account IDs \cr
#'  \link[=guardduty_stop_monitoring_members]{stop_monitoring_members} \tab Disables GuardDuty from monitoring findings of the member accounts specified by the account IDs \cr
#'  \link[=guardduty_tag_resource]{tag_resource} \tab Adds tags to a resource \cr
#'  \link[=guardduty_unarchive_findings]{unarchive_findings} \tab Unarchives Amazon GuardDuty findings specified by the list of finding IDs \cr
#'  \link[=guardduty_untag_resource]{untag_resource} \tab Removes tags from a resource \cr
#'  \link[=guardduty_update_detector]{update_detector} \tab Updates an Amazon GuardDuty detector specified by the detectorId \cr
#'  \link[=guardduty_update_filter]{update_filter} \tab Updates the filter specified by the filter name \cr
#'  \link[=guardduty_update_findings_feedback]{update_findings_feedback} \tab Marks specified Amazon GuardDuty findings as useful or not useful \cr
#'  \link[=guardduty_update_ip_set]{update_ip_set} \tab Updates the IPSet specified by the IPSet ID \cr
#'  \link[=guardduty_update_threat_intel_set]{update_threat_intel_set} \tab Updates the ThreatIntelSet specified by ThreatIntelSet ID 
#' }
#'
#' @rdname guardduty
#' @export
guardduty <- function(config = list()) {
  svc <- .guardduty$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.guardduty <- list()

.guardduty$operations <- list()

.guardduty$metadata <- list(
  service_name = "guardduty",
  endpoints = list("*" = list(endpoint = "guardduty.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "guardduty.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "GuardDuty",
  api_version = "2017-11-28",
  signing_name = "guardduty",
  json_version = "1.1",
  target_prefix = ""
)

.guardduty$handlers <- new_handlers("restjson", "v4")

.guardduty$service <- function(config = list()) {
  new_service(.guardduty$metadata, .guardduty$handlers, config)
}
