% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_get_certificate}
\alias{acmpca_get_certificate}
\title{Retrieves a certificate from your private CA}
\usage{
acmpca_get_certificate(CertificateAuthorityArn, CertificateArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must be of the form:

\verb{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{CertificateArn}{[required] The ARN of the issued certificate. The ARN contains the certificate
serial number and must be in the following form:

\verb{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> }}
}
\description{
Retrieves a certificate from your private CA. The ARN of the certificate
is returned when you call the IssueCertificate action. You must specify
both the ARN of your private CA and the ARN of the issued certificate
when calling the \strong{GetCertificate} action. You can retrieve the
certificate if it is in the \strong{ISSUED} state. You can call the
CreateCertificateAuthorityAuditReport action to create a report that
contains information about all of the certificates issued and revoked by
your private CA.
}
\section{Request syntax}{
\preformatted{svc$get_certificate(
  CertificateAuthorityArn = "string",
  CertificateArn = "string"
)
}
}

\keyword{internal}
