% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_sql_injection_match_set}
\alias{wafregional_delete_sql_injection_match_set}
\title{Permanently deletes a SqlInjectionMatchSet}
\usage{
wafregional_delete_sql_injection_match_set(SqlInjectionMatchSetId,
  ChangeToken)
}
\arguments{
\item{SqlInjectionMatchSetId}{[required] The \code{SqlInjectionMatchSetId} of the SqlInjectionMatchSet that you want
to delete. \code{SqlInjectionMatchSetId} is returned by
CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a SqlInjectionMatchSet. You can\'t delete a
\code{SqlInjectionMatchSet} if it\'s still used in any \code{Rules} or if it still
contains any SqlInjectionMatchTuple objects.
}
\details{
If you just want to remove a \code{SqlInjectionMatchSet} from a \code{Rule}, use
UpdateRule.

To permanently delete a \code{SqlInjectionMatchSet} from AWS WAF, perform the
following steps:
\enumerate{
\item Update the \code{SqlInjectionMatchSet} to remove filters, if any. For
more information, see UpdateSqlInjectionMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteSqlInjectionMatchSet} request.
\item Submit a \code{DeleteSqlInjectionMatchSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_sql_injection_match_set(
  SqlInjectionMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\examples{
# The following example deletes a SQL injection match set  with the ID
# example1ds3t-46da-4fdb-b8d5-abc321j569j5.
\donttest{svc$delete_sql_injection_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  SqlInjectionMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)}

}
\keyword{internal}
