% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_associate_web_acl}
\alias{wafregional_associate_web_acl}
\title{Associates a web ACL with a resource, either an application load
balancer or Amazon API Gateway stage}
\usage{
wafregional_associate_web_acl(WebACLId, ResourceArn)
}
\arguments{
\item{WebACLId}{[required] A unique identifier (ID) for the web ACL.}

\item{ResourceArn}{[required] The ARN (Amazon Resource Name) of the resource to be protected, either
an application load balancer or Amazon API Gateway stage.

The ARN should be in one of the following formats:
\itemize{
\item For an Application Load Balancer:
\verb{arn:aws:elasticloadbalancing:<i>region</i>:<i>account-id</i>:loadbalancer/app/<i>load-balancer-name</i>/<i>load-balancer-id</i> }
\item For an Amazon API Gateway stage:
\verb{arn:aws:apigateway:<i>region</i>::/restapis/<i>api-id</i>/stages/<i>stage-name</i> }
}}
}
\description{
Associates a web ACL with a resource, either an application load
balancer or Amazon API Gateway stage.
}
\section{Request syntax}{
\preformatted{svc$associate_web_acl(
  WebACLId = "string",
  ResourceArn = "string"
)
}
}

\keyword{internal}
